/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.http.cors;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tuscany.sca.common.http.cors.CORSConfiguration;

public class CORSHeaderProcessor {
    public static void processCORS(CORSConfiguration config, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (config == null) {
            String allowOrigins;
            String allowMethods;
            String allowHeaders = request.getHeader("Access-Control-Request-Headers");
            if (allowHeaders == null) {
                allowHeaders = "Content-Type, Accept, Origin, X-Requested-With";
            }
            if ((allowMethods = request.getHeader("Access-Control-Request-Method")) == null) {
                allowHeaders = "OPTIONS, HEAD, GET, POST, PUT, DELETE";
            }
            if ((allowOrigins = request.getHeader("Origin")) == null) {
                allowOrigins = "*";
            }
            response.setHeader("Access-Control-Allow-Origin", allowOrigins);
            response.setHeader("Access-Control-Allow-Headers", allowHeaders);
            response.setHeader("Access-Control-Allow-Credentials", "true");
            if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
                response.setHeader("Access-Control-Allow-Methods", allowMethods);
                response.setHeader("Access-Control-Max-Age", "1728000");
            }
            return;
        }
        if (config.isAllowCredentials()) {
            response.setHeader("Access-Control-Allow-Credentials", "true");
        }
        if (config.getMaxAge() > 0) {
            response.setHeader("Access-Control-Max-Age", Integer.toString(config.getMaxAge()));
        }
        response.setHeader("Access-Control-Allow-Origin", CORSHeaderProcessor.getAllowOrigins(config, request));
        response.setHeader("Access-Control-Allow-Methods", CORSHeaderProcessor.getAllowMethods(config));
        response.setHeader("Access-Control-Allow-Headers", CORSHeaderProcessor.getAllowHeaders(config));
        response.setHeader("Access-Control-Expose-Headers", CORSHeaderProcessor.getExposeHeaders(config));
    }

    private static String getAllowOrigins(CORSConfiguration config, HttpServletRequest request) {
        String allowOrigins = request.getHeader("Origin");
        if (allowOrigins == null) {
            allowOrigins = "*";
        }
        return CORSHeaderProcessor.getListValues(config.getAllowOrigins(), allowOrigins);
    }

    private static String getAllowMethods(CORSConfiguration config) {
        return CORSHeaderProcessor.getListValues(config.getAllowMethods(), "OPTIONS, HEAD, GET, POST, PUT, DELETE");
    }

    private static String getAllowHeaders(CORSConfiguration config) {
        return CORSHeaderProcessor.getListValues(config.getAllowHeaders(), "X-Requested-With, Content-Type, Accept, Origin");
    }

    private static String getExposeHeaders(CORSConfiguration config) {
        return CORSHeaderProcessor.getListValues(config.getExposeHeaders(), "X-Requested-With, Content-Type");
    }

    private static String getListValues(List<String> list, String defaultValue) {
        StringBuffer values = new StringBuffer();
        if (list != null && !list.isEmpty()) {
            for (String value : list) {
                values.append(value).append(",");
            }
            values.deleteCharAt(values.length());
        } else {
            values.append(defaultValue);
        }
        return values.toString();
    }
}

