/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.client.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.client.impl.EndpointFinder;
import org.apache.tuscany.sca.client.impl.RemoteServiceInvocationHandler;
import org.apache.tuscany.sca.client.impl.RuntimeUtils;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ExtensionPointRegistryLocator;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.oasisopen.sca.NoSuchDomainException;
import org.oasisopen.sca.NoSuchServiceException;
import org.oasisopen.sca.client.SCAClientFactory;
import org.oasisopen.sca.client.SCAClientFactoryFinder;

public class SCAClientFactoryImpl
extends SCAClientFactory {
    protected ExtensionPointRegistry extensionPointRegistry;
    protected DomainRegistry domainRegistry;
    protected boolean remoteClient;
    protected boolean onlySCABinding;
    private EndpointFinder endpointFinder;
    public static URI default_domainURI = URI.create("default");

    public static SCAClientFactoryFinder getSCAClientFactoryFinder() {
        return SCAClientFactory.factoryFinder;
    }

    public static void setSCAClientFactoryFinder(SCAClientFactoryFinder factoryFinder) {
        SCAClientFactory.factoryFinder = factoryFinder;
    }

    public SCAClientFactoryImpl(URI domainURI) throws NoSuchDomainException {
        super(domainURI == null ? default_domainURI : domainURI);
        this.findLocalRuntime();
        this.endpointFinder = RuntimeUtils.getEndpointFinder(this.extensionPointRegistry);
    }

    public SCAClientFactoryImpl(URI domainURI, Properties properties) throws NoSuchDomainException {
        this(domainURI);
    }

    protected void findLocalRuntime() throws NoSuchDomainException {
        String domainURI = this.getDomainURI().toString();
        for (ExtensionPointRegistry xpr : ExtensionPointRegistryLocator.getExtensionPointRegistries()) {
            ExtensibleDomainRegistryFactory drf = ExtensibleDomainRegistryFactory.getInstance(xpr);
            for (DomainRegistry epr : drf.getEndpointRegistries()) {
                if (!domainURI.equals(epr.getDomainName())) continue;
                this.extensionPointRegistry = xpr;
                this.domainRegistry = epr;
                return;
            }
        }
        this.remoteClient = true;
        this.extensionPointRegistry = RuntimeUtils.createExtensionPointRegistry();
        this.domainRegistry = RuntimeUtils.getClientEndpointRegistry(this.extensionPointRegistry, domainURI);
    }

    @Override
    public <T> T getService(Class<T> serviceInterface, String serviceURI) throws NoSuchServiceException {
        RemoteServiceInvocationHandler handler;
        Endpoint ep;
        if (!this.remoteClient && ((RuntimeComponent)(ep = this.endpointFinder.findEndpoint(this.domainRegistry, serviceURI)).getComponent()).getComponentContext() != null) {
            String serviceName = ep.getService().getName() + '/' + ep.getBinding().getName();
            return ((RuntimeComponent)ep.getComponent()).getServiceReference(serviceInterface, serviceName).getService();
        }
        if (!this.remoteClient) {
            handler = new RemoteServiceInvocationHandler(this.extensionPointRegistry, this.domainRegistry, serviceURI, serviceInterface);
        } else {
            try {
                handler = new RemoteServiceInvocationHandler(this.extensionPointRegistry, this.domainRegistry, this.getDomainURI().toString(), serviceURI, serviceInterface);
            }
            catch (NoSuchDomainException ex) {
                throw new NoSuchServiceException(ex);
            }
        }
        if (serviceInterface == null) {
            serviceInterface = handler.serviceInterface;
        }
        final Class<T> _serviceInterface = serviceInterface;
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return _serviceInterface.getClassLoader();
            }
        });
        return (T)Proxy.newProxyInstance(cl, new Class[]{serviceInterface}, (InvocationHandler)handler);
    }
}

