/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.PolicyBuilder;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySubject;

public class IntentValidator
implements PolicyBuilder {
    public IntentValidator(ExtensionPointRegistry registry) {
    }

    @Override
    public boolean build(Endpoint endpoint, BuilderContext context) {
        return this.checkMutualExclusion(endpoint, context);
    }

    @Override
    public boolean build(EndpointReference endpointReference, BuilderContext context) {
        boolean ok = this.checkMutualExclusion(endpointReference, context);
        if (!ok) {
            return false;
        }
        Endpoint endpoint = endpointReference.getTargetEndpoint();
        if (endpoint == null) {
            return true;
        }
        ok = this.checkMutualExclusion(endpointReference, endpoint, context);
        List<Intent> intentList1 = endpointReference.getRequiredIntents();
        List<Intent> intentList2 = endpoint.getRequiredIntents();
        return ok;
    }

    @Override
    public boolean build(Component component, Implementation implementation, BuilderContext context) {
        return true;
    }

    @Override
    public boolean build(EndpointReference endpointReference, Endpoint endpoint, BuilderContext context) {
        return true;
    }

    @Override
    public QName getPolicyType() {
        return null;
    }

    @Override
    public List<QName> getSupportedBindings() {
        return null;
    }

    private boolean checkMutualExclusion(PolicySubject subject1, PolicySubject subject2, BuilderContext context) {
        if (subject1 == subject2 || subject1 == null || subject2 == null) {
            return false;
        }
        for (Intent i1 : subject1.getRequiredIntents()) {
            for (Intent i2 : subject2.getRequiredIntents()) {
                if (!i1.getExcludedIntents().contains(i2) && !i2.getExcludedIntents().contains(i1)) continue;
                Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "MutuallyExclusiveIntents", new Object[]{subject1, subject2}, i1, i2);
                return true;
            }
        }
        return false;
    }

    private boolean checkMutualExclusion(PolicySubject subject, BuilderContext context) {
        if (subject == null) {
            return false;
        }
        List<Intent> intents = subject.getRequiredIntents();
        int size = intents.size();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                Intent i2;
                Intent i1 = intents.get(i);
                if ((i1 == (i2 = intents.get(j)) || !i1.getExcludedIntents().contains(i2)) && !i2.getExcludedIntents().contains(i1)) continue;
                Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "MutuallyExclusiveIntents", subject, i1, i2);
                return true;
            }
        }
        return false;
    }
}

