/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.Intent;
import org.oasisopen.sca.ServiceRuntimeException;

public class EndpointReferenceBuilderImpl {
    private final Logger logger = Logger.getLogger(EndpointReferenceBuilderImpl.class.getName());
    private AssemblyFactory assemblyFactory;
    private InterfaceContractMapper interfaceContractMapper;

    public EndpointReferenceBuilderImpl(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
    }

    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        this.createEndpointReferences(composite, context);
        this.validateComponentReferences(composite, context.getMonitor());
        return composite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEndpointReferences(Composite composite, BuilderContext context) {
        context.getMonitor().pushContext("Composite: " + composite.getName().toString());
        try {
            for (Component component : composite.getComponents()) {
                context.getMonitor().pushContext("Component: " + component.getName());
                try {
                    Implementation implementation = component.getImplementation();
                    if (implementation instanceof Composite) {
                        this.createEndpointReferences((Composite)implementation, context);
                    }
                    for (ComponentReference reference : component.getReferences()) {
                        this.processComponentReference(composite, component, reference, context);
                        this.fixUpCallbackLinks(component, reference);
                        this.pushDownEndpointReferences(composite, component, reference, context.getMonitor());
                    }
                    this.validateReferenceMultiplicity(composite, component, context.getMonitor());
                }
                finally {
                    context.getMonitor().popContext();
                }
            }
        }
        finally {
            context.getMonitor().popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processComponentReference(Composite composite, Component component, ComponentReference reference, BuilderContext context) {
        block21: {
            context.getMonitor().pushContext("Reference: " + reference.getName());
            try {
                List<ComponentService> refTargets = this.getReferenceTargets(reference);
                if (Boolean.TRUE.equals(reference.getAutowire()) && reference.getTargets().isEmpty()) {
                    Multiplicity multiplicity = reference.getMultiplicity();
                    block6: for (Component targetComponent : composite.getComponents()) {
                        if ((multiplicity == Multiplicity.ZERO_ONE || multiplicity == Multiplicity.ONE_ONE) && reference.getEndpointReferences().size() != 0) break;
                        if (targetComponent == component) continue;
                        for (ComponentService targetComponentService : targetComponent.getServices()) {
                            if (reference.getInterfaceContract() != null && !this.interfaceContractMapper.isCompatibleSubset(reference.getInterfaceContract(), targetComponentService.getInterfaceContract()) || !this.intentsMatch(reference.getRequiredIntents(), targetComponentService.getRequiredIntents())) continue;
                            EndpointReference endpointRef = this.createEndpointRef(component, reference, false);
                            endpointRef.setTargetEndpoint(this.createEndpoint(targetComponent, targetComponentService, true));
                            endpointRef.setStatus(EndpointReference.Status.WIRED_TARGET_NOT_FOUND);
                            reference.getEndpointReferences().add(endpointRef);
                            if (multiplicity != Multiplicity.ZERO_ONE && multiplicity != Multiplicity.ONE_ONE) continue;
                            continue block6;
                        }
                    }
                    if ((multiplicity == Multiplicity.ONE_N || multiplicity == Multiplicity.ONE_ONE) && reference.getEndpointReferences().size() == 0) {
                        Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "NoComponentReferenceTarget", reference.getName());
                    }
                    this.setSingleAutoWireTarget(reference);
                    return;
                }
                if (!refTargets.isEmpty()) {
                    if (this.bindingsIdentifyTargets(reference)) {
                        Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "ReferenceEndPointMixWithTarget", composite.getName().toString(), component.getName(), reference.getName());
                    }
                    for (ComponentService target : refTargets) {
                        Binding binding;
                        EndpointReference endpointRef = this.createEndpointRef(component, reference, true);
                        endpointRef.setTargetEndpoint(this.createEndpoint(component, target.getName()));
                        endpointRef.setStatus(EndpointReference.Status.WIRED_TARGET_NOT_FOUND);
                        reference.getEndpointReferences().add(endpointRef);
                        if (reference.getBindings().size() != 1 || !((binding = reference.getBindings().get(0)) instanceof SCABinding) || binding.getURI() != null) continue;
                        endpointRef.setBinding(binding);
                    }
                }
                if (!reference.getEndpointReferences().isEmpty()) break block21;
                for (Binding binding : reference.getBindings()) {
                    EndpointReference endpointRef;
                    String uri = binding.getURI();
                    if (uri == null) {
                        if (!reference.isForCallback() && binding instanceof SCABinding) continue;
                        endpointRef = this.createEndpointRef(component, reference, binding, null, false);
                        if (binding instanceof SCABinding) {
                            endpointRef.setTargetEndpoint(this.createEndpoint(true));
                            endpointRef.setStatus(EndpointReference.Status.NOT_CONFIGURED);
                        } else {
                            endpointRef.setTargetEndpoint(this.createEndpoint(false));
                            endpointRef.setStatus(EndpointReference.Status.RESOLVED_BINDING);
                        }
                        reference.getEndpointReferences().add(endpointRef);
                        continue;
                    }
                    try {
                        URI tmpURI = new URI(uri);
                        if (tmpURI.isAbsolute()) {
                            EndpointReference endpointRef2 = this.createEndpointRef(component, reference, binding, null, false);
                            endpointRef2.setTargetEndpoint(this.createEndpoint(false));
                            endpointRef2.setStatus(EndpointReference.Status.RESOLVED_BINDING);
                            reference.getEndpointReferences().add(endpointRef2);
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    endpointRef = this.createEndpointRef(component, reference, binding, null, false);
                    Endpoint endpoint = null;
                    String[] parts = this.getSCATargetParts(uri);
                    if (parts != null) {
                        endpoint = this.createEndpoint(component, uri);
                        if (binding instanceof SCABinding) {
                            endpointRef.setBinding(binding);
                        }
                        endpointRef.setStatus(EndpointReference.Status.WIRED_TARGET_IN_BINDING_URI);
                    } else {
                        endpoint = this.createEndpoint(false);
                        endpoint.setURI(uri);
                        endpoint.setBinding(binding);
                        endpoint.setRemote(true);
                        endpointRef.setStatus(EndpointReference.Status.RESOLVED_BINDING);
                    }
                    endpointRef.setTargetEndpoint(endpoint);
                    reference.getEndpointReferences().add(endpointRef);
                }
            }
            finally {
                context.getMonitor().popContext();
            }
        }
    }

    private boolean intentsMatch(List<Intent> referenceIntents, List<Intent> serviceIntents) {
        HashSet<Intent> referenceIntentSet = new HashSet<Intent>(referenceIntents);
        HashSet<Intent> serviceIntentSet = new HashSet<Intent>(serviceIntents);
        return ((Object)referenceIntentSet).equals(serviceIntentSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateComponentReferences(Composite composite, Monitor monitor) {
        monitor.pushContext("Composite: " + composite.getName().toString());
        try {
            for (Component component : composite.getComponents()) {
                monitor.pushContext("Component: " + component.getName());
                try {
                    Implementation implementation = component.getImplementation();
                    if (implementation instanceof Composite) {
                        this.validateComponentReferences((Composite)implementation, monitor);
                    }
                    this.validateReferenceMultiplicity(composite, component, monitor);
                }
                finally {
                    monitor.popContext();
                }
            }
        }
        finally {
            monitor.popContext();
        }
    }

    private void pushDownEndpointReferences(Composite composite, Component component, ComponentReference componentReference, Monitor monitor) {
        Reference reference = componentReference.getReference();
        if (reference instanceof CompositeReference) {
            List<ComponentReference> leafComponentReferences = this.getPromotedComponentReferences((CompositeReference)reference);
            for (ComponentReference leafRef : leafComponentReferences) {
                int insertLocation = 0;
                if (!leafRef.isNonOverridable()) {
                    leafRef.getEndpointReferences().clear();
                }
                for (EndpointReference epr : componentReference.getEndpointReferences()) {
                    EndpointReference eprCopy = this.copyHigherReference(epr, leafRef);
                    leafRef.getEndpointReferences().add(insertLocation, eprCopy);
                    ++insertLocation;
                }
            }
        }
    }

    private List<ComponentReference> getPromotedComponentReferences(CompositeReference compositeReference) {
        ArrayList<ComponentReference> componentReferences = new ArrayList<ComponentReference>();
        this.collectPromotedComponentReferences(compositeReference, componentReferences);
        return componentReferences;
    }

    private void collectPromotedComponentReferences(CompositeReference compositeReference, List<ComponentReference> componentReferences) {
        for (ComponentReference componentReference : compositeReference.getPromotedReferences()) {
            if (componentReference == null) continue;
            Reference reference = componentReference.getReference();
            if (reference instanceof CompositeReference) {
                this.collectPromotedComponentReferences((CompositeReference)reference, componentReferences);
                continue;
            }
            if (reference == null) continue;
            componentReferences.add(componentReference);
        }
    }

    private EndpointReference copyHigherReference(EndpointReference epRef, ComponentReference promotedReference) {
        EndpointReference epRefClone = null;
        try {
            epRefClone = (EndpointReference)epRef.clone();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
        epRefClone.setReference(promotedReference);
        return epRefClone;
    }

    private void validateReferenceMultiplicity(Composite composite, Component component, Monitor monitor) {
        for (ComponentReference componentReference : component.getReferences()) {
            if (this.validateMultiplicity(componentReference.getMultiplicity(), componentReference.getEndpointReferences())) continue;
            if (componentReference.getEndpointReferences().isEmpty()) {
                boolean promoted = false;
                for (Reference reference : composite.getReferences()) {
                    CompositeReference compositeReference = (CompositeReference)reference;
                    if (!compositeReference.getPromotedReferences().contains(componentReference)) continue;
                    promoted = true;
                    break;
                }
                if (promoted || componentReference.isForCallback() || componentReference.isWiredByImpl()) continue;
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "ReferenceWithoutTargets", composite.getName().toString(), componentReference.getName());
                continue;
            }
            if (Boolean.TRUE.equals(componentReference.getAutowire())) break;
            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "TooManyReferenceTargets", componentReference.getName());
        }
    }

    private boolean validateMultiplicity(Multiplicity multiplicity, List<EndpointReference> endpointReferences) {
        if (multiplicity == null) {
            return true;
        }
        int count = endpointReferences.size();
        switch (multiplicity) {
            case ZERO_N: {
                break;
            }
            case ZERO_ONE: {
                if (count <= 1) break;
                return false;
            }
            case ONE_ONE: {
                if (count == 1) break;
                return false;
            }
            case ONE_N: {
                if (count >= 1) break;
                return false;
            }
        }
        return true;
    }

    private boolean bindingsIdentifyTargets(ComponentReference reference) {
        Iterator<Binding> i$ = reference.getBindings().iterator();
        if (i$.hasNext()) {
            Binding binding = i$.next();
            return true;
        }
        return false;
    }

    private List<ComponentService> getReferenceTargets(ComponentReference reference) {
        List<ComponentService> theTargets = reference.getTargets();
        if (theTargets.isEmpty() && reference.getReference() != null) {
            theTargets = reference.getReference().getTargets();
        }
        return theTargets;
    }

    private EndpointReference createEndpointRef(Component component, ComponentReference reference, Binding binding, Endpoint endpoint, boolean unresolved) {
        EndpointReference endpointRef = this.createEndpointRef(component, reference, unresolved);
        endpointRef.setBinding(binding);
        endpointRef.setTargetEndpoint(endpoint);
        return endpointRef;
    }

    private EndpointReference createEndpointRef(Component component, ComponentReference reference, boolean unresolved) {
        EndpointReference endpointRef = this.assemblyFactory.createEndpointReference();
        endpointRef.setComponent(component);
        endpointRef.setReference(reference);
        endpointRef.setUnresolved(unresolved);
        return endpointRef;
    }

    private Endpoint createEndpoint(boolean unresolved) {
        Endpoint endpoint = this.assemblyFactory.createEndpoint();
        endpoint.setUnresolved(unresolved);
        return endpoint;
    }

    private String[] getSCATargetParts(String targetName) {
        String[] parts = targetName.split("/");
        if (parts.length < 1 || parts.length > 3) {
            return null;
        }
        return parts;
    }

    private Endpoint createEndpoint(Component component, String targetName) {
        String[] parts = this.getSCATargetParts(targetName);
        if (parts == null) {
            throw new IllegalArgumentException("Invalid target URI: " + targetName);
        }
        String uri = component.getURI();
        int index = uri.lastIndexOf(47);
        uri = index == -1 ? "" : uri.substring(0, index);
        if (parts.length >= 1) {
            uri = uri.length() == 0 ? parts[0] : uri + "/" + parts[0];
        }
        if (parts.length == 3) {
            uri = uri + "#service-binding(" + parts[1] + "/" + parts[2] + ")";
        } else if (parts.length == 2) {
            uri = uri + "#service(" + parts[1] + ")";
        }
        Endpoint endpoint = this.assemblyFactory.createEndpoint();
        endpoint.setUnresolved(true);
        endpoint.setURI(uri);
        return endpoint;
    }

    private Endpoint createEndpoint(Component component, ComponentService service, boolean unresolved) {
        Endpoint endpoint = this.createEndpoint(unresolved);
        endpoint.setComponent(component);
        endpoint.setService(service);
        endpoint.setUnresolved(unresolved);
        return endpoint;
    }

    private void setSingleAutoWireTarget(ComponentReference reference) {
        String uri;
        if (reference.getEndpointReferences().size() > 1 && reference.getBindings() != null && reference.getBindings().size() == 1 && (uri = reference.getBindings().get(0).getURI()) != null) {
            if (uri.indexOf(47) > -1) {
                int i = uri.indexOf(47);
                String c = uri.substring(0, i);
                String s = uri.substring(i + 1);
                uri = c + "#service(" + s + ")";
            }
            for (EndpointReference er : reference.getEndpointReferences()) {
                if (er.getTargetEndpoint() == null || !uri.equals(er.getTargetEndpoint().getURI())) continue;
                reference.getEndpointReferences().clear();
                reference.getEndpointReferences().add(er);
                return;
            }
        }
    }

    private void fixUpCallbackLinks(Component component, ComponentReference reference) {
        List<Endpoint> callbackEndpoints;
        if (reference.getCallbackService() != null && !(callbackEndpoints = reference.getCallbackService().getEndpoints()).isEmpty()) {
            block0: for (EndpointReference endpointReference : reference.getEndpointReferences()) {
                for (Endpoint callbackEndpoint : callbackEndpoints) {
                    if (endpointReference.getBinding() == null || callbackEndpoint.getBinding() == null || !callbackEndpoint.getBinding().getType().equals(endpointReference.getBinding().getType())) continue;
                    endpointReference.setCallbackEndpoint(callbackEndpoint);
                    continue block0;
                }
            }
        }
        for (ComponentService service : component.getServices()) {
            if (service.getInterfaceContract() == null || service.getInterfaceContract().getCallbackInterface() == null || !reference.getName().equals(service.getName())) continue;
            block3: for (Endpoint endpoint : service.getEndpoints()) {
                for (EndpointReference callbackEndpointReference : reference.getEndpointReferences()) {
                    if (endpoint.getBinding() != null || callbackEndpointReference.getBinding() != null || !callbackEndpointReference.getBinding().getType().equals(endpoint.getBinding().getType())) continue;
                    endpoint.getCallbackEndpointReferences().add(callbackEndpointReference);
                    continue block3;
                }
            }
        }
    }
}

