/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.monitor.Monitor;

public class CompositeIncludeBuilderImpl
implements CompositeBuilder {
    @Override
    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.CompositeIncludeBuilder";
    }

    @Override
    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        return this.processIncludes(composite, context.getMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Composite processIncludes(Composite composite, Monitor monitor) {
        monitor.pushContext("Composite: " + composite.getName().toString());
        try {
            Implementation implementation;
            for (Component component : composite.getComponents()) {
                implementation = component.getImplementation();
                if (!(implementation instanceof Composite)) continue;
                this.processIncludes((Composite)implementation, monitor);
            }
            for (Composite included : composite.getIncludes()) {
                if (included.isLocal() && !composite.isLocal()) {
                    Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "IllegalCompositeIncusion", composite.getName().toString(), included.getName().toString());
                    implementation = null;
                    return implementation;
                }
                Composite merged = this.processIncludes(included, monitor);
                if (merged == null) continue;
                for (Component component : merged.getComponents()) {
                    if (component.getAutowire() == null && Boolean.TRUE.equals(merged.getAutowire())) {
                        component.setAutowire(Boolean.TRUE);
                    }
                    component.getRequiredIntents().addAll(merged.getRequiredIntents());
                    component.getPolicySets().addAll(merged.getPolicySets());
                }
                for (Service service : merged.getServices()) {
                    service.getRequiredIntents().addAll(merged.getRequiredIntents());
                    service.getPolicySets().addAll(merged.getPolicySets());
                }
                for (Reference reference : merged.getReferences()) {
                    reference.getRequiredIntents().addAll(merged.getRequiredIntents());
                    reference.getPolicySets().addAll(merged.getPolicySets());
                }
                composite.getComponents().addAll(merged.getComponents());
                composite.getServices().addAll(merged.getServices());
                composite.getReferences().addAll(merged.getReferences());
                composite.getProperties().addAll(merged.getProperties());
                composite.getWires().addAll(merged.getWires());
            }
            composite.getFusedIncludes().addAll(composite.getIncludes());
            composite.getIncludes().clear();
            Composite composite2 = composite;
            return composite2;
        }
        finally {
            monitor.popContext();
        }
    }
}

