/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.monitor.Monitor;

public class BindingURIBuilderImpl
implements CompositeBuilder {
    private static final QName DEFAULT = new QName("default");

    public BindingURIBuilderImpl(ExtensionPointRegistry registry) {
    }

    @Override
    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        this.configureBindingURIs(composite, null, context.getDefinitions(), context.getBindingBaseURIs(), context.getMonitor());
        return composite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureBindingURIs(Composite composite, String uri, Definitions definitions, Map<QName, List<String>> defaultBindings, Monitor monitor) throws CompositeBuilderException {
        String parentComponentURI = uri;
        monitor.pushContext("Composite: " + composite.getName().toString());
        try {
            for (Component component : composite.getComponents()) {
                Implementation implementation = component.getImplementation();
                if (!(implementation instanceof Composite)) continue;
                this.configureBindingURIs((Composite)implementation, component.getURI(), definitions, defaultBindings, monitor);
            }
            List<Service> compositeServices = composite.getServices();
            for (Service service : compositeServices) {
                for (Binding binding : service.getBindings()) {
                    this.constructBindingURI(parentComponentURI, composite, service, binding, defaultBindings, monitor);
                }
            }
            for (Component component : composite.getComponents()) {
                monitor.pushContext("Component: " + component.getName());
                try {
                    for (ComponentService service : component.getServices()) {
                        for (Binding binding : service.getBindings()) {
                            this.constructBindingURI(component, (Service)service, binding, defaultBindings, monitor);
                        }
                    }
                }
                finally {
                    monitor.popContext();
                }
            }
        }
        finally {
            monitor.popContext();
        }
    }

    private void constructBindingURI(String parentComponentURI, Composite composite, Service service, Binding binding, Map<QName, List<String>> defaultBindings, Monitor monitor) throws CompositeBuilderException {
        this.constructBindingURI(parentComponentURI, service, binding, defaultBindings, monitor);
    }

    private void constructBindingURI(Component component, Service service, Binding binding, Map<QName, List<String>> defaultBindings, Monitor monitor) throws CompositeBuilderException {
        this.constructBindingURI(component.getURI(), service, binding, defaultBindings, monitor);
    }

    private void constructBindingURI(String componentURIString, Service service, Binding binding, Map<QName, List<String>> defaultBindings, Monitor monitor) throws CompositeBuilderException {
        try {
            URI bindingURI;
            boolean includeBindingName = !service.getName().equals(binding.getName());
            URI uRI = bindingURI = binding.getURI() == null ? null : new URI(binding.getURI());
            if (binding instanceof SCABinding) {
                bindingURI = null;
            }
            if (bindingURI != null && bindingURI.isAbsolute()) {
                return;
            }
            String serviceName = service.getName();
            String bindingName = binding.getName() != null ? binding.getName() : serviceName;
            URI componentURI = null;
            if (componentURIString != null) {
                componentURI = new URI(BindingURIBuilderImpl.addSlashToPath(componentURIString));
            }
            URI baseURI = null;
            if (defaultBindings != null) {
                List<String> uris = defaultBindings.get(binding.getType());
                if (uris != null && uris.size() > 0) {
                    baseURI = new URI(BindingURIBuilderImpl.addSlashToPath(uris.get(0)));
                } else {
                    uris = defaultBindings.get(DEFAULT);
                    if (uris != null && uris.size() > 0) {
                        baseURI = new URI(BindingURIBuilderImpl.addSlashToPath(uris.get(0)));
                    }
                }
            }
            binding.setURI(BindingURIBuilderImpl.constructBindingURI(baseURI, componentURI, bindingURI, serviceName, includeBindingName, bindingName));
        }
        catch (URISyntaxException ex) {
            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "URLSyntaxException", componentURIString, service.getName(), binding.getName());
        }
    }

    private static String addSlashToPath(String path) {
        if (path.endsWith("/") || path.endsWith("#")) {
            return path;
        }
        return path + "/";
    }

    private static String constructBindingURI(URI baseURI, URI componentURI, URI bindingURI, String serviceName, boolean includeBindingName, String bindingName) {
        URI uri;
        String name;
        String string = name = includeBindingName ? serviceName + "/" + bindingName : serviceName;
        String uriString = baseURI == null ? (componentURI == null ? (bindingURI != null ? name + "/" + bindingURI.toString() : name) : (bindingURI != null ? (bindingURI.toString().startsWith("/") ? componentURI.resolve(bindingURI).toString() : componentURI.resolve(name + "/" + bindingURI).toString()) : componentURI.resolve(name).toString())) : (componentURI == null ? (bindingURI != null ? BindingURIBuilderImpl.basedURI(baseURI, bindingURI).toString() : BindingURIBuilderImpl.basedURI(baseURI, URI.create(name)).toString()) : (bindingURI != null ? (bindingURI.toString().startsWith("/") ? BindingURIBuilderImpl.basedURI(baseURI, componentURI.resolve(bindingURI)).toString() : BindingURIBuilderImpl.basedURI(baseURI, componentURI.resolve(name + "/" + bindingURI)).toString()) : BindingURIBuilderImpl.basedURI(baseURI, componentURI.resolve(name)).toString()));
        if (uriString.endsWith("/")) {
            uriString = uriString.substring(0, uriString.length() - 1);
        }
        if (!(uri = URI.create(uriString)).isAbsolute()) {
            uri = URI.create("/").resolve(uri);
        }
        return uri.toString();
    }

    private static URI basedURI(URI baseURI, URI uri) {
        if (uri.getScheme() != null) {
            return uri;
        }
        String str = uri.toString();
        if (str.startsWith("/")) {
            str = str.substring(1);
        }
        return URI.create(baseURI.toString() + str).normalize();
    }

    @Override
    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.BindingURIBuilder";
    }
}

