/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.provider;

import java.io.StringReader;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.builder.BindingBuilder;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclarationParser;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.provider.ProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.SCABindingMapper;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class DefaultSCABindingMapper
implements SCABindingMapper {
    private static final Logger logger = Logger.getLogger(DefaultSCABindingMapper.class.getName());
    protected ExtensionPointRegistry registry;
    protected ProviderFactoryExtensionPoint providerFactories;
    protected StAXArtifactProcessorExtensionPoint processors;
    protected QName defaultMappedBinding;
    protected QName defaultLocalBinding;
    protected boolean alwaysDistributed;
    protected QName[] activeDelegations = new QName[]{new QName("http://tuscany.apache.org/xmlns/sca/1.1", "binding.local"), new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.ws")};

    public DefaultSCABindingMapper(ExtensionPointRegistry registry, Map<String, String> attributes) {
        this.registry = registry;
        this.providerFactories = registry.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        this.processors = registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        this.defaultMappedBinding = this.getDefaultMappedBinding(attributes);
        this.defaultLocalBinding = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "binding.local");
        if (attributes != null && "true".equalsIgnoreCase(attributes.get("alwaysDistributed"))) {
            this.alwaysDistributed = true;
        }
    }

    protected QName getDefaultMappedBinding(Map<String, String> attributes) {
        String qname;
        QName defaultMappedBinding = null;
        if (attributes != null && (qname = attributes.get("mappedBinding")) != null) {
            defaultMappedBinding = ServiceDeclarationParser.getQName(qname);
        }
        if (defaultMappedBinding == null) {
            qname = System.getProperty("org.apache.tuscany.sca.binding.sca.provider.SCABindingMapper.mappedBinding");
            if (qname != null) {
                defaultMappedBinding = ServiceDeclarationParser.getQName(qname);
            } else {
                defaultMappedBinding = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "binding.hazelcast");
                if (!this.isBindingSupported(defaultMappedBinding) && !this.isBindingSupported(defaultMappedBinding = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.ws"))) {
                    defaultMappedBinding = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "binding.rmi");
                }
            }
        }
        return defaultMappedBinding;
    }

    private BindingBuilder<?> getBindingBuilder(QName binding) {
        if (this.isBindingSupported(binding)) {
            BuilderExtensionPoint builders = this.registry.getExtensionPoint(BuilderExtensionPoint.class);
            BindingBuilder builder = builders.getBindingBuilder(binding);
            return builder;
        }
        return null;
    }

    private boolean isBindingSupported(QName binding) {
        if (binding == null) {
            return false;
        }
        StAXArtifactProcessor processor = this.processors.getProcessor(binding);
        if (processor == null) {
            return false;
        }
        try {
            Binding bindingTemplate;
            ProviderFactory providerFactory;
            if (processor != null && (providerFactory = this.providerFactories.getProviderFactory((bindingTemplate = this.createDelegatingBinding(binding)).getClass())) == null) {
                processor = null;
                return false;
            }
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
        return true;
    }

    @Override
    public RuntimeEndpoint map(RuntimeEndpoint endpoint) {
        QName bindingType = this.chooseBinding(endpoint);
        if (!this.isBindingSupported(bindingType)) {
            logger.warning("Mapped binding for binding.sca is not supported: " + bindingType);
            return null;
        }
        RuntimeEndpoint ep = null;
        try {
            ep = (RuntimeEndpoint)endpoint.clone();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Binding binding = this.map(endpoint.getBinding(), bindingType);
        ep.setBinding(binding);
        BindingBuilder<?> builder = this.getBindingBuilder(bindingType);
        if (builder != null) {
            builder.build(ep.getComponent(), ep.getService(), binding, new BuilderContext(this.registry), false);
        }
        return ep;
    }

    @Override
    public RuntimeEndpointReference map(RuntimeEndpointReference endpointReference) {
        QName bindingType = this.chooseBinding(endpointReference);
        if (!this.isBindingSupported(bindingType)) {
            logger.warning("Mapped binding for binding.sca is not supported: " + bindingType);
            return null;
        }
        RuntimeEndpointReference epr = null;
        try {
            epr = (RuntimeEndpointReference)endpointReference.clone();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Binding binding = this.map(endpointReference.getBinding(), bindingType);
        epr.setBinding(binding);
        BindingBuilder<?> builder = this.getBindingBuilder(bindingType);
        if (builder != null) {
            builder.build(epr.getComponent(), epr.getReference(), binding, new BuilderContext(this.registry), false);
        }
        return epr;
    }

    protected Binding map(Binding scaBinding, QName newBindingType) {
        try {
            Binding binding = this.createDelegatingBinding(newBindingType);
            binding.setName(scaBinding.getName());
            if (((SCABinding)scaBinding).getDelegateBindingURI() != null) {
                binding.setURI(((SCABinding)scaBinding).getDelegateBindingURI());
            } else {
                binding.setURI(scaBinding.getURI());
            }
            binding.setOperationSelector(scaBinding.getOperationSelector());
            binding.setRequestWireFormat(scaBinding.getRequestWireFormat());
            binding.setResponseWireFormat(scaBinding.getResponseWireFormat());
            if (binding instanceof PolicySubject && scaBinding instanceof PolicySubject) {
                PolicySubject subject1 = (PolicySubject)((Object)binding);
                PolicySubject subject2 = (PolicySubject)((Object)scaBinding);
                subject1.getPolicySets().addAll(subject2.getPolicySets());
                subject1.getRequiredIntents().addAll(subject2.getRequiredIntents());
            }
            return binding;
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
    }

    protected Binding createDelegatingBinding(QName bindingType) throws XMLStreamException, ContributionReadException {
        StAXArtifactProcessor processor = this.processors.getProcessor(bindingType);
        if (processor == null) {
            logger.warning("Mapped binding for binding.sca is not supported: " + bindingType);
        }
        StringBuffer xml = new StringBuffer();
        xml.append("<").append(bindingType.getLocalPart()).append(" xmlns:b=\"").append(bindingType.getNamespaceURI()).append("\"/>");
        StAXHelper staxHelper = StAXHelper.getInstance(this.registry);
        XMLStreamReader reader = staxHelper.createXMLStreamReader(new StringReader(xml.toString()));
        reader.nextTag();
        Binding binding = (Binding)processor.read(reader, new ProcessorContext(this.registry));
        return binding;
    }

    protected QName chooseBinding(RuntimeEndpoint endpoint) {
        DomainRegistry domainRegistry = endpoint.getCompositeContext().getEndpointRegistry();
        boolean distributed = this.alwaysDistributed || domainRegistry.isDistributed();
        InterfaceContract interfaceContract = endpoint.getService().getInterfaceContract();
        if (interfaceContract != null && interfaceContract.getInterface() != null && interfaceContract.getInterface().isRemotable() && distributed && this.isBindingSupported(this.defaultMappedBinding)) {
            return this.defaultMappedBinding;
        }
        return this.defaultLocalBinding;
    }

    protected QName chooseBinding(RuntimeEndpointReference endpointReference) {
        boolean distributed;
        DomainRegistry domainRegistry = endpointReference.getCompositeContext().getEndpointRegistry();
        boolean bl = distributed = this.alwaysDistributed || domainRegistry.isDistributed();
        if (endpointReference.getTargetEndpoint().isRemote()) {
            RuntimeComponentReference ref = (RuntimeComponentReference)endpointReference.getReference();
            if (ref.getInterfaceContract() != null && !ref.getInterfaceContract().getInterface().isRemotable()) {
                throw new ServiceRuntimeException("Reference interface not remotable for component: " + endpointReference.getComponent().getName() + " and reference: " + ref.getName());
            }
            if (distributed && this.isBindingSupported(this.defaultMappedBinding)) {
                return this.defaultMappedBinding;
            }
        }
        return this.defaultLocalBinding;
    }

    public QName[] getActiveDelegations() {
        return this.activeDelegations;
    }
}

