/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.OperationSelector;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.binding.rest.RESTBinding;
import org.apache.tuscany.sca.binding.rest.RESTBindingFactory;
import org.apache.tuscany.sca.binding.rest.operationselector.jaxrs.JAXRSOperationSelector;
import org.apache.tuscany.sca.binding.rest.operationselector.jaxrs.JAXRSOperationSelectorFactory;
import org.apache.tuscany.sca.binding.rest.operationselector.rpc.RPCOperationSelector;
import org.apache.tuscany.sca.binding.rest.operationselector.rpc.RPCOperationSelectorFactory;
import org.apache.tuscany.sca.binding.rest.wireformat.json.JSONWireFormat;
import org.apache.tuscany.sca.binding.rest.wireformat.json.JSONWireFormatFactory;
import org.apache.tuscany.sca.binding.rest.wireformat.xml.XMLWireFormat;
import org.apache.tuscany.sca.binding.rest.wireformat.xml.XMLWireFormatFactory;
import org.apache.tuscany.sca.common.http.HTTPHeader;
import org.apache.tuscany.sca.common.http.cors.CORSConfiguration;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class RESTBindingProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<RESTBinding> {
    private static final QName HEADERS_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "http-headers");
    private static final QName HEADER_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "header");
    private static final QName RESPONSE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "response");
    private static final QName WIRE_FORMAT_JSON = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "wireFormat.json");
    private static final QName WIRE_FORMAT_XML = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "wireFormat.xml");
    private static final QName OPERATION_SELCTOR_RPC = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "operationSelector.rpc");
    private static final QName OPERATION_SELCTOR_JAXRS = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "operationSelector.jaxrs");
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String URI = "uri";
    private static final String READ_TIMEOUT = "readTimeout";
    private static final String CORS = "isCORS";
    private RESTBindingFactory restBindingFactory;
    private JSONWireFormatFactory jsonWireFormatFactory;
    private XMLWireFormatFactory xmlWireFormatFactory;
    private JAXRSOperationSelectorFactory jaxrsOperationSelectorFactory;
    private RPCOperationSelectorFactory rpcOperationSelectorFactory;
    private StAXArtifactProcessor<Object> extensionProcessor;

    public RESTBindingProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor<Object> extensionProcessor, StAXAttributeProcessor<Object> extensionAttributeProcessor) {
        FactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.restBindingFactory = modelFactories.getFactory(RESTBindingFactory.class);
        this.jsonWireFormatFactory = modelFactories.getFactory(JSONWireFormatFactory.class);
        this.xmlWireFormatFactory = modelFactories.getFactory(XMLWireFormatFactory.class);
        this.jaxrsOperationSelectorFactory = modelFactories.getFactory(JAXRSOperationSelectorFactory.class);
        this.rpcOperationSelectorFactory = modelFactories.getFactory(RPCOperationSelectorFactory.class);
        this.extensionProcessor = extensionProcessor;
    }

    @Override
    public QName getArtifactType() {
        return RESTBinding.TYPE;
    }

    @Override
    public Class<RESTBinding> getModelType() {
        return RESTBinding.class;
    }

    @Override
    public RESTBinding read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        RESTBinding restBinding = this.restBindingFactory.createRESTBinding();
        while (reader.hasNext()) {
            QName elementName = null;
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    Object extension;
                    String name;
                    elementName = reader.getName();
                    if (RESTBinding.TYPE.equals(elementName)) {
                        Boolean isCORS;
                        String readTimeout;
                        String uri;
                        name = this.getString(reader, NAME);
                        if (name != null) {
                            restBinding.setName(name);
                        }
                        if ((uri = this.getURIString(reader, URI)) != null) {
                            restBinding.setURI(uri);
                        }
                        if ((readTimeout = this.getString(reader, READ_TIMEOUT)) != null) {
                            restBinding.setReadTimeout(Integer.valueOf(readTimeout));
                        }
                        if ((isCORS = Boolean.valueOf(this.getBoolean(reader, CORS))) == null) break;
                        restBinding.setCORS(isCORS);
                        break;
                    }
                    if (HEADERS_QNAME.equals(elementName)) break;
                    if (HEADER_QNAME.equals(elementName)) {
                        name = this.getString(reader, NAME);
                        String value = this.getURIString(reader, VALUE);
                        if (name == null) break;
                        restBinding.getHttpHeaders().add(new HTTPHeader(name, value));
                        break;
                    }
                    if (RESPONSE_QNAME.equals(elementName)) {
                        reader.next();
                        if (reader.hasNext()) {
                            int sub_event = reader.getEventType();
                            switch (sub_event) {
                                case 1: {
                                    elementName = reader.getName();
                                    break;
                                }
                                default: {
                                    reader.next();
                                    break;
                                }
                            }
                        }
                        if ((extension = this.readWireFormatAndOperationSelectorExtensions(reader)) == null || !(extension instanceof WireFormat)) break;
                        restBinding.setResponseWireFormat((WireFormat)extension);
                        break;
                    }
                    if (WIRE_FORMAT_JSON.equals(elementName) || WIRE_FORMAT_XML.equals(elementName) || OPERATION_SELCTOR_JAXRS.equals(elementName) || OPERATION_SELCTOR_RPC.equals(elementName)) {
                        extension = this.readWireFormatAndOperationSelectorExtensions(reader);
                        if (extension == null) break;
                        if (extension instanceof WireFormat) {
                            restBinding.setRequestWireFormat((WireFormat)extension);
                            restBinding.setResponseWireFormat((WireFormat)extension);
                            break;
                        }
                        if (!(extension instanceof OperationSelector)) break;
                        restBinding.setOperationSelector((OperationSelector)extension);
                        restBinding.setCORS(true);
                        break;
                    }
                    extension = this.extensionProcessor.read(reader, context);
                    if (extension == null || !(extension instanceof CORSConfiguration)) break;
                    restBinding.setCORSConfiguration((CORSConfiguration)extension);
                    break;
                }
                case 2: {
                    elementName = reader.getName();
                    if (!RESTBinding.TYPE.equals(elementName)) break;
                    return restBinding;
                }
            }
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return restBinding;
    }

    @Override
    public void write(RESTBinding restBinding, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, RESTBinding.TYPE.getNamespaceURI(), RESTBinding.TYPE.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
        if (restBinding.getName() != null) {
            writer.writeAttribute(NAME, restBinding.getName());
        }
        if (restBinding.getURI() != null) {
            writer.writeAttribute(URI, restBinding.getURI());
        }
        if (restBinding.getOperationSelector() != null) {
            this.writeWireFormatAndOperationSelectorExtensions(writer, restBinding.getOperationSelector());
        }
        if (restBinding.getRequestWireFormat() != null) {
            this.writeWireFormatAndOperationSelectorExtensions(writer, restBinding.getRequestWireFormat());
        }
        if (restBinding.getResponseWireFormat() != null && restBinding.getRequestWireFormat() != restBinding.getResponseWireFormat()) {
            this.writeStart(writer, RESPONSE_QNAME.getNamespaceURI(), RESPONSE_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
            if (restBinding.getResponseWireFormat() != null) {
                this.writeWireFormatAndOperationSelectorExtensions(writer, restBinding.getResponseWireFormat());
            }
            this.writeEnd(writer);
        }
        this.writeEnd(writer);
    }

    @Override
    public void resolve(RESTBinding model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }

    private Object readWireFormatAndOperationSelectorExtensions(XMLStreamReader reader) throws XMLStreamException {
        QName elementName = reader.getName();
        if (WIRE_FORMAT_JSON.equals(elementName)) {
            return this.jsonWireFormatFactory.createRESTWireFormatJSON();
        }
        if (WIRE_FORMAT_XML.equals(elementName)) {
            return this.xmlWireFormatFactory.createRESTWireFormatXML();
        }
        if (OPERATION_SELCTOR_JAXRS.equals(elementName)) {
            return this.jaxrsOperationSelectorFactory.createJAXRSOperationSelector();
        }
        if (OPERATION_SELCTOR_RPC.equals(elementName)) {
            return this.rpcOperationSelectorFactory.createRPCOperationSelector();
        }
        return null;
    }

    private void writeWireFormatAndOperationSelectorExtensions(XMLStreamWriter writer, Object object) throws XMLStreamException {
        if (object instanceof JSONWireFormat) {
            this.writeStart(writer, WIRE_FORMAT_JSON.getNamespaceURI(), WIRE_FORMAT_JSON.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
            this.writeEnd(writer);
        } else if (object instanceof XMLWireFormat) {
            this.writeStart(writer, WIRE_FORMAT_XML.getNamespaceURI(), WIRE_FORMAT_XML.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
            this.writeEnd(writer);
        } else if (object instanceof JAXRSOperationSelector) {
            this.writeStart(writer, OPERATION_SELCTOR_JAXRS.getNamespaceURI(), OPERATION_SELCTOR_JAXRS.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
            this.writeEnd(writer);
        } else if (object instanceof RPCOperationSelector) {
            this.writeStart(writer, OPERATION_SELCTOR_RPC.getNamespaceURI(), OPERATION_SELCTOR_RPC.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
            this.writeEnd(writer);
        }
    }
}

