/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.assembly.OperationSelector;
import org.apache.tuscany.sca.assembly.OperationsConfigurator;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.binding.jms.BindingProperty;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;

public class JMSBinding
implements Binding,
PolicySubject,
OperationsConfigurator,
Extensible {
    QName TYPE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.jms");
    private String uri = null;
    private String name = null;
    private boolean unresolved = false;
    private List<Object> extensions = new ArrayList<Object>();
    private List<Extension> attributeExtensions = new ArrayList<Extension>();
    private List<PolicySet> policySets = new ArrayList<PolicySet>();
    private List<PolicySet> applicablePolicySets = new ArrayList<PolicySet>();
    private List<Intent> requiredIntents = new ArrayList<Intent>();
    private List<ConfiguredOperation> configuredOperations = new ArrayList<ConfiguredOperation>();
    private String targetNamespace;
    private String correlationScheme = "messageID";
    private String initialContextFactoryName;
    private String jndiURL;
    private String destinationName = null;
    private String destinationType = "queue";
    private String destinationCreate = "ifNotExist";
    private Map<String, BindingProperty> destinationProperties = new HashMap<String, BindingProperty>();
    private String connectionFactoryName = null;
    private String connectionFactoryCreate = "ifNotExist";
    private Map<String, BindingProperty> connectionFactoryProperties = new HashMap<String, BindingProperty>();
    private String activationSpecName = null;
    private String activationSpecCreate = "ifNotExist";
    private Map<String, BindingProperty> activationSpecProperties = new HashMap<String, BindingProperty>();
    private String resourceAdapterName;
    private Map<String, BindingProperty> resourceAdapterProperties = new HashMap<String, BindingProperty>();
    private String responseActivationSpecName = null;
    private String responseActivationSpecCreate = "ifNotExist";
    private Map<String, BindingProperty> responseActivationSpecProperties = new HashMap<String, BindingProperty>();
    private String responseDestinationName = null;
    private String responseDestinationType = "queue";
    private String responseDestinationCreate = "ifNotExist";
    private Map<String, BindingProperty> responseDestinationProperties = new HashMap<String, BindingProperty>();
    private String responseConnectionFactoryName = null;
    private String responseConnectionFactoryCreate = "ifNotExist";
    private Map<String, BindingProperty> responseConnectionFactoryProperties = new HashMap<String, BindingProperty>();
    private String jmsResourceFactoryName = "org.apache.tuscany.sca.host.jms.activemq.JMSResourceFactoryImpl";
    public String requestMessageProcessorName = "org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor";
    public String responseMessageProcessorName = "org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor";
    private String operationSelectorPropertyName = "scaOperationName";
    private String operationSelectorName = null;
    private boolean containsHeaders = false;
    private String replyTo;
    private String jmsCorrelationId;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, Map<String, Object>> operationProperties = new HashMap<String, Map<String, Object>>();
    private Map<String, String> nativeOperationNames = new HashMap<String, String>();
    private Map<String, String> nativeOperationNamesToOpName = new HashMap<String, String>();
    private Map<String, String> operationJMSTypes = new HashMap<String, String>();
    private Map<String, String> operationJMSCorrelationIds = new HashMap<String, String>();
    private Map<String, Boolean> operationJMSDeliveryModes = new HashMap<String, Boolean>();
    private Map<String, Long> operationJMSTimeToLives = new HashMap<String, Long>();
    private Map<String, Integer> operationJMSPriorities = new HashMap<String, Integer>();
    private Map<String, Map<String, BindingProperty>> operationPropertiesProperties = new HashMap<String, Map<String, BindingProperty>>();
    private String jmsSelector = null;
    private String uriJmsSelector = null;
    private QName requestConnectionName;
    private QName responseConnectionName;
    private QName operationPropertiesName;
    private JMSBinding requestConnectionBinding;
    private JMSBinding responseConnectionBinding;
    private JMSBinding operationPropertiesBinding;
    private WireFormat requestWireFormat;
    private WireFormat responseWireFormat;
    private boolean responseWireFormatIsDefault;
    private OperationSelector operationSelector;
    private ExtensionType extensionType;
    private String jmsURI;
    private String uriType;
    private Boolean uriDeliveryMode;
    private Integer uriJMSPriority;
    private Long uriJMSTimeToLive;
    private String headerType;
    private Boolean headerDeliveryMode;
    private Integer headerPriority;
    private Long headerTimeToLive;
    private final Integer defaultPriority = 4;
    private final Boolean defaultDeliveryMode = true;
    private final Long defaultJMSTimeToLive = 0L;
    private boolean isDestinationSpecified = false;

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public void setURI(String uri) {
        this.uri = uri;
        if (uri != null) {
            this.parseURI(uri);
        } else {
            this.setDestinationName(null);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean unresolved) {
        this.unresolved = unresolved;
    }

    @Override
    public List<Object> getExtensions() {
        return this.extensions;
    }

    @Override
    public WireFormat getRequestWireFormat() {
        return this.requestWireFormat;
    }

    @Override
    public void setRequestWireFormat(WireFormat wireFormat) {
        this.requestWireFormat = wireFormat;
    }

    @Override
    public WireFormat getResponseWireFormat() {
        return this.responseWireFormat;
    }

    @Override
    public void setResponseWireFormat(WireFormat wireFormat) {
        this.responseWireFormat = wireFormat;
    }

    public boolean isResponseWireFormatDefault() {
        return this.responseWireFormatIsDefault;
    }

    public void setResponseWireFormatIsDefault(boolean b) {
        this.responseWireFormatIsDefault = b;
    }

    @Override
    public OperationSelector getOperationSelector() {
        return this.operationSelector;
    }

    @Override
    public void setOperationSelector(OperationSelector operationSelector) {
        this.operationSelector = operationSelector;
    }

    public void setCorrelationScheme(String correlationScheme) {
        this.correlationScheme = correlationScheme;
    }

    public String getCorrelationScheme() {
        return this.correlationScheme;
    }

    public String getInitialContextFactoryName() {
        return this.initialContextFactoryName;
    }

    public void setInitialContextFactoryName(String initialContextFactoryName) {
        this.initialContextFactoryName = initialContextFactoryName;
    }

    public String getJndiURL() {
        return this.jndiURL;
    }

    public void setJndiURL(String jndiURL) {
        this.jndiURL = jndiURL;
    }

    public String getDestinationName() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getDestinationName() != null) {
            return this.requestConnectionBinding.getDestinationName();
        }
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getDestinationType() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getDestinationType() != null) {
            return this.requestConnectionBinding.getDestinationType();
        }
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getDestinationCreate() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getDestinationCreate() != null) {
            return this.requestConnectionBinding.getDestinationCreate();
        }
        return this.destinationCreate;
    }

    public void setDestinationCreate(String create) {
        this.destinationCreate = create;
    }

    public String getConnectionFactoryName() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getConnectionFactoryName() != null) {
            return this.requestConnectionBinding.getConnectionFactoryName();
        }
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public String getConnectionFactoryCreate() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getConnectionFactoryCreate() != null) {
            return this.requestConnectionBinding.getConnectionFactoryCreate();
        }
        return this.connectionFactoryCreate;
    }

    public void setConnectionFactoryCreate(String create) {
        this.connectionFactoryCreate = create;
    }

    public String getResourceAdapterName() {
        return this.resourceAdapterName;
    }

    public void setResourceAdapterName(String name) {
        this.resourceAdapterName = name;
    }

    public String getActivationSpecName() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getActivationSpecName() != null) {
            return this.requestConnectionBinding.getActivationSpecName();
        }
        return this.activationSpecName;
    }

    public void setActivationSpecName(String activationSpecName) {
        this.activationSpecName = activationSpecName;
    }

    public String getActivationSpecCreate() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getActivationSpecCreate() != null) {
            return this.requestConnectionBinding.getActivationSpecCreate();
        }
        return this.activationSpecCreate;
    }

    public void setActivationSpecCreate(String create) {
        this.activationSpecCreate = create;
    }

    public String getResponseDestinationName() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getResponseDestinationName() != null) {
            return this.requestConnectionBinding.getResponseDestinationName();
        }
        return this.responseDestinationName;
    }

    public void setResponseDestinationName(String name) {
        this.responseDestinationName = name;
    }

    public String getResponseDestinationType() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getResponseDestinationType() != null) {
            return this.requestConnectionBinding.getResponseDestinationType();
        }
        return this.responseDestinationType;
    }

    public void setResponseDestinationType(String type) {
        this.responseDestinationType = type;
    }

    public String getResponseDestinationCreate() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getResponseDestinationCreate() != null) {
            return this.requestConnectionBinding.getResponseDestinationCreate();
        }
        return this.responseDestinationCreate;
    }

    public void setResponseDestinationCreate(String create) {
        this.responseDestinationCreate = create;
    }

    public String getResponseConnectionFactoryName() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getResponseConnectionFactoryName() != null) {
            return this.requestConnectionBinding.getResponseConnectionFactoryName();
        }
        return this.responseConnectionFactoryName;
    }

    public void setResponseConnectionFactoryName(String connectionFactoryName) {
        this.responseConnectionFactoryName = connectionFactoryName;
    }

    public String getResponseConnectionFactoryCreate() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getResponseConnectionFactoryCreate() != null) {
            return this.requestConnectionBinding.getResponseConnectionFactoryCreate();
        }
        return this.responseConnectionFactoryCreate;
    }

    public void setResponseConnectionFactoryCreate(String create) {
        this.responseConnectionFactoryCreate = create;
    }

    public String getResponseActivationSpecName() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getResponseActivationSpecName() != null) {
            return this.requestConnectionBinding.getResponseActivationSpecName();
        }
        return this.responseActivationSpecName;
    }

    public void setResponseActivationSpecName(String activationSpecName) {
        this.responseActivationSpecName = activationSpecName;
    }

    public String getResponseActivationSpecCreate() {
        if (this.requestConnectionBinding != null && this.requestConnectionBinding.getResponseActivationSpecCreate() != null) {
            return this.requestConnectionBinding.getResponseActivationSpecCreate();
        }
        return this.responseActivationSpecCreate;
    }

    public void setResponseActivationSpecCreate(String create) {
        this.responseActivationSpecCreate = create;
    }

    public String getJmsResourceFactoryName() {
        return this.jmsResourceFactoryName;
    }

    public void setJmsResourceFactoryName(String jmsResourceFactoryName) {
        this.jmsResourceFactoryName = jmsResourceFactoryName;
    }

    public void setRequestMessageProcessorName(String name) {
        this.requestMessageProcessorName = name;
    }

    public String getRequestMessageProcessorName() {
        return this.requestMessageProcessorName;
    }

    public void setResponseMessageProcessorName(String name) {
        this.responseMessageProcessorName = name;
    }

    public String getResponseMessageProcessorName() {
        return this.responseMessageProcessorName;
    }

    public String getOperationSelectorPropertyName() {
        return this.operationSelectorPropertyName;
    }

    public void setOperationSelectorPropertyName(String operationSelectorPropertyName) {
        this.operationSelectorPropertyName = operationSelectorPropertyName;
    }

    public String getOperationSelectorName() {
        return this.operationSelectorName;
    }

    public void setOperationSelectorName(String operationSelectorName) {
        this.operationSelectorName = operationSelectorName;
    }

    public void setHeaders(boolean containsHeaders) {
        this.containsHeaders = containsHeaders;
    }

    public boolean containsHeaders() {
        return this.containsHeaders;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getEffectiveJMSType(String opName) {
        if (this.getJMSURIType() != null) {
            return this.getJMSURIType();
        }
        if (this.getOperationJMSType(opName) != null) {
            return this.getOperationJMSType(opName);
        }
        if (this.getJMSHeaderType() != null) {
            return this.getJMSHeaderType();
        }
        return null;
    }

    public Boolean getEffectiveJMSDeliveryMode(String opName) {
        if (this.getURIJMSDeliveryMode() != null) {
            return this.getURIJMSDeliveryMode();
        }
        if (this.getOperationJMSDeliveryMode(opName) != null) {
            return this.getOperationJMSDeliveryMode(opName);
        }
        if (this.getHeaderJMSDeliveryMode() != null) {
            return this.getHeaderJMSDeliveryMode();
        }
        return this.getDefaultDeliveryMode();
    }

    public Long getEffectiveJMSTimeToLive(String opName) {
        if (this.getURIJMSTimeToLive() != null) {
            return this.getURIJMSTimeToLive();
        }
        if (this.getOperationJMSTimeToLive(opName) != null) {
            return this.getOperationJMSTimeToLive(opName);
        }
        if (this.getHeaderJMSTimeToLive() != null) {
            return this.getHeaderJMSTimeToLive();
        }
        return this.getDefaultJMSTimeToLive();
    }

    public Integer getEffectiveJMSPriority(String operationName) {
        if (this.getURIJMSPriority() != null) {
            return this.getURIJMSPriority();
        }
        if (this.getOperationJMSPriority(operationName) != null) {
            return this.getOperationJMSPriority(operationName);
        }
        if (this.getJMSHeaderPriority() != null) {
            return this.getJMSHeaderPriority();
        }
        return this.getDefaultJMSPriority();
    }

    private Long getHeaderJMSTimeToLive() {
        return this.headerTimeToLive;
    }

    private Long getDefaultJMSTimeToLive() {
        return this.defaultJMSTimeToLive;
    }

    private Boolean getDefaultDeliveryMode() {
        return this.defaultDeliveryMode;
    }

    private Boolean getHeaderJMSDeliveryMode() {
        return this.headerDeliveryMode;
    }

    private Boolean getURIJMSDeliveryMode() {
        return this.uriDeliveryMode;
    }

    public String getJMSURIType() {
        return this.uriType;
    }

    public void setJMSURIType(String type) {
        this.uriType = type;
    }

    public String getJMSHeaderType() {
        return this.headerType;
    }

    public void setJMSHeaderType(String type) {
        this.headerType = type;
    }

    public String getJMSCorrelationId() {
        return this.jmsCorrelationId;
    }

    public void setJMSCorrelationId(String jmsCorrelationId) {
        this.setHeaders(true);
        this.jmsCorrelationId = jmsCorrelationId;
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    protected Map<String, Object> getProperties() {
        return this.properties;
    }

    public void addOperationName(String opName) {
        Map<String, Object> props = this.operationProperties.get(opName);
        if (props == null) {
            props = new HashMap<String, Object>();
            this.operationProperties.put(opName, props);
        }
    }

    public Set<String> getOperationNames() {
        if (this.operationPropertiesBinding != null) {
            return this.operationPropertiesBinding.getOperationNames();
        }
        Set<String> opNames = this.operationProperties.keySet();
        TreeSet<String> opNamesCopy = new TreeSet<String>(opNames);
        return opNamesCopy;
    }

    public Map<String, Object> getOperationProperties(String opName) {
        if (this.operationPropertiesBinding != null) {
            return this.operationPropertiesBinding.getOperationProperties(opName);
        }
        return this.operationProperties.get(opName);
    }

    public void setOperationProperty(String opName, String propName, Object value) {
        Map<String, Object> props = this.operationProperties.get(opName);
        if (props == null) {
            props = new HashMap<String, Object>();
            this.operationProperties.put(opName, props);
        }
        props.put(propName, value);
    }

    public Object getOperationProperty(String opName, String propName) {
        if (this.operationPropertiesBinding != null) {
            return this.operationPropertiesBinding.getOperationProperty(opName, propName);
        }
        Map<String, Object> props = this.operationProperties.get(opName);
        if (props == null) {
            return null;
        }
        return props.get(propName);
    }

    public boolean hasNativeOperationName(String opName) {
        if (this.operationPropertiesBinding != null) {
            return this.operationPropertiesBinding.hasNativeOperationName(opName);
        }
        return this.nativeOperationNames.containsKey(opName);
    }

    public String getNativeOperationName(String opName) {
        if (this.operationPropertiesBinding != null && this.operationPropertiesBinding.getNativeOperationName(opName) != null) {
            return this.operationPropertiesBinding.getNativeOperationName(opName);
        }
        if (this.nativeOperationNames.containsKey(opName)) {
            return this.nativeOperationNames.get(opName);
        }
        return opName;
    }

    public void setNativeOperationName(String opName, String nativeOpName) {
        this.nativeOperationNames.put(opName, nativeOpName);
    }

    public Map<String, String> getNativeOperationNames() {
        return this.nativeOperationNames;
    }

    public void setNativeOperationNameToOpName(String nativeOpName, String opName) {
        this.nativeOperationNamesToOpName.put(nativeOpName, opName);
    }

    public String getOpNameFromNativeOperationName(String nativeOpName) {
        return this.nativeOperationNamesToOpName.get(nativeOpName);
    }

    public String getOperationJMSType(String opName) {
        if (this.operationPropertiesBinding != null && this.operationPropertiesBinding.getOperationJMSType(opName) != null) {
            return this.operationPropertiesBinding.getOperationJMSType(opName);
        }
        if (this.operationJMSTypes.containsKey(opName)) {
            return this.operationJMSTypes.get(opName);
        }
        return null;
    }

    public void setOperationJMSType(String opName, String jmsType) {
        this.operationJMSTypes.put(opName, jmsType);
    }

    public String getOperationJMSCorrelationId(String opName) {
        if (this.operationPropertiesBinding != null) {
            if (this.operationPropertiesBinding.getOperationJMSCorrelationId(opName) != null) {
                return this.operationPropertiesBinding.getOperationJMSCorrelationId(opName);
            }
            return this.jmsCorrelationId;
        }
        if (this.operationJMSCorrelationIds.containsKey(opName)) {
            return this.operationJMSCorrelationIds.get(opName);
        }
        return this.jmsCorrelationId;
    }

    public void setOperationJMSCorrelationId(String opName, String jmsCorrelationId) {
        this.operationJMSCorrelationIds.put(opName, jmsCorrelationId);
    }

    public Boolean getOperationJMSDeliveryMode(String opName) {
        if (this.operationPropertiesBinding != null) {
            if (this.operationPropertiesBinding.getOperationJMSDeliveryMode(opName) != null) {
                return this.operationPropertiesBinding.getOperationJMSDeliveryMode(opName);
            }
            return null;
        }
        if (this.operationJMSDeliveryModes.containsKey(opName)) {
            return this.operationJMSDeliveryModes.get(opName);
        }
        return null;
    }

    public void setOperationJMSDeliveryMode(String opName, boolean b) {
        this.operationJMSDeliveryModes.put(opName, b);
    }

    public Long getOperationJMSTimeToLive(String opName) {
        if (this.operationPropertiesBinding != null) {
            if (this.operationPropertiesBinding.getOperationJMSTimeToLive(opName) != null) {
                return this.operationPropertiesBinding.getOperationJMSTimeToLive(opName);
            }
            return null;
        }
        if (this.operationJMSTimeToLives.containsKey(opName)) {
            return this.operationJMSTimeToLives.get(opName);
        }
        return null;
    }

    public void setOperationJMSTimeToLive(String opName, Long ttl) {
        this.operationJMSTimeToLives.put(opName, ttl);
    }

    public Integer getOperationJMSPriority(String opName) {
        if (this.operationPropertiesBinding != null) {
            if (this.operationPropertiesBinding.getOperationJMSPriority(opName) != null) {
                return this.operationPropertiesBinding.getOperationJMSPriority(opName);
            }
            return null;
        }
        if (this.operationJMSPriorities.containsKey(opName)) {
            return this.operationJMSPriorities.get(opName);
        }
        return null;
    }

    public void setOperationJMSPriority(String opName, int p) {
        this.operationJMSPriorities.put(opName, p);
    }

    public String getJMSSelector() {
        if (this.uriJmsSelector != null) {
            return this.uriJmsSelector;
        }
        return this.jmsSelector;
    }

    public void setJMSSelector(String jmsSelector) {
        this.jmsSelector = jmsSelector;
    }

    public QName getRequestConnectionName() {
        return this.requestConnectionName;
    }

    public void setRequestConnectionName(QName requestConnectionName) {
        this.requestConnectionName = requestConnectionName;
    }

    public void setResponseConnectionName(QName responseConnectionName) {
        this.responseConnectionName = responseConnectionName;
    }

    public QName getResponseConnectionName() {
        return this.responseConnectionName;
    }

    public void setRequestConnectionBinding(JMSBinding binding) {
        this.requestConnectionBinding = binding;
    }

    public JMSBinding getRequestConnectionBinding() {
        return this.requestConnectionBinding;
    }

    public void setResponseConnectionBinding(JMSBinding binding) {
        this.responseConnectionBinding = binding;
    }

    public JMSBinding getResponseConnectionBinding() {
        return this.responseConnectionBinding;
    }

    public void setOperationPropertiesName(QName nameValue) {
        this.operationPropertiesName = nameValue;
    }

    public QName getOperationPropertiesName() {
        return this.operationPropertiesName;
    }

    public void setOperationPropertiesBinding(JMSBinding binding) {
        this.operationPropertiesBinding = binding;
    }

    public JMSBinding getOperationPropertiesBinding() {
        return this.operationPropertiesBinding;
    }

    @Override
    public List<PolicySet> getPolicySets() {
        return this.policySets;
    }

    public List<PolicySet> getApplicablePolicySets() {
        return this.applicablePolicySets;
    }

    @Override
    public List<Intent> getRequiredIntents() {
        return this.requiredIntents;
    }

    @Override
    public QName getType() {
        return this.TYPE;
    }

    public Map<String, BindingProperty> getDestinationProperties() {
        return this.destinationProperties;
    }

    public Map<String, BindingProperty> getConnectionFactoryProperties() {
        return this.connectionFactoryProperties;
    }

    public Map<String, BindingProperty> getResourceAdapterProperties() {
        return this.resourceAdapterProperties;
    }

    public Map<String, BindingProperty> getActivationSpecProperties() {
        return this.activationSpecProperties;
    }

    public Map<String, BindingProperty> getResponseActivationSpecProperties() {
        return this.responseActivationSpecProperties;
    }

    public Map<String, BindingProperty> getResponseDestinationProperties() {
        return this.responseDestinationProperties;
    }

    public Map<String, BindingProperty> getResponseConnectionFactoryProperties() {
        return this.responseConnectionFactoryProperties;
    }

    public Map<String, BindingProperty> getOperationPropertiesProperties(String opName) {
        if (this.operationPropertiesProperties.get(opName) == null) {
            this.operationPropertiesProperties.put(opName, new HashMap());
        }
        return this.operationPropertiesProperties.get(opName);
    }

    @Override
    public List<ConfiguredOperation> getConfiguredOperations() {
        return this.configuredOperations;
    }

    public void setConfiguredOperations(List<ConfiguredOperation> configuredOperations) {
        this.configuredOperations = configuredOperations;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String ns) {
        this.targetNamespace = ns;
    }

    public int hashCode() {
        return (String.valueOf(this.getTargetNamespace()) + String.valueOf(this.getName())).hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof JMSBinding && this.equals((JMSBinding)object);
    }

    public boolean equals(JMSBinding binding) {
        if (this.targetNamespace != null) {
            if (!JMSBinding.optStringEquals(this.targetNamespace, binding.getTargetNamespace())) {
                return false;
            }
            return JMSBinding.optStringEquals(this.name, binding.getName());
        }
        if (!JMSBinding.optStringEquals(this.uri, binding.getURI())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.name, binding.getName())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.targetNamespace, binding.getTargetNamespace())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.destinationName, binding.getDestinationName())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.correlationScheme, binding.getCorrelationScheme())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.initialContextFactoryName, binding.getInitialContextFactoryName())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.jndiURL, binding.getJndiURL())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.requestConnectionName, binding.getRequestConnectionName())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.responseConnectionName, binding.getResponseConnectionName())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.jmsSelector, binding.getJMSSelector())) {
            return false;
        }
        if (!JMSBinding.equals(this.properties, binding.getProperties())) {
            return false;
        }
        Set<String> operationNamesA = this.getOperationNames();
        Set<String> operationNamesB = binding.getOperationNames();
        if (operationNamesA != null && operationNamesB != null) {
            if (operationNamesA == null && operationNamesB != null) {
                return false;
            }
            if (operationNamesA != null && operationNamesB == null) {
                return false;
            }
            if (operationNamesA.size() != operationNamesB.size()) {
                return false;
            }
            for (String opName : operationNamesA) {
                if (operationNamesB.contains(opName)) continue;
                return false;
            }
        }
        if (!JMSBinding.optStringEquals(this.getDestinationName(), binding.getDestinationName())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.getDestinationType(), binding.getDestinationType())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.getConnectionFactoryName(), binding.getConnectionFactoryName())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.getActivationSpecName(), binding.getActivationSpecName())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.getResponseDestinationName(), binding.getResponseDestinationName())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.getResponseActivationSpecName(), binding.getResponseActivationSpecName())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.getResponseConnectionFactoryName(), binding.getResponseConnectionFactoryName())) {
            return false;
        }
        if (!JMSBinding.optStringEquals(this.getResourceAdapterName(), binding.getResourceAdapterName())) {
            return false;
        }
        if (this.configuredOperations.size() != binding.getConfiguredOperations().size()) {
            return false;
        }
        if (this.getRequestWireFormat().getClass() != binding.getRequestWireFormat().getClass()) {
            return false;
        }
        if (this.getResponseWireFormat().getClass() != binding.getResponseWireFormat().getClass()) {
            return false;
        }
        if (this.isResponseWireFormatDefault() != binding.isResponseWireFormatDefault()) {
            return false;
        }
        return this.getOperationSelector().getClass() == binding.getOperationSelector().getClass();
    }

    public static boolean optStringEquals(Object s1, Object s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean equals(Map<String, Object> p1, Map<String, Object> p2) {
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        if (p1.size() != p2.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : p1.entrySet()) {
            String k1 = entry.getKey();
            Object v1 = entry.getValue();
            Object v2 = p2.get(k1);
            if (v1 == null && v2 != null) {
                return false;
            }
            if (v1 != null && v2 == null) {
                return false;
            }
            if (v1.equals(v2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ExtensionType getExtensionType() {
        return this.extensionType;
    }

    @Override
    public void setExtensionType(ExtensionType intentAttachPointType) {
        this.extensionType = intentAttachPointType;
    }

    public String getJMSURI() {
        return this.jmsURI;
    }

    public void setJMSURI(String jmsURI) {
        this.jmsURI = jmsURI;
    }

    public void setURIJMSDeliveryMode(boolean equals) {
        this.uriDeliveryMode = equals;
    }

    public Integer getURIJMSPriority() {
        return this.uriJMSPriority;
    }

    public void setURIJMSPriority(int parseInt) {
        this.uriJMSPriority = parseInt;
    }

    public Long getURIJMSTimeToLive() {
        return this.uriJMSTimeToLive;
    }

    public void setURIJMSTimeToLive(long parseLong) {
        this.uriJMSTimeToLive = parseLong;
    }

    public Boolean isHeaderDeliveryModePersistent() {
        return this.headerDeliveryMode;
    }

    public void setJMSHeaderDeliveryMode(boolean b) {
        this.headerDeliveryMode = b;
    }

    public Long getJMSHeaderTimeToLive() {
        return this.headerTimeToLive;
    }

    public void setJMSHeaderTimeToLive(long parseLong) {
        this.headerTimeToLive = parseLong;
    }

    public Integer getJMSHeaderPriority() {
        return this.headerPriority;
    }

    public void setJMSHeaderPriority(int p) {
        this.headerPriority = p;
    }

    public Integer getDefaultJMSPriority() {
        return this.defaultPriority;
    }

    public void setIsDestinationSpecified(boolean b) {
        this.isDestinationSpecified = b;
    }

    public boolean isDestinationSpecified() {
        return this.isDestinationSpecified;
    }

    public void setURIJMSSelector(String selector) {
        this.uriJmsSelector = selector;
    }

    @Override
    public List<Extension> getAttributeExtensions() {
        return this.attributeExtensions;
    }

    public void parseURI(String uri) {
        JMSBinding jmsBinding = this;
        if (uri == null || !uri.startsWith("jms:jndi:") && !uri.startsWith("jms:queue:") && !uri.startsWith("jms:topic:")) {
            return;
        }
        int i = uri.indexOf(63);
        if (i >= 0) {
            StringTokenizer st = new StringTokenizer(uri.substring(i + 1), "&");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.startsWith("jndiConnectionFactoryName=")) {
                    jmsBinding.setConnectionFactoryName(s.substring(26));
                    continue;
                }
                if (s.startsWith("deliveryMode=")) {
                    jmsBinding.setURIJMSDeliveryMode("persistent".equals(s.substring(13)));
                    continue;
                }
                if (s.startsWith("priority=")) {
                    jmsBinding.setURIJMSPriority(Integer.parseInt(s.substring(9)));
                    continue;
                }
                if (s.startsWith("timeToLive=")) {
                    jmsBinding.setURIJMSTimeToLive(Long.parseLong(s.substring(11)));
                    continue;
                }
                if (s.startsWith("selector='")) {
                    String selector = s.substring(10);
                    if (selector.startsWith("\"") || selector.startsWith("'")) {
                        selector = selector.substring(1, selector.length());
                    }
                    if (selector.endsWith("\"") || selector.endsWith("'")) {
                        selector = selector.substring(0, selector.length() - 1);
                    }
                    jmsBinding.setURIJMSSelector(selector);
                    continue;
                }
                if (s.startsWith("type")) {
                    String type = s.substring(5);
                    jmsBinding.setJMSURIType(type);
                    continue;
                }
                return;
            }
            int j = uri.indexOf(58, 4);
            jmsBinding.setDestinationName(uri.substring(j + 1, i));
            jmsBinding.setDestinationType(uri.substring(4, j));
        } else {
            int j = uri.indexOf(58, 4);
            jmsBinding.setDestinationName(uri.substring(j + 1));
            jmsBinding.setDestinationType(uri.substring(4, j));
        }
        jmsBinding.setJMSURI(uri);
    }
}

