/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.assembly.builder.ContractBuilder;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;

public class EndpointImpl
implements Endpoint {
    private static final long serialVersionUID = 7344399683703812593L;
    protected transient ExtensionPointRegistry registry;
    protected transient BuilderExtensionPoint builders;
    protected transient ContractBuilder contractBuilder;
    protected boolean unresolved;
    protected String uri;
    protected String deployedURI;
    protected Component component;
    protected ComponentService service;
    protected Binding binding;
    protected InterfaceContract interfaceContract;
    protected List<EndpointReference> callbackEndpointReferences = new ArrayList<EndpointReference>();
    protected List<PolicySet> policySets = new ArrayList<PolicySet>();
    protected List<Intent> requiredIntents = new ArrayList<Intent>();
    protected boolean remote = false;
    protected String specVersion = "http://docs.oasis-open.org/ns/opencsa/sca/200912";

    protected EndpointImpl(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean unresolved) {
        this.unresolved = unresolved;
    }

    @Override
    public Component getComponent() {
        this.resolve();
        return this.component;
    }

    @Override
    public void setComponent(Component component) {
        this.component = component;
        this.reset();
    }

    @Override
    public ComponentService getService() {
        this.resolve();
        return this.service;
    }

    @Override
    public void setService(ComponentService service) {
        this.service = service;
        this.reset();
    }

    @Override
    public Binding getBinding() {
        this.resolve();
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
        this.reset();
    }

    @Override
    public InterfaceContract getComponentServiceInterfaceContract() {
        this.resolve();
        if (this.interfaceContract == null && this.service != null) {
            this.interfaceContract = this.service.getInterfaceContract();
        }
        return this.interfaceContract;
    }

    public void setInterfaceContract(InterfaceContract interfaceContract) {
        this.interfaceContract = interfaceContract;
    }

    @Override
    public List<EndpointReference> getCallbackEndpointReferences() {
        this.resolve();
        return this.callbackEndpointReferences;
    }

    @Override
    public List<PolicySet> getPolicySets() {
        this.resolve();
        return this.policySets;
    }

    @Override
    public List<Intent> getRequiredIntents() {
        this.resolve();
        return this.requiredIntents;
    }

    @Override
    public ExtensionType getExtensionType() {
        this.getBinding();
        if (this.binding instanceof PolicySubject) {
            return ((PolicySubject)((Object)this.binding)).getExtensionType();
        }
        return null;
    }

    @Override
    public void setExtensionType(ExtensionType type) {
        throw new UnsupportedOperationException();
    }

    public String toStringWithoutHash() {
        String output = "Endpoint: ";
        if (this.getURI() != null) {
            output = output + " URI = " + this.getURI();
        }
        if (this.unresolved) {
            output = output + " [Unresolved]";
        }
        return output;
    }

    public String toString() {
        return "(@" + this.hashCode() + ")" + this.toStringWithoutHash();
    }

    @Override
    public String getURI() {
        if (this.uri == null) {
            if (this.component != null && this.service != null && this.binding != null) {
                String bindingName = this.binding.getName();
                if (bindingName == null) {
                    bindingName = this.service.getName();
                }
                this.uri = this.component.getURI() + "#service-binding(" + this.service.getName() + "/" + bindingName + ")";
            } else if (this.component != null && this.service != null) {
                this.uri = this.component.getURI() + "#service(" + this.service.getName() + ")";
            } else if (this.component != null) {
                this.uri = this.component.getURI();
            }
        }
        return this.uri;
    }

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    protected void resolve() {
    }

    protected void reset() {
        this.uri = null;
    }

    protected void setExtensionPointRegistry(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public boolean isRemote() {
        return this.remote;
    }

    @Override
    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    @Override
    public boolean matches(String serviceURI) {
        String[] parts1 = EndpointImpl.parseServiceURI(serviceURI);
        String[] parts2 = EndpointImpl.parseStructuralURI(this.getURI());
        for (int i = 0; i < parts1.length; ++i) {
            if (parts1[i] == null || parts1[i].equals(parts2[i])) continue;
            return false;
        }
        return true;
    }

    private static String[] parseServiceURI(String serviceURI) {
        if (serviceURI.startsWith("/")) {
            serviceURI = serviceURI.substring(1);
        }
        if (serviceURI.contains("#")) {
            return EndpointImpl.parseStructuralURI(serviceURI);
        }
        String[] names = new String[3];
        String[] segments = serviceURI.split("/");
        for (int i = 0; i < names.length && i < segments.length; ++i) {
            names[i] = segments[i];
        }
        return names;
    }

    private static String[] parseStructuralURI(String structuralURI) {
        String[] names = new String[3];
        int index = structuralURI.lastIndexOf(35);
        if (index == -1) {
            names[0] = structuralURI;
        } else {
            names[0] = structuralURI.substring(0, index);
            String str = structuralURI.substring(index + 1);
            if (str.startsWith("service-binding(") && str.endsWith(")")) {
                String[] parts = (str = str.substring("service-binding(".length(), str.length() - 1)).split("/");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Invalid service-binding URI: " + structuralURI);
                }
                names[1] = parts[0];
                names[2] = parts[1];
            } else if (str.startsWith("service(") && str.endsWith(")")) {
                if (!"".equals(str = str.substring("service(".length(), str.length() - 1))) {
                    names[1] = str;
                }
            } else {
                throw new IllegalArgumentException("Invalid structural URI: " + structuralURI);
            }
        }
        return names;
    }

    @Override
    public boolean isAsyncInvocation() {
        if (this.service != null && this.service.getName().endsWith("_asyncCallback")) {
            return false;
        }
        for (Intent intent : this.getRequiredIntents()) {
            if (!intent.getName().getLocalPart().equals("asyncInvocation")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDeployedURI() {
        return this.deployedURI == null ? (this.binding == null ? null : this.binding.getURI()) : this.deployedURI;
    }

    @Override
    public void setDeployedURI(String deployedURI) {
        this.deployedURI = deployedURI;
    }

    @Override
    public String getSpecVersion() {
        return this.specVersion;
    }

    @Override
    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }
}

