/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.AutoApplySession;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.authentication.mechanism.http.LoginToContinue;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.security.enterprise.identitystore.IdentityStoreHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomee.security.http.LoginToContinueMechanism;

@ApplicationScoped
@AutoApplySession
@LoginToContinue
public class FormAuthenticationMechanism
implements HttpAuthenticationMechanism,
LoginToContinueMechanism {
    @Inject
    private Supplier<LoginToContinue> loginToContinue;
    @Inject
    private IdentityStoreHandler identityStoreHandler;

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        if (this.validateForm(httpMessageContext.getRequest(), username, password)) {
            UsernamePasswordCredential credential = new UsernamePasswordCredential(username, password);
            return httpMessageContext.notifyContainerAboutLogin(this.identityStoreHandler.validate((Credential)credential));
        }
        return httpMessageContext.doNothing();
    }

    @Override
    public LoginToContinue getLoginToContinue() {
        return this.loginToContinue.get();
    }

    private boolean validateForm(HttpServletRequest request, String username, String password) {
        return request.getMethod().equals("POST") && request.getRequestURI().endsWith("/j_security_check") && username != null && !username.isEmpty() && password != null && !password.isEmpty();
    }
}

