/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import java.security.Principal;
import java.util.Arrays;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.AutoApplySession;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@AutoApplySession
@Interceptor
@Priority(value=200)
public class AutoApplySessionInterceptor {
    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        if (invocationContext.getMethod().getName().equals("validateRequest") && Arrays.equals(invocationContext.getMethod().getParameterTypes(), new Class[]{HttpServletRequest.class, HttpServletResponse.class, HttpMessageContext.class})) {
            return this.validateRequest(invocationContext);
        }
        return invocationContext.proceed();
    }

    private AuthenticationStatus validateRequest(InvocationContext invocationContext) throws Exception {
        HttpMessageContext httpMessageContext = (HttpMessageContext)invocationContext.getParameters()[2];
        Principal principal = httpMessageContext.getRequest().getUserPrincipal();
        if (principal == null) {
            Object authenticationStatus = invocationContext.proceed();
            if (AuthenticationStatus.SUCCESS.equals(authenticationStatus)) {
                httpMessageContext.getMessageInfo().getMap().put("javax.servlet.http.registerSession", "true");
            }
            return (AuthenticationStatus)authenticationStatus;
        }
        CallerPrincipalCallback callerPrincipalCallback = new CallerPrincipalCallback(httpMessageContext.getClientSubject(), principal);
        httpMessageContext.getHandler().handle(new Callback[]{callerPrincipalCallback});
        return AuthenticationStatus.SUCCESS;
    }
}

