/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.geronimo.connector.ActivationSpecNamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;

public class ResourceAdapterWrapper
implements ResourceAdapter {
    private final String name;
    private final String resourceAdapterClass;
    private final BootstrapContext bootstrapContext;
    protected final ResourceAdapter resourceAdapter;
    private final Map<String, String> messageListenerToActivationSpecMap;
    private final RecoverableTransactionManager transactionManager;
    private final ValidatorFactory validatorFactory;

    public ResourceAdapterWrapper() {
        this.name = null;
        this.resourceAdapterClass = null;
        this.bootstrapContext = null;
        this.resourceAdapter = null;
        this.messageListenerToActivationSpecMap = null;
        this.transactionManager = null;
        this.validatorFactory = null;
    }

    public ResourceAdapterWrapper(String name, String resourceAdapterClass, Map<String, String> messageListenerToActivationSpecMap, BootstrapContext bootstrapContext, RecoverableTransactionManager transactionManager, ClassLoader cl, ValidatorFactory validatorFactory) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.name = name;
        this.resourceAdapterClass = resourceAdapterClass;
        this.bootstrapContext = bootstrapContext;
        Class<?> clazz = cl.loadClass(resourceAdapterClass);
        this.resourceAdapter = (ResourceAdapter)clazz.newInstance();
        this.messageListenerToActivationSpecMap = messageListenerToActivationSpecMap;
        this.transactionManager = transactionManager;
        this.validatorFactory = validatorFactory;
    }

    public ResourceAdapterWrapper(String name, ResourceAdapter resourceAdapter, Map<String, String> messageListenerToActivationSpecMap, BootstrapContext bootstrapContext, RecoverableTransactionManager transactionManager, ValidatorFactory validatorFactory) {
        this.name = name;
        this.resourceAdapterClass = resourceAdapter.getClass().getName();
        this.bootstrapContext = bootstrapContext;
        this.resourceAdapter = resourceAdapter;
        this.messageListenerToActivationSpecMap = messageListenerToActivationSpecMap;
        this.transactionManager = transactionManager;
        this.validatorFactory = validatorFactory;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceAdapterClass() {
        return this.resourceAdapterClass;
    }

    public Map<String, String> getMessageListenerToActivationSpecMap() {
        return this.messageListenerToActivationSpecMap;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void registerResourceAdapterAssociation(ResourceAdapterAssociation resourceAdapterAssociation) throws ResourceException {
        resourceAdapterAssociation.setResourceAdapter(this.resourceAdapter);
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        throw new IllegalStateException("Don't call this");
    }

    public void stop() {
        throw new IllegalStateException("Don't call this");
    }

    public void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws ResourceException {
        this.resourceAdapter.endpointActivation(messageEndpointFactory, activationSpec);
    }

    public void doRecovery(ActivationSpec activationSpec, String containerId) {
        this.transactionManager.registerNamedXAResourceFactory((NamedXAResourceFactory)new ActivationSpecNamedXAResourceFactory(containerId, activationSpec, this.resourceAdapter));
    }

    public void deregisterRecovery(String containerId) {
        this.transactionManager.unregisterNamedXAResourceFactory(containerId);
    }

    public void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        this.resourceAdapter.endpointDeactivation(messageEndpointFactory, activationSpec);
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return this.resourceAdapter.getXAResources(specs);
    }

    public void doStart() throws Exception {
        Validator validator;
        Set generalSet;
        if (this.validatorFactory != null && !(generalSet = (validator = this.validatorFactory.getValidator()).validate((Object)this.resourceAdapter, new Class[0])).isEmpty()) {
            throw new ConstraintViolationException("Constraint violation for ResourceAdapter " + this.resourceAdapterClass, generalSet);
        }
        this.resourceAdapter.start(this.bootstrapContext);
    }

    public void doStop() {
        this.resourceAdapter.stop();
    }

    public void doFail() {
        this.resourceAdapter.stop();
    }
}

