/*
 * Decompiled with CFR 0.152.
 */
package openejb.shade.org.apache.xalan.transformer;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import openejb.shade.org.apache.xalan.res.XSLMessages;
import openejb.shade.org.apache.xalan.templates.KeyDeclaration;
import openejb.shade.org.apache.xml.utils.QName;
import openejb.shade.org.apache.xpath.XPath;
import openejb.shade.org.apache.xpath.XPathContext;
import openejb.shade.org.apache.xpath.axes.OneStepIteratorForward;

public class KeyIterator
extends OneStepIteratorForward {
    static final long serialVersionUID = -1349109910100249661L;
    private QName m_name;
    private Vector m_keyDeclarations;

    public QName getName() {
        return this.m_name;
    }

    public Vector getKeyDeclarations() {
        return this.m_keyDeclarations;
    }

    KeyIterator(QName name, Vector keyDeclarations) {
        super(16);
        this.m_keyDeclarations = keyDeclarations;
        this.m_name = name;
    }

    public short acceptNode(int testNode) {
        boolean foundKey = false;
        KeyIterator ki = (KeyIterator)this.m_lpi;
        XPathContext xctxt = ki.getXPathContext();
        Vector keys = ki.getKeyDeclarations();
        QName name = ki.getName();
        try {
            int nDeclarations = keys.size();
            for (int i = 0; i < nDeclarations; ++i) {
                KeyDeclaration kd = (KeyDeclaration)keys.elementAt(i);
                if (!kd.getName().equals(name)) continue;
                foundKey = true;
                XPath matchExpr = kd.getMatch();
                double score = matchExpr.getMatchScore(xctxt, testNode);
                kd.getMatch();
                if (score == Double.NEGATIVE_INFINITY) continue;
                return 1;
            }
        }
        catch (TransformerException se) {
            // empty catch block
        }
        if (!foundKey) {
            throw new RuntimeException(XSLMessages.createMessage("ER_NO_XSLKEY_DECLARATION", new Object[]{name.getLocalName()}));
        }
        return 2;
    }
}

