/*
 * Decompiled with CFR 0.152.
 */
package openejb.shade.org.apache.bcel.verifier.structurals;

import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Hashtable;
import openejb.shade.org.apache.bcel.generic.CodeExceptionGen;
import openejb.shade.org.apache.bcel.generic.InstructionHandle;
import openejb.shade.org.apache.bcel.generic.MethodGen;
import openejb.shade.org.apache.bcel.verifier.structurals.ExceptionHandler;

public class ExceptionHandlers {
    private Hashtable exceptionhandlers = new Hashtable();

    public ExceptionHandlers(MethodGen mg) {
        CodeExceptionGen[] cegs = mg.getExceptionHandlers();
        int i = 0;
        while (i < cegs.length) {
            ExceptionHandler eh = new ExceptionHandler(cegs[i].getCatchType(), cegs[i].getHandlerPC());
            InstructionHandle ih = cegs[i].getStartPC();
            while (ih != cegs[i].getEndPC().getNext()) {
                HashSet<ExceptionHandler> hs = (HashSet<ExceptionHandler>)this.exceptionhandlers.get(ih);
                if (hs == null) {
                    hs = new HashSet<ExceptionHandler>();
                    this.exceptionhandlers.put(ih, hs);
                }
                hs.add(eh);
                ih = ih.getNext();
            }
            ++i;
        }
    }

    public ExceptionHandler[] getExceptionHandlers(InstructionHandle ih) {
        HashSet hs = (HashSet)this.exceptionhandlers.get(ih);
        if (hs == null) {
            return new ExceptionHandler[0];
        }
        ExceptionHandler[] ret = new ExceptionHandler[hs.size()];
        return ((AbstractCollection)hs).toArray(ret);
    }
}

