/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util.stub;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DRETURN;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FRETURN;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.IRETURN;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LRETURN;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.Type;
import org.apache.yoko.rmi.util.stub.MethodRef;
import org.apache.yoko.rmi.util.stub.Stub;
import org.apache.yoko.rmi.util.stub.StubHandler;
import org.apache.yoko.rmi.util.stub.StubInitializer;
import org.apache.yoko.rmi.util.stub.Util;

class BCELClassBuilder {
    static final Logger logger = Logger.getLogger(BCELClassBuilder.class.getName());
    static int counter = 0;
    static Type stubHandlerType = BCELClassBuilder.translate(StubHandler.class);
    static Type initializerType = BCELClassBuilder.translate(StubInitializer.class);
    static MethodRef getStubHandlerRef;
    public static final String[] BASIC_CLASS_NAMES;
    static MethodRef[] UNBOXING_METHOD;

    BCELClassBuilder() {
    }

    static Class make(ClassLoader loader, Class superClass, Class[] interfaces, MethodRef[] methods, MethodRef[] superMethodRefs, Object[] data, MethodRef handlerMethodRef, String className, StubInitializer initializer) throws IllegalAccessException, InstantiationException, IllegalArgumentException {
        int i;
        String superClassName = superClass.getName();
        String[] interfaceNames = new String[interfaces.length + 1];
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            interfaceNames[i2] = interfaces[i2].getName();
        }
        interfaceNames[interfaces.length] = Stub.class.getName();
        ClassGen newStubClass = new ClassGen(className, superClassName, "generated", 17, interfaceNames);
        ConstantPoolGen cp = newStubClass.getConstantPool();
        if (handlerMethodRef == null) {
            throw new IllegalArgumentException("handler method is null");
        }
        Class[] paramTypes = handlerMethodRef.getParameterTypes();
        if (paramTypes.length != 3) {
            throw new IllegalArgumentException("handler method must have three arguments");
        }
        if (!paramTypes[0].isAssignableFrom(superClass)) {
            throw new IllegalArgumentException("Handler's 1st argument must be super-type for " + superClass);
        }
        Type typeOfDataFields = BCELClassBuilder.translate(paramTypes[1]);
        if (Object[].class != paramTypes[2]) {
            throw new IllegalArgumentException("Handler's 3rd argument must be Object[]");
        }
        Class handlerClass = handlerMethodRef.getDeclaringClass();
        FieldGen handlerFieldGen = new FieldGen(18, BCELClassBuilder.translate(handlerClass), Util.handlerFieldName(), cp);
        newStubClass.addField(handlerFieldGen.getField());
        BCELClassBuilder.generateHandlerGetter(newStubClass, handlerFieldGen);
        FieldGen initializerFieldGen = new FieldGen(10, BCELClassBuilder.translate(StubInitializer.class), Util.initializerFieldName(), cp);
        newStubClass.addField(initializerFieldGen.getField());
        BCELClassBuilder.emitInitializerConstructor(newStubClass, handlerFieldGen, initializerFieldGen);
        FieldGen[] dataFieldGens = new FieldGen[methods.length];
        for (i = 0; i < methods.length; ++i) {
            MethodRef method = methods[i];
            dataFieldGens[i] = new FieldGen(10, typeOfDataFields, Util.methodFieldName(i), cp);
            newStubClass.addField(dataFieldGens[i].getField());
        }
        for (i = 0; i < methods.length; ++i) {
            BCELClassBuilder.generate(newStubClass, methods[i], dataFieldGens[i], handlerFieldGen, handlerMethodRef);
        }
        for (i = 0; i < superMethodRefs.length; ++i) {
            BCELClassBuilder.generateSuperMethod(newStubClass, superMethodRefs[i]);
        }
        JavaClass javaClass = newStubClass.getJavaClass();
        byte[] classData = javaClass.getBytes();
        try {
            if (Boolean.getBoolean("org.apache.yoko.rmi.util.stub.debug")) {
                File out = new File(className + ".class");
                javaClass.dump(out);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "", ex);
        }
        Class proxyClass = Util.defineClass(loader, className, classData, 0, classData.length);
        for (int i3 = 0; i3 < methods.length; ++i3) {
            try {
                Field f = proxyClass.getDeclaredField(dataFieldGens[i3].getName());
                f.setAccessible(true);
                f.set(null, data[i3]);
                f.setAccessible(false);
                continue;
            }
            catch (NoSuchFieldException ex) {
                logger.log(Level.WARNING, "cannot find field " + dataFieldGens[i3].getName() + " for stub class " + className + " extends: " + superClassName + "implements: " + interfaceNames[0] + (interfaceNames.length > 2 ? " (among others) " : ""), ex);
                throw new Error("internal error!", ex);
            }
        }
        try {
            Field f = proxyClass.getDeclaredField(Util.initializerFieldName());
            f.setAccessible(true);
            f.set(null, initializer);
        }
        catch (NoSuchFieldException ex) {
            throw new Error("internal error!", ex);
        }
        return proxyClass;
    }

    static Class make(ClassLoader loader, Class superClass, Class[] interfaces, MethodRef[] methods, Object[] data, MethodRef handlerMethodRef, String className) throws IllegalAccessException, InstantiationException, IllegalArgumentException {
        int i;
        String superClassName = superClass.getName();
        String[] interfaceNames = new String[interfaces.length + 1];
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            interfaceNames[i2] = interfaces[i2].getName();
        }
        interfaceNames[interfaces.length] = Stub.class.getName();
        ClassGen newStubClass = new ClassGen(className, superClassName, "generated", 17, interfaceNames);
        ConstantPoolGen cp = newStubClass.getConstantPool();
        if (handlerMethodRef == null) {
            throw new IllegalArgumentException("handler method is null");
        }
        Class[] paramTypes = handlerMethodRef.getParameterTypes();
        if (paramTypes.length != 3) {
            throw new IllegalArgumentException("handler method must have three arguments");
        }
        if (!paramTypes[0].isAssignableFrom(superClass)) {
            throw new IllegalArgumentException("Handler's 1st argument must be super-type for " + superClass);
        }
        Type typeOfDataFields = BCELClassBuilder.translate(paramTypes[1]);
        if (Object[].class != paramTypes[2]) {
            throw new IllegalArgumentException("Handler's 3rd argument must be Object[]");
        }
        Class handlerClass = handlerMethodRef.getDeclaringClass();
        FieldGen handlerFieldGen = new FieldGen(18, BCELClassBuilder.translate(handlerClass), Util.handlerFieldName(), cp);
        newStubClass.addField(handlerFieldGen.getField());
        BCELClassBuilder.generateHandlerGetter(newStubClass, handlerFieldGen);
        BCELClassBuilder.emitOneArgConstructor(newStubClass, handlerFieldGen);
        FieldGen[] dataFieldGens = new FieldGen[methods.length];
        for (i = 0; i < methods.length; ++i) {
            MethodRef method = methods[i];
            dataFieldGens[i] = new FieldGen(10, typeOfDataFields, Util.methodFieldName(i), cp);
            newStubClass.addField(dataFieldGens[i].getField());
        }
        for (i = 0; i < methods.length; ++i) {
            BCELClassBuilder.generate(newStubClass, methods[i], dataFieldGens[i], handlerFieldGen, handlerMethodRef);
        }
        JavaClass javaClass = newStubClass.getJavaClass();
        byte[] classData = javaClass.getBytes();
        try {
            if (Boolean.getBoolean("org.apache.yoko.rmi.util.stub.debug")) {
                File out = new File(className + ".class");
                javaClass.dump(out);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "", ex);
        }
        Class proxyClass = Util.defineClass(loader, className, classData, 0, classData.length);
        for (int i3 = 0; i3 < methods.length; ++i3) {
            try {
                Field f = proxyClass.getDeclaredField(dataFieldGens[i3].getName());
                f.setAccessible(true);
                f.set(null, data[i3]);
                f.setAccessible(false);
                continue;
            }
            catch (NoSuchFieldException ex) {
                throw new Error("internal error!", ex);
            }
        }
        return proxyClass;
    }

    static Type translate(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return Type.INT;
            }
            if (clazz == Boolean.TYPE) {
                return Type.BOOLEAN;
            }
            if (clazz == Short.TYPE) {
                return Type.SHORT;
            }
            if (clazz == Byte.TYPE) {
                return Type.BYTE;
            }
            if (clazz == Long.TYPE) {
                return Type.LONG;
            }
            if (clazz == Double.TYPE) {
                return Type.DOUBLE;
            }
            if (clazz == Float.TYPE) {
                return Type.FLOAT;
            }
            if (clazz == Character.TYPE) {
                return Type.CHAR;
            }
            if (clazz == Void.TYPE) {
                return Type.VOID;
            }
            throw new InternalError();
        }
        if (clazz.isArray()) {
            return new ArrayType(BCELClassBuilder.translate(clazz.getComponentType()), 1);
        }
        return new ObjectType(clazz.getName());
    }

    static Type[] translate(Class[] clazz) {
        Type[] result = new Type[clazz.length];
        for (int i = 0; i < clazz.length; ++i) {
            result[i] = BCELClassBuilder.translate(clazz[i]);
        }
        return result;
    }

    public static MethodRef[] getAbstractMethods(Class base, Class[] interfaces) {
        if (base == null) {
            base = Object.class;
        }
        MethodRef[] methods = BCELClassBuilder.collectMethods(base, interfaces);
        return methods;
    }

    public static MethodRef[] collectMethods(Class super_class, Class[] interfaces) {
        HashMap methods = new HashMap();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                BCELClassBuilder.collectAbstractMethods(methods, interfaces[i]);
            }
        }
        BCELClassBuilder.collectAbstractMethods(methods, super_class);
        BCELClassBuilder.removeImplementedMethods(methods, super_class);
        Collection c = methods.values();
        return c.toArray(new MethodRef[c.size()]);
    }

    private static void collectAbstractMethods(HashMap methods, Class type) {
        if (type == Object.class || type == null) {
            return;
        }
        Class<?>[] if_types = type.getInterfaces();
        for (int i = 0; i < if_types.length; ++i) {
            BCELClassBuilder.collectAbstractMethods(methods, if_types[i]);
        }
        BCELClassBuilder.collectAbstractMethods(methods, type.getSuperclass());
        boolean type_is_interface = type.isInterface();
        Method[] declared = type.getDeclaredMethods();
        for (int i = 0; i < declared.length; ++i) {
            String key;
            MethodRef m = new MethodRef(declared[i]);
            if (!type_is_interface && !Modifier.isAbstract(m.getModifiers()) || methods.containsKey(key = m.getName() + m.getSignature())) continue;
            methods.put(key, m);
        }
    }

    private static void removeImplementedMethods(HashMap methods, Class type) {
        if (type == Object.class || type == null) {
            return;
        }
        BCELClassBuilder.removeImplementedMethods(methods, type.getSuperclass());
        Method[] declared = type.getDeclaredMethods();
        for (int i = 0; i < declared.length; ++i) {
            MethodRef m = new MethodRef(declared[i]);
            if (Modifier.isAbstract(m.getModifiers())) continue;
            String key = m.getName() + m.getSignature();
            methods.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String className(String packageName, Class superClass, Class[] interfaces) {
        if (packageName == null) {
            if (!Modifier.isPublic(superClass.getModifiers())) {
                packageName = Util.getPackageName(superClass);
            } else {
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!Modifier.isProtected(interfaces[i].getModifiers())) continue;
                    packageName = Util.getPackageName(interfaces[i]);
                }
            }
            if (packageName == null) {
                packageName = "org.apache.yoko.rmi.util.stub.gen";
            }
        }
        Class<BCELClassBuilder> clazz = BCELClassBuilder.class;
        synchronized (BCELClassBuilder.class) {
            String className = "Stub$$" + counter++;
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return packageName + "." + className;
        }
    }

    static void emitInitializerConstructor(ClassGen stubClass, FieldGen handlerField, FieldGen initializerField) {
        String stubClassName = stubClass.getClassName();
        ConstantPoolGen cp = stubClass.getConstantPool();
        InstructionList il = new InstructionList();
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, Type.NO_ARGS, null, "<init>", stubClassName, il, cp);
        InstructionFactory fac = new InstructionFactory(stubClass, cp);
        il.append(InstructionFactory.createThis());
        il.append((Instruction)fac.createInvoke(stubClass.getSuperclassName(), "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        il.append(InstructionFactory.createThis());
        il.append((Instruction)fac.createGetStatic(stubClassName, initializerField.getName(), initializerField.getType()));
        BCELClassBuilder.emitInvoke(il, fac, getStubHandlerRef);
        il.append(fac.createCast((Type)Type.OBJECT, handlerField.getType()));
        il.append((Instruction)new PUTFIELD(cp.addFieldref(stubClassName, handlerField.getName(), handlerField.getSignature())));
        il.append((Instruction)InstructionConstants.RETURN);
        mg.setMaxStack();
        mg.setMaxLocals();
        stubClass.addMethod(mg.getMethod());
    }

    static void emitOneArgConstructor(ClassGen stubClass, FieldGen handlerField) {
        String stubClassName = stubClass.getClassName();
        ConstantPoolGen cp = stubClass.getConstantPool();
        InstructionList il = new InstructionList();
        Type[] args = new Type[]{handlerField.getType()};
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, args, null, "<init>", stubClassName, il, cp);
        InstructionFactory fac = new InstructionFactory(stubClass, cp);
        il.append(InstructionFactory.createThis());
        il.append((Instruction)fac.createInvoke(stubClass.getSuperclassName(), "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        il.append(InstructionFactory.createThis());
        il.append((Instruction)InstructionFactory.createLoad((Type)handlerField.getType(), (int)1));
        il.append((Instruction)new PUTFIELD(cp.addFieldref(stubClassName, handlerField.getName(), handlerField.getSignature())));
        il.append((Instruction)InstructionConstants.RETURN);
        mg.setMaxStack();
        mg.setMaxLocals();
        stubClass.addMethod(mg.getMethod());
    }

    static void generateHandlerGetter(ClassGen clazz, FieldGen handlerField) {
        Method[] stub_methods = Stub.class.getDeclaredMethods();
        if (stub_methods.length != 1) {
            throw new IllegalStateException("" + Stub.class + " has wrong # methods");
        }
        String handlerGetName = stub_methods[0].getName();
        ConstantPoolGen cp = clazz.getConstantPool();
        InstructionList il = new InstructionList();
        InstructionFactory fac = new InstructionFactory(clazz, cp);
        Type methodReturnType = BCELClassBuilder.translate(Object.class);
        Type[] methodArgTypes = new Type[]{};
        MethodGen mg = new MethodGen(17, methodReturnType, methodArgTypes, null, handlerGetName, clazz.getClassName(), il, cp);
        mg.addAttribute((Attribute)new Synthetic(cp.addUtf8("Synthetic"), 0, null, cp.getConstantPool()));
        il.append(InstructionFactory.createThis());
        il.append((Instruction)fac.createGetField(clazz.getClassName(), handlerField.getName(), handlerField.getType()));
        BCELClassBuilder.emitReturn(il, methodReturnType);
        mg.setMaxStack();
        mg.setMaxLocals();
        clazz.addMethod(mg.getMethod());
    }

    static void generate(ClassGen clazz, MethodRef method, FieldGen dataField, FieldGen handlerField, MethodRef handlerMethodRef) {
        ConstantPoolGen cp = clazz.getConstantPool();
        InstructionList il = new InstructionList();
        InstructionFactory fac = new InstructionFactory(clazz, cp);
        Type methodReturnType = BCELClassBuilder.translate(method.getReturnType());
        Type[] methodArgTypes = BCELClassBuilder.translate(method.getParameterTypes());
        MethodGen mg = new MethodGen(17, methodReturnType, methodArgTypes, null, method.getName(), clazz.getClassName(), il, cp);
        mg.addAttribute((Attribute)new Synthetic(cp.addUtf8("Synthetic"), 0, null, cp.getConstantPool()));
        Class[] throwsException = method.getExceptionTypes();
        for (int i = 0; i < throwsException.length; ++i) {
            mg.addException(throwsException[i].getName());
        }
        il.append(InstructionFactory.createThis());
        il.append((Instruction)fac.createGetField(clazz.getClassName(), handlerField.getName(), handlerField.getType()));
        il.append(InstructionFactory.createThis());
        if (dataField.isStatic()) {
            il.append((Instruction)fac.createGetStatic(clazz.getClassName(), dataField.getName(), dataField.getType()));
        } else {
            il.append(InstructionFactory.createThis());
            il.append((Instruction)fac.createGetField(clazz.getClassName(), dataField.getName(), dataField.getType()));
        }
        il.append((CompoundInstruction)new PUSH(cp, methodArgTypes.length));
        il.append(fac.createNewArray((Type)Type.OBJECT, (short)1));
        int index = 1;
        for (int i = 0; i < methodArgTypes.length; ++i) {
            il.append((Instruction)InstructionConstants.DUP);
            il.append((CompoundInstruction)new PUSH(cp, i));
            il.append((Instruction)InstructionFactory.createLoad((Type)methodArgTypes[i], (int)index));
            BCELClassBuilder.emitCoerceToObject(il, fac, methodArgTypes[i]);
            il.append((Instruction)InstructionFactory.createArrayStore((Type)Type.OBJECT));
            index += methodArgTypes[i].getSize();
        }
        InstructionHandle tryStart = BCELClassBuilder.emitInvoke(il, fac, handlerMethodRef);
        BCELClassBuilder.emitCoerceFromObject(il, fac, methodReturnType);
        InstructionHandle tryEnd = BCELClassBuilder.emitReturn(il, methodReturnType);
        InstructionHandle rethrowLocation = il.append((Instruction)new ATHROW());
        Class[] exceptions = method.getExceptionTypes();
        boolean handle_throwable_exception = true;
        boolean handle_runtime_exception = true;
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                Class ex = exceptions[i];
                if (ex == Throwable.class) {
                    handle_throwable_exception = false;
                }
                if (ex == RuntimeException.class || ex == Exception.class) {
                    handle_runtime_exception = false;
                }
                mg.addExceptionHandler(tryStart, tryEnd, rethrowLocation, (ObjectType)BCELClassBuilder.translate(ex));
            }
        }
        if (handle_throwable_exception && handle_runtime_exception) {
            mg.addExceptionHandler(tryStart, tryEnd, rethrowLocation, new ObjectType("java.lang.RuntimeException"));
        }
        if (handle_throwable_exception) {
            InstructionHandle handlerStart = il.append((Instruction)new ASTORE(1));
            il.append((Instruction)new NEW(cp.addClass("java.lang.reflect.UndeclaredThrowableException")));
            il.append((Instruction)InstructionConstants.DUP);
            il.append((Instruction)new ALOAD(1));
            il.append((Instruction)new INVOKESPECIAL(cp.addMethodref("java.lang.reflect.UndeclaredThrowableException", "<init>", "(Ljava/lang/Throwable;)V")));
            il.append((Instruction)new ATHROW());
            mg.addExceptionHandler(tryStart, tryEnd, handlerStart, new ObjectType("java.lang.Throwable"));
        }
        mg.setMaxStack();
        mg.setMaxLocals();
        clazz.addMethod(mg.getMethod());
    }

    static void generateSuperMethod(ClassGen clazz, MethodRef method) {
        ConstantPoolGen cp = clazz.getConstantPool();
        InstructionList il = new InstructionList();
        InstructionFactory fac = new InstructionFactory(clazz, cp);
        Type methodReturnType = BCELClassBuilder.translate(method.getReturnType());
        Type[] methodArgTypes = BCELClassBuilder.translate(method.getParameterTypes());
        MethodGen mg = new MethodGen(17, methodReturnType, methodArgTypes, null, method.getName(), clazz.getClassName(), il, cp);
        mg.addAttribute((Attribute)new Synthetic(cp.addUtf8("Synthetic"), 0, null, cp.getConstantPool()));
        Class[] throwsException = method.getExceptionTypes();
        for (int i = 0; i < throwsException.length; ++i) {
            mg.addException(throwsException[i].getName());
        }
        il.append(InstructionFactory.createThis());
        int index = 1;
        for (int i = 0; i < methodArgTypes.length; ++i) {
            BCELClassBuilder.emitLoad(il, index, methodArgTypes[i]);
            index += methodArgTypes[i].getSize();
        }
        il.append((Instruction)new INVOKESPECIAL(cp.addMethodref(method.getDeclaringClass().getName(), method.getName(), method.getSignature())));
        BCELClassBuilder.emitReturn(il, methodReturnType);
        mg.setMaxStack();
        mg.setMaxLocals();
        clazz.addMethod(mg.getMethod());
    }

    static InstructionHandle emitLoad(InstructionList il, int index, Type type) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return il.append((Instruction)new ILOAD(index));
            }
            case 11: {
                return il.append((Instruction)new LLOAD(index));
            }
            case 6: {
                return il.append((Instruction)new FLOAD(index));
            }
            case 7: {
                return il.append((Instruction)new DLOAD(index));
            }
        }
        return il.append((Instruction)new ALOAD(index));
    }

    static InstructionHandle emitReturn(InstructionList il, Type type) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return il.append((Instruction)new IRETURN());
            }
            case 11: {
                return il.append((Instruction)new LRETURN());
            }
            case 6: {
                return il.append((Instruction)new FRETURN());
            }
            case 7: {
                return il.append((Instruction)new DRETURN());
            }
            case 12: {
                return il.append((Instruction)InstructionConstants.RETURN);
            }
        }
        return il.append((Instruction)new ARETURN());
    }

    static void emitCoerceToObject(InstructionList il, InstructionFactory fac, Type type) {
        byte tag = type.getType();
        switch (tag) {
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                il.append((Instruction)fac.createNew(new ObjectType(BASIC_CLASS_NAMES[tag])));
                il.append((Instruction)InstructionConstants.DUP_X1);
                il.append((Instruction)InstructionConstants.SWAP);
                il.append((Instruction)fac.createInvoke(BASIC_CLASS_NAMES[tag], "<init>", (Type)Type.VOID, new Type[]{type}, (short)183));
                return;
            }
            case 7: 
            case 11: {
                il.append((Instruction)fac.createNew(new ObjectType(BASIC_CLASS_NAMES[tag])));
                il.append((Instruction)InstructionConstants.DUP_X2);
                il.append((Instruction)InstructionConstants.DUP_X2);
                il.append((Instruction)InstructionConstants.POP);
                il.append((Instruction)fac.createInvoke(BASIC_CLASS_NAMES[tag], "<init>", (Type)Type.VOID, new Type[]{type}, (short)183));
                return;
            }
            case 12: {
                il.append(InstructionConstants.ACONST_NULL);
            }
        }
    }

    static InstructionHandle emitCoerceFromObject(InstructionList il, InstructionFactory fac, Type type) {
        byte tag = type.getType();
        switch (tag) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                il.append(fac.createCast((Type)Type.OBJECT, (Type)new ObjectType(BASIC_CLASS_NAMES[tag])));
                return BCELClassBuilder.emitInvoke(il, fac, UNBOXING_METHOD[tag]);
            }
            case 13: 
            case 14: {
                return il.append(fac.createCast((Type)Type.OBJECT, type));
            }
            case 12: {
                return il.append((Instruction)InstructionConstants.POP);
            }
        }
        throw new RuntimeException("internal error");
    }

    static InstructionHandle emitInvoke(InstructionList il, InstructionFactory fac, MethodRef method) {
        String signature = method.getSignature();
        Type[] args = Type.getArgumentTypes((String)signature);
        Type ret = Type.getReturnType((String)signature);
        String mname = method.getName();
        String cname = method.getDeclaringClass().getName();
        int kind = method.getDeclaringClass().isInterface() ? 185 : (Modifier.isStatic(method.getModifiers()) ? 184 : (method.getName().charAt(0) == '<' ? 183 : 182));
        return il.append((Instruction)fac.createInvoke(cname, mname, ret, args, (short)kind));
    }

    static {
        try {
            getStubHandlerRef = new MethodRef(StubInitializer.class.getDeclaredMethod("getStubHandler", new Class[0]));
        }
        catch (NoSuchMethodException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        BASIC_CLASS_NAMES = new String[]{null, null, null, null, "java.lang.Boolean", "java.lang.Character", "java.lang.Float", "java.lang.Double", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Void", null, null, null, null};
        UNBOXING_METHOD = new MethodRef[12];
        try {
            BCELClassBuilder.UNBOXING_METHOD[4] = new MethodRef(Boolean.class.getDeclaredMethod("booleanValue", new Class[0]));
            BCELClassBuilder.UNBOXING_METHOD[5] = new MethodRef(Character.class.getDeclaredMethod("charValue", new Class[0]));
            BCELClassBuilder.UNBOXING_METHOD[8] = new MethodRef(Byte.class.getDeclaredMethod("byteValue", new Class[0]));
            BCELClassBuilder.UNBOXING_METHOD[9] = new MethodRef(Short.class.getDeclaredMethod("shortValue", new Class[0]));
            BCELClassBuilder.UNBOXING_METHOD[10] = new MethodRef(Integer.class.getDeclaredMethod("intValue", new Class[0]));
            BCELClassBuilder.UNBOXING_METHOD[11] = new MethodRef(Long.class.getDeclaredMethod("longValue", new Class[0]));
            BCELClassBuilder.UNBOXING_METHOD[6] = new MethodRef(Float.class.getDeclaredMethod("floatValue", new Class[0]));
            BCELClassBuilder.UNBOXING_METHOD[7] = new MethodRef(Double.class.getDeclaredMethod("doubleValue", new Class[0]));
        }
        catch (NoSuchMethodException ex) {
            throw new Error(ex);
        }
    }
}

