/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Map;
import org.apache.yoko.rmi.impl.ArrayDescriptor;
import org.apache.yoko.rmi.impl.CopyRecursionException;
import org.apache.yoko.rmi.impl.CopyRecursionResolver;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.CorbaObjectReader;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

class ValueArrayDescriptor
extends ArrayDescriptor {
    ValueArrayDescriptor(Class type, Class elemType, TypeRepository rep) {
        super(type, elemType, rep);
    }

    public void writeValue(org.omg.CORBA.portable.OutputStream out, Serializable value) {
        Object[] arr = (Object[])value;
        out.write_long(arr.length);
        Serializable[] sarr = (Serializable[])arr;
        OutputStream _out = (OutputStream)out;
        for (int i = 0; i < sarr.length; ++i) {
            _out.write_value(sarr[i], this.getElementRepositoryID());
        }
    }

    public Serializable readValue(InputStream in, Map offsetMap, Integer key) {
        try {
            CorbaObjectReader reader = this.makeCorbaObjectReader(in, offsetMap, null);
            int length = ((ObjectInputStream)reader).readInt();
            Object[] arr = (Object[])Array.newInstance(this.elementType, length);
            offsetMap.put(key, arr);
            for (int i = 0; i < length; ++i) {
                arr[i] = ((ObjectReader)reader).readValueObject(this.elementType);
            }
            return arr;
        }
        catch (IOException ex) {
            throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    Object copyObject(Object value, CopyState state) {
        Object[] orig = (Object[])value;
        final Object[] result = (Object[])Array.newInstance(value.getClass().getComponentType(), orig.length);
        state.put(value, result);
        for (int i = 0; i < orig.length; ++i) {
            try {
                result[i] = state.copy(orig[i]);
                continue;
            }
            catch (CopyRecursionException e) {
                final int idx = i;
                state.registerRecursion(new CopyRecursionResolver(orig[i]){

                    public void resolve(Object value) {
                        result[idx] = value;
                    }
                });
            }
        }
        return result;
    }

    void printFields(PrintWriter pw, Map recurse, Object val) {
        Object[] arr = (Object[])val;
        TypeDescriptor desc = this.getTypeRepository().getDescriptor(this.elementType);
        pw.print("length=" + arr.length + "; ");
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                pw.print(", ");
            }
            desc.print(pw, recurse, arr[i]);
        }
    }
}

