/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.rmi.Remote;
import java.util.Map;
import org.apache.yoko.rmi.impl.CopyRecursionException;
import org.apache.yoko.rmi.impl.CopyRecursionResolver;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.FieldDescriptor;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;

class RemoteFieldDescriptor
extends FieldDescriptor {
    Class interfaceType;

    RemoteFieldDescriptor(Class owner, Class type, String name, Field f) {
        super(owner, type, name, f);
        if (type.isInterface()) {
            this.interfaceType = type;
        } else {
            Class t = type;
            block0: while (!Object.class.equals((Object)t)) {
                Class<?>[] ifs = t.getInterfaces();
                for (int i = 0; i < ifs.length; ++i) {
                    if (!Remote.class.isAssignableFrom(ifs[i])) continue;
                    this.interfaceType = ifs[i];
                    break block0;
                }
                t = t.getSuperclass();
            }
            if (this.interfaceType == null) {
                throw new RuntimeException("cannot find remote interface for " + type);
            }
        }
    }

    public void read(ObjectReader reader, Object obj) throws IOException {
        if (this.field == null) {
            throw new IOException("cannot read/write using serialPersistentFields");
        }
        try {
            Remote value = reader.readRemoteObject(this.interfaceType);
            this.field.set(obj, value);
        }
        catch (IllegalAccessException ex) {
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
    }

    public void write(ObjectWriter writer, Object obj) throws IOException {
        if (this.field == null) {
            throw new IOException("cannot read/write using serialPersistentFields");
        }
        try {
            writer.writeRemoteObject((Remote)this.field.get(obj));
        }
        catch (IllegalAccessException ex) {
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
    }

    void copyState(Object orig, final Object copy, CopyState state) {
        try {
            this.field.set(copy, state.copy(this.field.get(orig)));
        }
        catch (CopyRecursionException e) {
            state.registerRecursion(new CopyRecursionResolver(orig){

                public void resolve(Object value) {
                    try {
                        RemoteFieldDescriptor.this.field.set(copy, value);
                    }
                    catch (IllegalAccessException ex) {
                        throw (InternalError)new InternalError(ex.getMessage()).initCause(ex);
                    }
                }
            });
        }
        catch (IllegalAccessException ex) {
            throw (InternalError)new InternalError(ex.getMessage()).initCause(ex);
        }
    }

    void readFieldIntoMap(ObjectReader reader, Map map) throws IOException {
        Remote value = reader.readRemoteObject(this.interfaceType);
        map.put(this.getJavaName(), value);
    }

    void writeFieldFromMap(ObjectWriter writer, Map map) throws IOException {
        Remote value = (Remote)map.get(this.getJavaName());
        writer.writeRemoteObject(value);
    }
}

