/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.dbcp;

import java.sql.SQLException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.commons.dbcp2.managed.TransactionContext;
import org.apache.commons.dbcp2.managed.TransactionRegistry;

public class DbcpTransactionRegistry
extends TransactionRegistry {
    private TransactionManager transactionManager;

    public DbcpTransactionRegistry(TransactionManager transactionManager) {
        this(transactionManager, null);
    }

    public DbcpTransactionRegistry(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        super(transactionManager, transactionSynchronizationRegistry);
        this.transactionManager = transactionManager;
    }

    public TransactionContext getActiveTransactionContext() throws SQLException {
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                return null;
            }
            int status = transaction.getStatus();
            if (status != 0 && status != 1) {
                return null;
            }
        }
        catch (SystemException e) {
            throw new SQLException("Unable to determine current transaction ", e);
        }
        return super.getActiveTransactionContext();
    }
}

