/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.cdi.OpenEJBLifecycle;
import org.apache.openejb.cdi.ThreadSingletonServiceImpl;
import org.apache.openejb.cdi.WebappWebBeansContext;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.server.httpd.WebBeansListenerHelper;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.util.WebBeansUtil;

public class BeginWebBeansListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener,
HttpSessionActivationListener {
    private final String contextKey;
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_CDI, BeginWebBeansListener.class);
    private final CdiAppContextsService contextsService;
    protected WebBeansContext webBeansContext;

    public BeginWebBeansListener(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.contextsService = webBeansContext != null ? (CdiAppContextsService)CdiAppContextsService.class.cast(webBeansContext.getService(ContextsService.class)) : null;
        this.contextKey = "org.apache.tomee.catalina.WebBeansListener@" + webBeansContext.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(ServletRequestEvent event) {
        if (this.webBeansContext == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Destroying a request : [{0}]", new Object[]{event == null ? "null" : event.getServletRequest().getRemoteAddr()});
        }
        Object oldContext = event != null ? event.getServletRequest().getAttribute(this.contextKey) : null;
        try {
            ELContextStore elStore = ELContextStore.getInstance((boolean)false);
            if (elStore != null) {
                elStore.destroyELContextStore();
            }
            this.contextsService.endContext(RequestScoped.class, (Object)event);
            if (this.webBeansContext instanceof WebappWebBeansContext) {
                ((WebappWebBeansContext)this.webBeansContext).getParent().getContextsService().endContext(RequestScoped.class, (Object)event);
            }
        }
        finally {
            this.contextsService.removeThreadLocals();
            ThreadSingletonServiceImpl.enter((WebBeansContext)((WebBeansContext)oldContext));
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        WebBeansContext oldContext = ThreadSingletonServiceImpl.enter((WebBeansContext)this.webBeansContext);
        if (event != null) {
            event.getServletRequest().setAttribute(this.contextKey, (Object)oldContext);
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting a new request : [{0}]", new Object[]{event == null ? "null" : event.getServletRequest().getRemoteAddr()});
            }
            if (this.webBeansContext instanceof WebappWebBeansContext) {
                ((WebappWebBeansContext)this.webBeansContext).getParent().getContextsService().startContext(RequestScoped.class, (Object)event);
            }
            this.contextsService.startContext(RequestScoped.class, (Object)event);
        }
        catch (Exception e) {
            logger.error("ERROR_0019", new Object[]{event == null ? "null" : event.getServletRequest()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting a session with session id : [{0}]", new Object[]{event.getSession().getId()});
            }
            if (this.webBeansContext instanceof WebappWebBeansContext) {
                ((WebappWebBeansContext)this.webBeansContext).getParent().getContextsService().startContext(SessionScoped.class, (Object)event.getSession());
            }
            this.contextsService.startContext(SessionScoped.class, (Object)event.getSession());
        }
        catch (Exception e) {
            logger.error("ERROR_0020", new Object[]{event.getSession()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (this.webBeansContext == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Destroying a session with session id : [{0}]", new Object[]{event.getSession().getId()});
        }
        this.contextsService.endContext(SessionScoped.class, (Object)event.getSession());
        WebBeansListenerHelper.destroyFakedRequest(this);
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        WebBeansListenerHelper.ensureRequestScope((ContextsService)this.contextsService, this);
    }

    public void sessionDidActivate(HttpSessionEvent event) {
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            OpenEJBLifecycle.initializeServletContext((ServletContext)servletContextEvent.getServletContext(), (WebBeansContext)this.webBeansContext);
        }
        catch (Exception e) {
            logger.warning(e.getMessage(), (Throwable)e);
        }
        WebBeansListenerHelper.ensureRequestScope((ContextsService)this.contextsService, this);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        WebBeansListenerHelper.destroyFakedRequest(this);
        WebContext wc = (WebContext)WebContext.class.cast(servletContextEvent.getServletContext().getAttribute("openejb.web.context"));
        if (wc != null) {
            wc.release();
        }
    }
}

