/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee.oejb3;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.oejb3.EjbLink;
import org.apache.openejb.jee.oejb3.Jndi;
import org.apache.openejb.jee.oejb3.PropertiesAdapter;
import org.apache.openejb.jee.oejb3.Query;
import org.apache.openejb.jee.oejb3.ResourceLink;
import org.apache.openejb.jee.oejb3.RoleMapping;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"jndi", "ejbLink", "resourceLink", "query", "roleMapping", "properties"})
@XmlRootElement(name="ejb-deployment")
public class EjbDeployment {
    @XmlElement(name="jndi", required=true)
    protected List<Jndi> jndi;
    @XmlElement(name="ejb-link", required=true)
    protected List<EjbLink> ejbLink;
    @XmlElement(name="resource-link", required=true)
    protected List<ResourceLink> resourceLink;
    @XmlElement(required=true)
    protected List<Query> query;
    @XmlElement(name="role-mapping")
    protected List<RoleMapping> roleMapping;
    @XmlAttribute(name="container-id")
    protected String containerId;
    @XmlAttribute(name="deployment-id")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String deploymentId;
    @XmlAttribute(name="ejb-name")
    protected String ejbName;
    @XmlElement(name="properties")
    @XmlJavaTypeAdapter(value=PropertiesAdapter.class)
    protected Properties properties;

    public EjbDeployment() {
    }

    public EjbDeployment(String containerId, String deploymentId, String ejbName) {
        this.containerId = containerId;
        this.deploymentId = deploymentId;
        this.ejbName = ejbName;
    }

    public EjbDeployment(EnterpriseBean bean) {
        this.deploymentId = bean.getEjbName();
        this.ejbName = bean.getEjbName();
    }

    public List<EjbLink> getEjbLink() {
        if (this.ejbLink == null) {
            this.ejbLink = new ArrayList<EjbLink>();
        }
        return this.ejbLink;
    }

    public List<Jndi> getJndi() {
        if (this.jndi == null) {
            this.jndi = new ArrayList<Jndi>();
        }
        return this.jndi;
    }

    public List<ResourceLink> getResourceLink() {
        if (this.resourceLink == null) {
            this.resourceLink = new ArrayList<ResourceLink>();
        }
        return this.resourceLink;
    }

    public List<Query> getQuery() {
        if (this.query == null) {
            this.query = new ArrayList<Query>();
        }
        return this.query;
    }

    public ResourceLink getResourceLink(String refName) {
        return this.getResourceLinksMap().get(refName);
    }

    public Map<String, ResourceLink> getResourceLinksMap() {
        LinkedHashMap<String, ResourceLink> map = new LinkedHashMap<String, ResourceLink>();
        for (ResourceLink link : this.getResourceLink()) {
            map.put(link.getResRefName(), link);
        }
        return map;
    }

    public EjbLink getEjbLink(String refName) {
        return this.getEjbLinksMap().get(refName);
    }

    public Map<String, EjbLink> getEjbLinksMap() {
        LinkedHashMap<String, EjbLink> map = new LinkedHashMap<String, EjbLink>();
        for (EjbLink link : this.getEjbLink()) {
            map.put(link.getEjbRefName(), link);
        }
        return map;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String value) {
        this.containerId = value;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String value) {
        this.deploymentId = value;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String value) {
        this.ejbName = value;
    }

    public void addResourceLink(ResourceLink resourceLink) {
        this.getResourceLink().add(resourceLink);
    }

    public void removeResourceLink(String resRefName) {
        this.resourceLink.removeIf(link -> resRefName.equals(link.getResRefName()));
    }

    public void addEjbLink(EjbLink ejbLink) {
        this.getEjbLink().add(ejbLink);
    }

    public void addQuery(Query query) {
        this.getQuery().add(query);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void addProperty(String key, String value) {
        this.getProperties().setProperty(key, value);
    }

    public List<RoleMapping> getRoleMapping() {
        if (this.roleMapping == null) {
            this.roleMapping = new ArrayList<RoleMapping>();
        }
        return this.roleMapping;
    }
}

