/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils;

import java.util.List;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.oauth2.common.OAuthContext;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;

public final class OAuthContextUtils {
    private OAuthContextUtils() {
    }

    public static String resolveUserId(MessageContext mc) {
        OAuthContext oauth = OAuthContextUtils.getContext(mc);
        return oauth.getSubject().getId();
    }

    public static String resolveUserName(MessageContext mc) {
        OAuthContext oauth = OAuthContextUtils.getContext(mc);
        return oauth.getSubject().getLogin();
    }

    public static List<String> resolveUserRoles(MessageContext mc) {
        OAuthContext oauth = OAuthContextUtils.getContext(mc);
        return oauth.getSubject().getRoles();
    }

    public static boolean isUserInRole(MessageContext mc, String role) {
        List<String> userroles = OAuthContextUtils.resolveUserRoles(mc);
        return userroles.contains(role);
    }

    public static void assertRole(MessageContext mc, String role) {
        if (!OAuthContextUtils.isUserInRole(mc, role)) {
            throw ExceptionUtils.toForbiddenException(null, null);
        }
    }

    public static List<OAuthPermission> resolvePermissions(MessageContext mc) {
        OAuthContext oauth = OAuthContextUtils.getContext(mc);
        return oauth.getPermissions();
    }

    public static String resolveTokenKey(MessageContext mc) {
        OAuthContext oauth = OAuthContextUtils.getContext(mc);
        return oauth.getTokenKey();
    }

    public static String resolveClient(MessageContext mc) {
        OAuthContext oauth = OAuthContextUtils.getContext(mc);
        return oauth.getClientId();
    }

    public static void assertClient(MessageContext mc, String client) {
        String cl = OAuthContextUtils.resolveClient(mc);
        if (cl == null || !cl.equals(client)) {
            throw ExceptionUtils.toForbiddenException(null, null);
        }
    }

    public static OAuthContext getContext(MessageContext mc) {
        OAuthContext oauth = mc.getContent(OAuthContext.class);
        if (oauth == null || oauth.getSubject() == null || oauth.getSubject().getLogin() == null) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        return oauth;
    }
}

