/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.hawk;

import java.security.SecureRandom;
import java.util.Map;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.oauth2.client.HttpRequestProperties;
import org.apache.cxf.rs.security.oauth2.common.AccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.HmacAlgorithm;
import org.apache.cxf.rt.security.crypto.HmacUtils;

public class HawkAuthorizationScheme {
    private static final String SEPARATOR = "\n";
    private static final String HAWK_1_HEADER = "hawk.1.header";
    private HttpRequestProperties props;
    private String macKey;
    private String timestamp;
    private String nonce;

    public HawkAuthorizationScheme(HttpRequestProperties props, AccessToken token) {
        this.props = props;
        this.macKey = token.getTokenKey();
        this.timestamp = Long.toString(System.currentTimeMillis());
        this.nonce = HawkAuthorizationScheme.generateNonce();
    }

    public HawkAuthorizationScheme(HttpRequestProperties props, Map<String, String> schemeParams) {
        this.props = props;
        this.macKey = schemeParams.get("id");
        this.timestamp = schemeParams.get("ts");
        this.nonce = schemeParams.get("nonce");
    }

    public String getMacKey() {
        return this.macKey;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String toAuthorizationHeader(String macAlgo, String macSecret) {
        String data = this.getNormalizedRequestString();
        String signature = HmacUtils.encodeHmacString(macSecret, HmacAlgorithm.toHmacAlgorithm(macAlgo).getJavaName(), data);
        StringBuilder sb = new StringBuilder();
        sb.append("Hawk").append(' ');
        HawkAuthorizationScheme.addParameter(sb, "id", this.macKey, false);
        HawkAuthorizationScheme.addParameter(sb, "ts", this.timestamp, false);
        HawkAuthorizationScheme.addParameter(sb, "nonce", this.nonce, false);
        HawkAuthorizationScheme.addParameter(sb, "mac", signature, true);
        return sb.toString();
    }

    private static void addParameter(StringBuilder sb, String name, String value, boolean last) {
        sb.append(name).append('=').append('\"').append(value).append('\"');
        if (!last) {
            sb.append(',');
        }
    }

    public String getNormalizedRequestString() {
        String requestURI = this.props.getRequestPath();
        if (!StringUtils.isEmpty(this.props.getRequestQuery())) {
            requestURI = requestURI + "?" + HawkAuthorizationScheme.normalizeQuery(this.props.getRequestQuery());
        }
        return "hawk.1.header\n" + this.timestamp + SEPARATOR + this.nonce + SEPARATOR + this.props.getHttpMethod().toUpperCase() + SEPARATOR + requestURI + SEPARATOR + this.props.getHostName() + SEPARATOR + this.props.getPort() + SEPARATOR + SEPARATOR + SEPARATOR;
    }

    private static String normalizeQuery(String query) {
        return query;
    }

    private static String generateNonce() {
        byte[] randomBytes = new byte[20];
        new SecureRandom().nextBytes(randomBytes);
        return Base64Utility.encode(randomBytes);
    }
}

