/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.ClientRegistrationProvider;
import org.apache.cxf.rs.security.oauth2.services.ClientRegistration;
import org.apache.cxf.rs.security.oauth2.services.ClientRegistrationResponse;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

@Path(value="register")
public class DynamicRegistrationService {
    private static final String DEFAULT_APPLICATION_TYPE = "web";
    private static final Integer DEFAULT_CLIENT_ID_SIZE = 10;
    private ClientRegistrationProvider clientProvider;
    private String initialAccessToken;
    private int clientIdSizeInBytes = DEFAULT_CLIENT_ID_SIZE;
    private MessageContext mc;
    private boolean supportRegistrationAccessTokens = true;
    private String userRole;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response register(ClientRegistration request) {
        this.checkInitialAuthentication();
        Client client = this.createNewClient(request);
        this.createRegAccessToken(client);
        this.clientProvider.setClient(client);
        return Response.status((int)201).entity((Object)this.fromClientToRegistrationResponse(client)).build();
    }

    protected void checkInitialAuthentication() {
        if (this.initialAccessToken != null) {
            String accessToken = this.getRequestAccessToken();
            if (!this.initialAccessToken.equals(accessToken)) {
                throw ExceptionUtils.toNotAuthorizedException(null, null);
            }
        } else {
            this.checkSecurityContext();
        }
    }

    protected void checkSecurityContext() {
        SecurityContext sc = this.mc.getSecurityContext();
        if (sc.getUserPrincipal() == null) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        if (this.userRole != null && !sc.isUserInRole(this.userRole)) {
            throw ExceptionUtils.toForbiddenException(null, null);
        }
    }

    protected String createRegAccessToken(Client client) {
        String regAccessToken = OAuthUtils.generateRandomTokenKey();
        client.getProperties().put("registration_access_token", regAccessToken);
        return regAccessToken;
    }

    protected void checkRegistrationAccessToken(Client c, String accessToken) {
        String regAccessToken = c.getProperties().get("registration_access_token");
        if (regAccessToken == null || !regAccessToken.equals(accessToken)) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
    }

    @GET
    @Produces(value={"application/json"})
    public ClientRegistration readClientRegistrationWithQuery(@QueryParam(value="client_id") String clientId) {
        return this.doReadClientRegistration(clientId);
    }

    @GET
    @Path(value="{clientId}")
    @Produces(value={"application/json"})
    public ClientRegistration readClientRegistrationWithPath(@PathParam(value="clientId") String clientId) {
        return this.doReadClientRegistration(clientId);
    }

    @PUT
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ClientRegistration updateClientRegistration(@PathParam(value="clientId") String clientId, ClientRegistration request) {
        Client client = this.readClient(clientId);
        this.fromClientRegistrationToClient(request, client);
        this.clientProvider.setClient(client);
        return this.fromClientToClientRegistration(client);
    }

    @DELETE
    @Path(value="{clientId}")
    public Response deleteClientRegistration(@PathParam(value="clientId") String clientId) {
        if (this.readClient(clientId) != null) {
            this.clientProvider.removeClient(clientId);
        }
        return Response.ok().build();
    }

    protected ClientRegistrationResponse fromClientToRegistrationResponse(Client client) {
        ClientRegistrationResponse response = new ClientRegistrationResponse();
        response.setClientId(client.getClientId());
        if (client.getClientSecret() != null) {
            response.setClientSecret(client.getClientSecret());
            response.setClientSecretExpiresAt(0L);
        }
        response.setClientIdIssuedAt(client.getRegisteredAt());
        response.setGrantTypes(client.getAllowedGrantTypes());
        UriBuilder ub = this.getMessageContext().getUriInfo().getAbsolutePathBuilder();
        if (this.supportRegistrationAccessTokens) {
            response.setRegistrationClientUri(ub.path(client.getClientId()).build(new Object[0]).toString());
            response.setRegistrationAccessToken(client.getProperties().get("registration_access_token"));
        }
        return response;
    }

    protected ClientRegistration doReadClientRegistration(String clientId) {
        Client client = this.readClient(clientId);
        return this.fromClientToClientRegistration(client);
    }

    protected ClientRegistration fromClientToClientRegistration(Client c) {
        ClientRegistration reg = new ClientRegistration();
        reg.setClientName(c.getApplicationName());
        reg.setGrantTypes(c.getAllowedGrantTypes());
        reg.setApplicationType(c.isConfidential() ? DEFAULT_APPLICATION_TYPE : "native");
        if (!c.getRedirectUris().isEmpty()) {
            reg.setRedirectUris(c.getRedirectUris());
        }
        if (!c.getRegisteredScopes().isEmpty()) {
            reg.setScope(OAuthUtils.convertListOfScopesToString(c.getRegisteredScopes()));
        }
        if (c.getApplicationWebUri() != null) {
            reg.setClientUri(c.getApplicationWebUri());
        }
        if (c.getApplicationLogoUri() != null) {
            reg.setLogoUri(c.getApplicationLogoUri());
        }
        if (!c.getRegisteredAudiences().isEmpty()) {
            reg.setResourceUris(c.getRegisteredAudiences());
        }
        if (c.getTokenEndpointAuthMethod() != null) {
            reg.setTokenEndpointAuthMethod(c.getTokenEndpointAuthMethod());
            if ("tls_client_auth".equals(c.getTokenEndpointAuthMethod())) {
                String issuerDn;
                String subjectDn = c.getProperties().get("tls_client_auth_subject_dn");
                if (subjectDn != null) {
                    reg.setProperty("tls_client_auth_subject_dn", subjectDn);
                }
                if ((issuerDn = c.getProperties().get("tls_client_auth_root_dn")) != null) {
                    reg.setProperty("tls_client_auth_root_dn", issuerDn);
                }
            }
        }
        return reg;
    }

    protected Client readClient(String clientId) {
        String accessToken = this.getRequestAccessToken();
        Client c = this.clientProvider.getClient(clientId);
        if (c == null) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        this.checkRegistrationAccessToken(c, accessToken);
        return c;
    }

    public String getInitialAccessToken() {
        return this.initialAccessToken;
    }

    public void setInitialAccessToken(String initialAccessToken) {
        this.initialAccessToken = initialAccessToken;
    }

    protected Client createNewClient(ClientRegistration request) {
        List<String> grantTypes;
        String clientId = this.generateClientId();
        String clientName = request.getClientName();
        if (StringUtils.isEmpty(clientName)) {
            clientName = clientId;
        }
        if ((grantTypes = request.getGrantTypes()) == null) {
            grantTypes = Collections.singletonList("authorization_code");
        }
        String tokenEndpointAuthMethod = request.getTokenEndpointAuthMethod();
        boolean passwordRequired = this.isPasswordRequired(grantTypes, tokenEndpointAuthMethod);
        String appType = request.getApplicationType();
        if (appType == null) {
            appType = DEFAULT_APPLICATION_TYPE;
        }
        boolean isConfidential = DEFAULT_APPLICATION_TYPE.equals(appType) && (passwordRequired || "tls_client_auth".equals(tokenEndpointAuthMethod));
        String clientSecret = passwordRequired ? this.generateClientSecret(request) : null;
        Client newClient = new Client(clientId, clientSecret, isConfidential, clientName);
        newClient.setAllowedGrantTypes(grantTypes);
        newClient.setTokenEndpointAuthMethod(tokenEndpointAuthMethod);
        if ("tls_client_auth".equals(tokenEndpointAuthMethod)) {
            String issuerDn;
            String subjectDn = (String)request.getProperty("tls_client_auth_subject_dn");
            if (subjectDn != null) {
                newClient.getProperties().put("tls_client_auth_subject_dn", subjectDn);
            }
            if ((issuerDn = (String)request.getProperty("tls_client_auth_root_dn")) != null) {
                newClient.getProperties().put("tls_client_auth_root_dn", issuerDn);
            }
        }
        newClient.setRegisteredAt(System.currentTimeMillis() / 1000L);
        this.fromClientRegistrationToClient(request, newClient);
        SecurityContext sc = this.mc.getSecurityContext();
        if (sc != null && sc.getUserPrincipal() != null && sc.getUserPrincipal().getName() != null) {
            UserSubject subject = new UserSubject(sc.getUserPrincipal().getName());
            newClient.setResourceOwnerSubject(subject);
        }
        newClient.setRegisteredDynamically(true);
        return newClient;
    }

    protected void fromClientRegistrationToClient(ClientRegistration request, Client client) {
        String clientLogoUri;
        String clientUri;
        String scope;
        List<String> resourceUris;
        List<String> grantTypes = client.getAllowedGrantTypes();
        List<String> redirectUris = request.getRedirectUris();
        if (redirectUris != null) {
            String appType = request.getApplicationType();
            if (appType == null) {
                appType = DEFAULT_APPLICATION_TYPE;
            }
            for (String uri : redirectUris) {
                this.validateRequestUri(uri, appType, grantTypes);
            }
            client.setRedirectUris(redirectUris);
        }
        if (client.getRedirectUris().isEmpty() && (grantTypes.contains("authorization_code") || grantTypes.contains("implicit"))) {
            OAuthError error = new OAuthError("invalid_request", "A Redirection URI is required");
            this.reportInvalidRequestError(error);
        }
        if ((resourceUris = request.getResourceUris()) != null) {
            client.setRegisteredAudiences(resourceUris);
        }
        if (!StringUtils.isEmpty(scope = request.getScope())) {
            client.setRegisteredScopes(OAuthUtils.parseScope(scope));
        }
        if ((clientUri = request.getClientUri()) != null) {
            client.setApplicationWebUri(clientUri);
        }
        if ((clientLogoUri = request.getLogoUri()) != null) {
            client.setApplicationLogoUri(clientLogoUri);
        }
    }

    protected boolean isPasswordRequired(List<String> grantTypes, String tokenEndpointAuthMethod) {
        if (grantTypes.contains("implicit")) {
            return false;
        }
        if (tokenEndpointAuthMethod == null) {
            return true;
        }
        return !"none".equals(tokenEndpointAuthMethod) && ("client_secret_basic".equals(tokenEndpointAuthMethod) || "client_secret_post".equals(tokenEndpointAuthMethod));
    }

    protected void validateRequestUri(String uri, String appType, List<String> grantTypes) {
    }

    public void setClientProvider(ClientRegistrationProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    protected String generateClientId() {
        return Base64UrlUtility.encode(CryptoUtils.generateSecureRandomBytes(this.getClientIdSizeInBytes()));
    }

    public int getClientIdSizeInBytes() {
        return this.clientIdSizeInBytes;
    }

    public void setClientIdSizeInBytes(int size) {
        this.clientIdSizeInBytes = size;
    }

    protected String generateClientSecret(ClientRegistration request) {
        return Base64UrlUtility.encode(CryptoUtils.generateSecureRandomBytes(this.getClientSecretSizeInBytes(request)));
    }

    protected String getRequestAccessToken() {
        return AuthorizationUtils.getAuthorizationParts(this.getMessageContext(), Collections.singleton("Bearer"))[1];
    }

    protected int getClientSecretSizeInBytes(ClientRegistration request) {
        return 32;
    }

    @Context
    public void setMessageContext(MessageContext context) {
        this.mc = context;
    }

    public MessageContext getMessageContext() {
        return this.mc;
    }

    public void setSupportRegistrationAccessTokens(boolean supportRegistrationAccessTokens) {
        this.supportRegistrationAccessTokens = supportRegistrationAccessTokens;
    }

    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }

    private void reportInvalidRequestError(OAuthError entity) {
        this.reportInvalidRequestError(entity, MediaType.APPLICATION_JSON_TYPE);
    }

    private void reportInvalidRequestError(OAuthError entity, MediaType mt) {
        Response.ResponseBuilder rb = JAXRSUtils.toResponseBuilder(400);
        if (mt != null) {
            rb.type(mt);
        }
        throw ExceptionUtils.toBadRequestException(null, rb.entity((Object)entity).build());
    }
}

