/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.security.cert.X509Certificate;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJoseJwtConsumer;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class OAuthServerJoseJwtConsumer
extends OAuthJoseJwtConsumer {
    private boolean verifyWithClientCertificates;

    public JwtToken getJwtToken(String wrappedJwtToken, Client client) {
        return this.getJwtToken(wrappedJwtToken, this.getInitializedDecryptionProvider(client), this.getInitializedSignatureVerifier(client));
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider(Client c) {
        if (c == null) {
            return null;
        }
        return super.getInitializedDecryptionProvider(c.getClientSecret());
    }

    protected JwsSignatureVerifier getInitializedSignatureVerifier(Client c) {
        JwsSignatureVerifier theSignatureVerifier = null;
        if (this.verifyWithClientCertificates && c != null && !c.getApplicationCertificates().isEmpty()) {
            X509Certificate cert = (X509Certificate)CryptoUtils.decodeCertificate(c.getApplicationCertificates().get(0));
            theSignatureVerifier = JwsUtils.getPublicKeySignatureVerifier(cert.getPublicKey(), SignatureAlgorithm.RS256);
        }
        if (theSignatureVerifier == null && c != null && c.getClientSecret() != null) {
            theSignatureVerifier = super.getInitializedSignatureVerifier(c.getClientSecret());
        }
        return theSignatureVerifier;
    }

    public void setVerifyWithClientCertificates(boolean verifyWithClientCertificates) {
        if (this.isVerifyWithClientSecret()) {
            throw new SecurityException();
        }
        this.verifyWithClientCertificates = verifyWithClientCertificates;
    }
}

