/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtProducer;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class OAuthJoseJwtProducer
extends JoseJwtProducer {
    private boolean encryptWithClientSecret;
    private boolean signWithClientSecret;

    public String processJwt(JwtToken jwt, String clientSecret) {
        return this.processJwt(jwt, this.getInitializedEncryptionProvider(clientSecret), this.getInitializedSignatureProvider(clientSecret));
    }

    protected JwsSignatureProvider getInitializedSignatureProvider(String clientSecret) {
        if (this.signWithClientSecret && !StringUtils.isEmpty(clientSecret)) {
            return OAuthUtils.getClientSecretSignatureProvider(clientSecret);
        }
        return null;
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider(String clientSecret) {
        if (this.encryptWithClientSecret && !StringUtils.isEmpty(clientSecret)) {
            return OAuthUtils.getClientSecretEncryptionProvider(clientSecret);
        }
        return null;
    }

    public void setEncryptWithClientSecret(boolean encryptWithClientSecret) {
        if (this.signWithClientSecret) {
            throw new SecurityException();
        }
        this.encryptWithClientSecret = encryptWithClientSecret;
    }

    public void setSignWithClientSecret(boolean signWithClientSecret) {
        if (this.encryptWithClientSecret) {
            throw new SecurityException();
        }
        this.signWithClientSecret = signWithClientSecret;
    }

    public boolean isSignWithClientSecret() {
        return this.signWithClientSecret;
    }

    public boolean isEncryptWithClientSecret() {
        return this.encryptWithClientSecret;
    }
}

