/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.jwt;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.jwt.AbstractJwtHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class JwtBearerGrantHandler
extends AbstractJwtHandler {
    private static final String ENCODED_JWT_BEARER_GRANT = HttpUtils.urlEncode("urn:ietf:params:oauth:grant-type:jwt-bearer", StandardCharsets.UTF_8.name());

    public JwtBearerGrantHandler() {
        super(Arrays.asList("urn:ietf:params:oauth:grant-type:jwt-bearer", ENCODED_JWT_BEARER_GRANT));
    }

    @Override
    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        String assertion = (String)params.getFirst((Object)"assertion");
        if (assertion == null) {
            throw new OAuthServiceException("invalid_grant");
        }
        try {
            JwsJwtCompactConsumer jwsReader = this.getJwsReader(assertion);
            JwtToken jwtToken = jwsReader.getJwtToken();
            this.validateSignature(new JwsHeaders(jwtToken.getJwsHeaders()), jwsReader.getUnsignedEncodedSequence(), jwsReader.getDecodedSignature());
            this.validateClaims(client, jwtToken.getClaims());
            UserSubject grantSubject = new UserSubject(jwtToken.getClaims().getSubject());
            return this.doCreateAccessToken(client, grantSubject, "urn:ietf:params:oauth:grant-type:jwt-bearer", OAuthUtils.parseScope((String)params.getFirst((Object)"scope")));
        }
        catch (OAuthServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OAuthServiceException("invalid_grant", (Throwable)ex);
        }
    }

    protected JwsJwtCompactConsumer getJwsReader(String assertion) {
        return new JwsJwtCompactConsumer(assertion);
    }
}

