/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.jsrjsonb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.json.JsonException;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;

@Produces(value={"application/json", "text/json", "application/*+json"})
@Consumes(value={"application/json", "text/json", "application/*+json"})
@Provider
public class JsrJsonbProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private final Jsonb jsonb;
    @Context
    private Providers providers;

    public JsrJsonbProvider() {
        this(null);
    }

    public JsrJsonbProvider(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isSupportedMediaType(mediaType);
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.jsonbFor(type).toJson(t, type, entityStream);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isSupportedMediaType(mediaType);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            if (genericType == null) {
                return this.jsonbFor(type).fromJson(entityStream, type);
            }
            return this.jsonbFor(type).fromJson(entityStream, genericType);
        }
        catch (JsonException ex) {
            throw ExceptionUtils.toBadRequestException(ex, null);
        }
    }

    protected boolean isSupportedMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return "json".equalsIgnoreCase(subtype) || subtype.endsWith("+json");
        }
        return false;
    }

    private Jsonb jsonbFor(Class<?> type) {
        ContextResolver contextResolver;
        if (this.providers != null && (contextResolver = this.providers.getContextResolver(Jsonb.class, MediaType.APPLICATION_JSON_TYPE)) != null) {
            return (Jsonb)contextResolver.getContext(type);
        }
        if (this.jsonb != null) {
            return this.jsonb;
        }
        return DefaultJsonbSupplier.INSTANCE;
    }

    private static final class DefaultJsonbSupplier {
        private static final Jsonb INSTANCE = JsonbBuilder.create();

        private DefaultJsonbSupplier() {
        }
    }
}

