/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint.dynamic;

import org.apache.cxf.Bus;
import org.apache.cxf.common.spi.ClassGeneratorClassLoader;
import org.apache.cxf.common.util.ASMHelper;
import org.apache.cxf.common.util.OpcodesProxy;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.dynamic.ExceptionClassCreator;

public class ExceptionClassGenerator
extends ClassGeneratorClassLoader
implements ExceptionClassCreator {
    private final ASMHelper helper;

    public ExceptionClassGenerator(Bus bus) {
        super(bus);
        this.helper = bus.getExtension(ASMHelper.class);
    }

    @Override
    public Class<?> createExceptionClass(Class<?> bean) {
        String newClassName = bean.getName() + "_Exception";
        newClassName = newClassName.replaceAll("\\$", ".");
        Class<?> cls = this.findClass(StringUtils.slashesToPeriod(newClassName = StringUtils.periodToSlashes(newClassName)), bean);
        if (cls == null) {
            ASMHelper.ClassWriter cw = this.helper.createClassWriter();
            OpcodesProxy opCodes = this.helper.getOpCodes();
            cw.visit(opCodes.V1_5, opCodes.ACC_PUBLIC | opCodes.ACC_SUPER, newClassName, null, "java/lang/Exception", null);
            String beanClassCode = this.helper.getClassCode(bean);
            ASMHelper.FieldVisitor fv = cw.visitField(0, "faultInfo", beanClassCode, null, null);
            fv.visitEnd();
            ASMHelper.MethodVisitor mv = cw.visitMethod(opCodes.ACC_PUBLIC, "<init>", "(Ljava/lang/String;" + beanClassCode + ")V", null, null);
            mv.visitCode();
            mv.visitLabel(this.helper.createLabel());
            mv.visitVarInsn(opCodes.ALOAD, 0);
            mv.visitVarInsn(opCodes.ALOAD, 1);
            mv.visitMethodInsn(opCodes.INVOKESPECIAL, "java/lang/Exception", "<init>", "(Ljava/lang/String;)V", false);
            mv.visitLabel(this.helper.createLabel());
            mv.visitVarInsn(opCodes.ALOAD, 0);
            mv.visitVarInsn(opCodes.ALOAD, 2);
            mv.visitFieldInsn(opCodes.PUTFIELD, newClassName, "faultInfo", beanClassCode);
            mv.visitLabel(this.helper.createLabel());
            mv.visitInsn(opCodes.RETURN);
            mv.visitLabel(this.helper.createLabel());
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(opCodes.ACC_PUBLIC, "getFaultInfo", "()" + beanClassCode, null, null);
            mv.visitCode();
            mv.visitLabel(this.helper.createLabel());
            mv.visitVarInsn(opCodes.ALOAD, 0);
            mv.visitFieldInsn(opCodes.GETFIELD, newClassName, "faultInfo", beanClassCode);
            mv.visitInsn(opCodes.ARETURN);
            mv.visitLabel(this.helper.createLabel());
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            return this.loadClass(bean.getName() + "_Exception", bean, cw.toByteArray());
        }
        return cls;
    }
}

