/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.apache.safeguard.impl.config.Enabled;
import org.apache.safeguard.impl.config.GeronimoFaultToleranceConfig;
import org.eclipse.microprofile.faulttolerance.Fallback;

@ApplicationScoped
public class ConfigurationMapper {
    @Inject
    private GeronimoFaultToleranceConfig config;
    @Inject
    private BeanManager beanManager;

    public <T extends Annotation> T map(T instance, Method sourceMethod, Class<T> api) {
        return (T)((Annotation)api.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{api, Enabled.class}, (proxy, method, args) -> {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)instance, args);
            }
            return this.findConfiguredValue(instance, api, sourceMethod, method, args);
        })));
    }

    public <T extends Annotation> boolean isEnabled(Method method, Class<T> api) {
        boolean methodLevel = this.isDefinedAtMethodLevel(method, api);
        Supplier<Boolean> globalEvaluator = () -> Optional.ofNullable(this.findClassConfiguration(api, method, "enabled")).map(Boolean::parseBoolean).orElseGet(() -> Optional.ofNullable(this.config.read(String.format("%s/%s", api.getSimpleName(), "enabled"))).map(Boolean::parseBoolean).orElseGet(() -> Fallback.class == api ? Boolean.valueOf(true) : Optional.ofNullable(this.config.read("MP_Fault_Tolerance_NonFallback_Enabled")).map(Boolean::parseBoolean).orElse(true)));
        if (methodLevel) {
            return Optional.ofNullable(this.findMethodConfiguration(api, method, "enabled")).map(Boolean::parseBoolean).orElseGet(globalEvaluator);
        }
        return globalEvaluator.get();
    }

    private <T extends Annotation> Object findConfiguredValue(T instance, Class<T> api, Method sourceMethod, Method proxyMethod, Object[] args) {
        boolean methodLevel = this.isDefinedAtMethodLevel(sourceMethod, api);
        if (methodLevel) {
            return Optional.ofNullable(this.findMethodConfiguration(api, sourceMethod, proxyMethod.getName())).map(v -> this.coerce((String)v, proxyMethod.getReturnType())).orElseGet(() -> Optional.ofNullable(this.findDefaultConfiguration(proxyMethod, proxyMethod.getName())).map(v -> this.coerce((String)v, proxyMethod.getReturnType())).orElseGet(() -> this.getReflectionConfig(instance, proxyMethod, args)));
        }
        return Optional.ofNullable(this.findDefaultConfiguration(proxyMethod, proxyMethod.getName())).map(v -> this.coerce((String)v, proxyMethod.getReturnType())).orElseGet(() -> Optional.ofNullable(this.findClassConfiguration(api, sourceMethod, proxyMethod.getName())).map(v -> this.coerce((String)v, proxyMethod.getReturnType())).orElseGet(() -> this.getReflectionConfig(instance, proxyMethod, args)));
    }

    private <T extends Annotation> boolean isDefinedAtMethodLevel(Method method, Class<T> api) {
        AnnotatedType selected = this.beanManager.createAnnotatedType(method.getDeclaringClass());
        return selected.getMethods().stream().filter(it -> it.getJavaMember().getName().equals(method.getName()) && Arrays.equals(it.getJavaMember().getParameterTypes(), method.getParameterTypes())).filter(it -> selected.getJavaClass().equals(it.getJavaMember().getDeclaringClass())).anyMatch(it -> it.isAnnotationPresent(api));
    }

    private <T extends Annotation> Object getReflectionConfig(T instance, Method proxyMethod, Object[] args) {
        try {
            return proxyMethod.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
    }

    private String findDefaultConfiguration(Method api, String methodName) {
        return this.config.read(String.format("%s/%s", api.getDeclaringClass().getSimpleName(), methodName));
    }

    private <T extends Annotation> String findClassConfiguration(Class<T> api, Method beanMethod, String apiMethod) {
        return this.config.read(String.format("%s/%s/%s", beanMethod.getDeclaringClass().getName(), api.getSimpleName(), apiMethod));
    }

    private <T extends Annotation> String findMethodConfiguration(Class<T> api, Method beanMethod, String apiMethod) {
        return this.config.read(String.format("%s/%s/%s/%s", beanMethod.getDeclaringClass().getName(), beanMethod.getName(), api.getSimpleName(), apiMethod));
    }

    private Object coerce(String raw, Class<?> expected) {
        if (expected == Long.TYPE || expected == Long.class) {
            return Long.valueOf(raw);
        }
        if (expected == Double.TYPE || expected == Double.class) {
            return Double.valueOf(raw);
        }
        if (expected == Integer.TYPE || expected == Integer.class) {
            return Integer.valueOf(raw);
        }
        if (expected == Boolean.TYPE || expected == Boolean.class) {
            return Boolean.valueOf(raw);
        }
        if (expected == ChronoUnit.class) {
            return ChronoUnit.valueOf(raw);
        }
        if (expected == String.class) {
            return raw;
        }
        if (expected == Class[].class) {
            return Stream.of(raw.split(",")).map(String::trim).filter(it -> !it.isEmpty()).map(it -> {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass((String)it);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }).toArray();
        }
        throw new IllegalArgumentException("Unsupported: " + expected);
    }
}

