/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.apache.safeguard.impl.cache.UnwrappedCache;

@ApplicationScoped
public class AnnotationFinder {
    @Inject
    private BeanManager manager;
    @Inject
    private UnwrappedCache unwrappedCache;

    public <T extends Annotation> T findAnnotation(Class<T> type, AnnotatedType<?> declaringClass, Method method) {
        T annotation;
        Set methods = declaringClass.getMethods();
        Optional<AnnotatedMethod<?>> classMethod = this.getDirectMethod(declaringClass, method, methods);
        if (classMethod.isPresent()) {
            T methodAnnotation = this.getMethodAnnotation(type, classMethod);
            if (methodAnnotation != null) {
                return methodAnnotation;
            }
        } else {
            Optional<AnnotatedMethod<?>> parentMethod = this.getParentMethod(declaringClass, method, methods);
            T annotation2 = this.getMethodAnnotation(type, parentMethod);
            if (annotation2 != null) {
                return annotation2;
            }
        }
        if ((annotation = this.getFromDirectClass(type, declaringClass)) != null) {
            return annotation;
        }
        annotation = this.getFromParentClass(type, declaringClass);
        if (annotation != null) {
            return annotation;
        }
        return this.getByReflection(type, declaringClass, method);
    }

    private <T extends Annotation> T getFromDirectClass(Class<T> type, AnnotatedType<?> declaringClass) {
        Annotation annotation = declaringClass.getAnnotation(type);
        if (annotation != null) {
            return (T)annotation;
        }
        return null;
    }

    private Optional<AnnotatedMethod<?>> getParentMethod(AnnotatedType<?> declaringClass, Method method, Set<AnnotatedMethod<?>> methods) {
        return methods.stream().filter(it -> !declaringClass.getJavaClass().equals(it.getJavaMember().getDeclaringClass()) && this.matches(method, (AnnotatedMethod<?>)it)).findFirst();
    }

    private <T extends Annotation> T getMethodAnnotation(Class<T> type, Optional<AnnotatedMethod<?>> classMethod) {
        Annotation annotation;
        if (classMethod.isPresent() && (annotation = classMethod.orElseThrow(IllegalArgumentException::new).getAnnotation(type)) != null) {
            return (T)annotation;
        }
        return null;
    }

    private Optional<AnnotatedMethod<?>> getDirectMethod(AnnotatedType<?> declaringClass, Method method, Set<AnnotatedMethod<?>> methods) {
        return methods.stream().filter(it -> declaringClass.getJavaClass().equals(it.getJavaMember().getDeclaringClass()) && this.matches(method, (AnnotatedMethod<?>)it)).findFirst();
    }

    private <T extends Annotation> T getFromParentClass(Class<T> type, AnnotatedType<?> declaringClass) {
        AnnotatedType annotatedType;
        Annotation annotation;
        Class parent = declaringClass.getJavaClass().getSuperclass();
        if (parent != null && parent != Object.class && (annotation = (annotatedType = this.manager.createAnnotatedType(parent)).getAnnotation(type)) != null) {
            return (T)annotation;
        }
        return null;
    }

    private boolean matches(Method method, AnnotatedMethod<?> it) {
        return it.getJavaMember().getName().equals(method.getName()) && Arrays.equals(it.getJavaMember().getParameterTypes(), method.getParameterTypes());
    }

    private <T extends Annotation> T getByReflection(Class<T> type, AnnotatedType<?> declaringClass, Method method) {
        return (T)Optional.ofNullable(method.getAnnotation(type)).orElseGet(() -> declaringClass.getAnnotation(type));
    }

    public <T extends Annotation> T findAnnotation(Class<T> type, InvocationContext context) {
        Class target = Optional.ofNullable(context.getTarget()).flatMap(it -> UnwrappedCache.Tool.unwrap(this.unwrappedCache.getUnwrappedCache(), it)).orElseGet(() -> (Class)Class.class.cast(context.getMethod().getDeclaringClass()));
        return this.findAnnotation(type, this.manager.createAnnotatedType(target), context.getMethod());
    }
}

