/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.microprofile.server;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.util.Optional;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import org.apache.geronimo.microprofile.opentracing.impl.JaxRsHeaderTextMap;
import org.apache.geronimo.microprofile.opentracing.microprofile.client.OpenTracingClientRequestFilter;
import org.apache.geronimo.microprofile.opentracing.microprofile.server.OpenTracingFilter;

public class OpenTracingServerRequestFilter
implements ContainerRequestFilter {
    private final String operationName;
    private final Tracer tracer;
    private final boolean skip;
    private final boolean skipDefaultTags;

    public OpenTracingServerRequestFilter(String operationName, Tracer tracer, boolean skip, boolean skipDefaultTags) {
        this.operationName = operationName;
        this.tracer = tracer;
        this.skip = skip;
        this.skipDefaultTags = skipDefaultTags;
    }

    public void filter(ContainerRequestContext context) {
        if (context.getProperty(OpenTracingClientRequestFilter.class.getName()) != null || this.skip) {
            return;
        }
        Tracer.SpanBuilder builder = this.tracer.buildSpan(this.operationName);
        builder.withTag(Tags.SPAN_KIND.getKey(), "server");
        builder.withTag("component", "jaxrs");
        Optional.ofNullable(Optional.ofNullable(this.tracer.activeSpan()).map(Span::context).orElseGet(() -> this.tracer.extract(Format.Builtin.HTTP_HEADERS, new JaxRsHeaderTextMap(context.getHeaders())))).ifPresent(arg_0 -> ((Tracer.SpanBuilder)builder).asChildOf(arg_0));
        Scope scope = builder.startActive(true);
        Span span = scope.span();
        if (!this.skipDefaultTags) {
            Tags.HTTP_METHOD.set(span, context.getMethod());
            Tags.HTTP_URL.set(span, context.getUriInfo().getRequestUri().toASCIIString());
        }
        context.setProperty(OpenTracingFilter.class.getName(), (Object)scope);
    }
}

