/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jmx;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.batch.operations.JobOperator;
import javax.batch.operations.NoSuchJobException;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.batchee.container.impl.JobInstanceImpl;
import org.apache.batchee.jmx.BatchEEMBean;

public class BatchEEMBeanImpl
implements BatchEEMBean {
    public static final BatchEEMBeanImpl INSTANCE = new BatchEEMBeanImpl();
    private static final String[] JOB_INSTANCES_ATTRIBUTES = new String[]{"jobName", "instanceId"};
    private static final TabularType JOB_INSTANCES_TABULAR_TYPE;
    private static final CompositeType JOB_INSTANCES_COMPOSITE_TYPE;
    private static final String[] PROPERTIES_ATTRIBUTES;
    private static final TabularType PROPERTIES_TABULAR_TYPE;
    private static final CompositeType PROPERTIES_COMPOSITE_TYPE;
    private static final String[] JOB_EXECUTION_ATTRIBUTES;
    private static final TabularType JOB_EXECUTION_TABULAR_TYPE;
    private static final CompositeType JOB_EXECUTION_COMPOSITE_TYPE;
    private static final String[] STEP_EXECUTION_ATTRIBUTES;
    private static final TabularType STEP_EXECUTION_TABULAR_TYPE;
    private static final CompositeType STEP_EXECUTION_COMPOSITE_TYPE;

    private static Properties toProperties(String params) {
        Properties properties = new Properties();
        if (params != null && !params.isEmpty()) {
            for (String kv : params.split("|")) {
                String[] split = kv.split("=");
                if (split.length == 1) continue;
                properties.setProperty(split[0], split[1]);
            }
        }
        return properties;
    }

    private static Object[] asArray(JobExecution n) {
        return new Object[]{n.getExecutionId(), n.getJobName(), n.getBatchStatus().name(), n.getExitStatus(), n.getCreateTime().toString(), n.getLastUpdatedTime().toString(), n.getStartTime() != null ? n.getStartTime().toString() : "", n.getEndTime() != null ? n.getEndTime().toString() : ""};
    }

    private static Object[] asArray(StepExecution n) {
        return new Object[]{n.getStepExecutionId(), n.getStepName(), n.getBatchStatus().name(), n.getExitStatus(), n.getStartTime() != null ? n.getStartTime().toString() : "", n.getEndTime() != null ? n.getEndTime().toString() : "", BatchEEMBeanImpl.metric(n.getMetrics(), Metric.MetricType.READ_COUNT), BatchEEMBeanImpl.metric(n.getMetrics(), Metric.MetricType.WRITE_COUNT), BatchEEMBeanImpl.metric(n.getMetrics(), Metric.MetricType.COMMIT_COUNT), BatchEEMBeanImpl.metric(n.getMetrics(), Metric.MetricType.ROLLBACK_COUNT), BatchEEMBeanImpl.metric(n.getMetrics(), Metric.MetricType.READ_SKIP_COUNT), BatchEEMBeanImpl.metric(n.getMetrics(), Metric.MetricType.PROCESS_SKIP_COUNT), BatchEEMBeanImpl.metric(n.getMetrics(), Metric.MetricType.WRITE_SKIP_COUNT), BatchEEMBeanImpl.metric(n.getMetrics(), Metric.MetricType.FILTER_COUNT)};
    }

    private static long metric(Metric[] metrics, Metric.MetricType type) {
        for (Metric m : metrics) {
            if (!type.equals((Object)m.getType())) continue;
            return m.getValue();
        }
        return -1L;
    }

    private JobOperator operator() {
        return BatchRuntime.getJobOperator();
    }

    @Override
    public String[] getJobNames() {
        Set jobNames = this.operator().getJobNames();
        return jobNames.toArray(new String[jobNames.size()]);
    }

    @Override
    public int getJobInstanceCount(String jobName) {
        return this.operator().getJobInstanceCount(jobName);
    }

    @Override
    public TabularData getJobInstances(String jobName, int start, int count) {
        List instances = this.operator().getJobInstances(jobName, start, count);
        try {
            TabularDataSupport data = new TabularDataSupport(JOB_INSTANCES_TABULAR_TYPE);
            for (JobInstance n : instances) {
                data.put(new CompositeDataSupport(JOB_INSTANCES_COMPOSITE_TYPE, JOB_INSTANCES_ATTRIBUTES, new Object[]{n.getJobName(), n.getInstanceId()}));
            }
            return data;
        }
        catch (OpenDataException e) {
            return null;
        }
    }

    @Override
    public Long[] getRunningExecutions(String jobName) {
        try {
            List runningExecutions = this.operator().getRunningExecutions(jobName);
            return runningExecutions.toArray(new Long[runningExecutions.size()]);
        }
        catch (NoSuchJobException nsje) {
            return new Long[0];
        }
    }

    @Override
    public TabularData getParameters(long executionId) {
        Properties parameters = this.operator().getParameters(executionId);
        try {
            TabularDataSupport data = new TabularDataSupport(PROPERTIES_TABULAR_TYPE);
            for (Map.Entry<Object, Object> entry : parameters.entrySet()) {
                data.put(new CompositeDataSupport(PROPERTIES_COMPOSITE_TYPE, PROPERTIES_ATTRIBUTES, new Object[]{entry.getKey(), entry.getValue()}));
            }
            return data;
        }
        catch (OpenDataException e) {
            return null;
        }
    }

    @Override
    public TabularData getJobInstance(long executionId) {
        JobInstance instance = this.operator().getJobInstance(executionId);
        try {
            TabularDataSupport data = new TabularDataSupport(JOB_INSTANCES_TABULAR_TYPE);
            data.put(new CompositeDataSupport(JOB_INSTANCES_COMPOSITE_TYPE, JOB_INSTANCES_ATTRIBUTES, new Object[]{instance.getJobName(), instance.getInstanceId()}));
            return data;
        }
        catch (OpenDataException e) {
            return null;
        }
    }

    @Override
    public void stop(long executionId) {
        this.operator().stop(executionId);
    }

    @Override
    public void abandon(long executionId) {
        this.operator().abandon(executionId);
    }

    @Override
    public long start(String jobXMLName, String jobParameters) {
        return this.operator().start(jobXMLName, BatchEEMBeanImpl.toProperties(jobParameters));
    }

    @Override
    public long restart(long executionId, String restartParameters) {
        return this.operator().restart(executionId, BatchEEMBeanImpl.toProperties(restartParameters));
    }

    @Override
    public TabularData getJobExecutions(long id, String name) {
        List executions = this.operator().getJobExecutions((JobInstance)new JobInstanceImpl(id, name));
        try {
            TabularDataSupport data = new TabularDataSupport(JOB_EXECUTION_TABULAR_TYPE);
            for (JobExecution n : executions) {
                data.put(new CompositeDataSupport(JOB_EXECUTION_COMPOSITE_TYPE, JOB_EXECUTION_ATTRIBUTES, BatchEEMBeanImpl.asArray(n)));
            }
            return data;
        }
        catch (OpenDataException e) {
            return null;
        }
    }

    @Override
    public TabularData getJobExecution(long executionId) {
        JobExecution execution = this.operator().getJobExecution(executionId);
        try {
            TabularDataSupport data = new TabularDataSupport(JOB_EXECUTION_TABULAR_TYPE);
            data.put(new CompositeDataSupport(JOB_EXECUTION_COMPOSITE_TYPE, JOB_EXECUTION_ATTRIBUTES, BatchEEMBeanImpl.asArray(execution)));
            return data;
        }
        catch (OpenDataException e) {
            return null;
        }
    }

    @Override
    public TabularData getStepExecutions(long jobExecutionId) {
        List executions = this.operator().getStepExecutions(jobExecutionId);
        try {
            TabularDataSupport data = new TabularDataSupport(STEP_EXECUTION_TABULAR_TYPE);
            for (StepExecution n : executions) {
                data.put(new CompositeDataSupport(STEP_EXECUTION_COMPOSITE_TYPE, STEP_EXECUTION_ATTRIBUTES, BatchEEMBeanImpl.asArray(n)));
            }
            return data;
        }
        catch (OpenDataException e) {
            return null;
        }
    }

    static {
        PROPERTIES_ATTRIBUTES = new String[]{"key", "value"};
        JOB_EXECUTION_ATTRIBUTES = new String[]{"executionId", "jobName", "Batch status", "Exit status", "Create time", "Last updated time", "Start time", "End time"};
        STEP_EXECUTION_ATTRIBUTES = new String[]{"stepExecutionId", "stepName", "Batch status", "Exit status", "Start time", "End time", "Read", "Write", "Commit", "Rollback", "Read skip", "Process skip", "Write skip", "Filter"};
        try {
            JOB_INSTANCES_COMPOSITE_TYPE = new CompositeType("JobInstance", "Job Instance", JOB_INSTANCES_ATTRIBUTES, JOB_INSTANCES_ATTRIBUTES, new OpenType[]{SimpleType.STRING, SimpleType.LONG});
            JOB_INSTANCES_TABULAR_TYPE = new TabularType("JobInstances", "Job Instances", JOB_INSTANCES_COMPOSITE_TYPE, JOB_INSTANCES_ATTRIBUTES);
            PROPERTIES_COMPOSITE_TYPE = new CompositeType("Properties", "Properties", PROPERTIES_ATTRIBUTES, PROPERTIES_ATTRIBUTES, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
            PROPERTIES_TABULAR_TYPE = new TabularType("Properties", "Properties", PROPERTIES_COMPOSITE_TYPE, PROPERTIES_ATTRIBUTES);
            JOB_EXECUTION_COMPOSITE_TYPE = new CompositeType("JobExecution", "Job Execution", JOB_EXECUTION_ATTRIBUTES, JOB_EXECUTION_ATTRIBUTES, new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
            JOB_EXECUTION_TABULAR_TYPE = new TabularType("JobExecutions", "Job Executions", JOB_EXECUTION_COMPOSITE_TYPE, JOB_EXECUTION_ATTRIBUTES);
            STEP_EXECUTION_COMPOSITE_TYPE = new CompositeType("StepExecution", "Step Execution", STEP_EXECUTION_ATTRIBUTES, STEP_EXECUTION_ATTRIBUTES, new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG});
            STEP_EXECUTION_TABULAR_TYPE = new TabularType("StepExecutions", "Step Executions", STEP_EXECUTION_COMPOSITE_TYPE, STEP_EXECUTION_ATTRIBUTES);
        }
        catch (OpenDataException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

