/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.chunking;

import java.io.IOException;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.IntermediateNodeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.LeafNodeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ZipHeader;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.chunking.AbstractChunking;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.chunking.ChunkingMethod;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.chunking.RDCAnalysisChunking;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.chunking.SimpleChunking;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.chunking.ZipFilesChunking;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.ByteUtil;

public class ChunkingFactory {
    private ChunkingFactory() {
    }

    public static AbstractChunking createChunkingInstance(byte[] fileContent) {
        if (ZipHeader.isFileHeader(fileContent, 0)) {
            return new ZipFilesChunking(fileContent);
        }
        return new RDCAnalysisChunking(fileContent);
    }

    public static AbstractChunking createChunkingInstance(IntermediateNodeObject nodeObject) throws TikaException, IOException {
        byte[] fileContent = ByteUtil.toByteArray(nodeObject.getContent());
        if (ZipHeader.isFileHeader(fileContent, 0)) {
            return new ZipFilesChunking(fileContent);
        }
        SimpleChunking returnChunking = new SimpleChunking(fileContent);
        List<LeafNodeObject> nodes = ((AbstractChunking)returnChunking).chunking();
        if (nodeObject.intermediateNodeObjectList.size() == nodes.size()) {
            boolean isDataSizeMatching = true;
            for (int i = 0; i < nodes.size(); ++i) {
                if (((LeafNodeObject)nodeObject.intermediateNodeObjectList.get((int)i)).dataSize.dataSize == nodes.get((int)i).dataSize.dataSize) continue;
                isDataSizeMatching = false;
                break;
            }
            if (isDataSizeMatching) {
                return returnChunking;
            }
        }
        return new RDCAnalysisChunking(fileContent);
    }

    public static AbstractChunking createChunkingInstance(byte[] fileContent, ChunkingMethod chunkingMethod) {
        AbstractChunking chunking;
        switch (chunkingMethod) {
            case RDCAnalysis: {
                chunking = new RDCAnalysisChunking(fileContent);
                break;
            }
            case SimpleAlgorithm: {
                chunking = new SimpleChunking(fileContent);
                break;
            }
            case ZipAlgorithm: {
                chunking = new ZipFilesChunking(fileContent);
                break;
            }
            default: {
                throw new InvalidOperationException("Cannot support the chunking type" + String.valueOf((Object)chunkingMethod));
            }
        }
        return chunking;
    }
}

