/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.template;

import java.io.IOException;
import java.io.Writer;
import java.util.Deque;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tiles.api.Attribute;
import org.apache.tiles.api.TilesContainer;
import org.apache.tiles.api.access.TilesAccess;
import org.apache.tiles.autotag.core.runtime.ModelBody;
import org.apache.tiles.request.Request;
import org.apache.tiles.template.AttributeResolver;
import org.apache.tiles.template.ComposeStackUtil;
import org.apache.tiles.template.DefaultAttributeResolver;

public class GetAsStringModel {
    private static final Logger LOG = LogManager.getLogger(GetAsStringModel.class);
    private final AttributeResolver attributeResolver;

    public GetAsStringModel() {
        this(new DefaultAttributeResolver());
    }

    public GetAsStringModel(AttributeResolver attributeResolver) {
        this.attributeResolver = attributeResolver;
    }

    public void execute(boolean ignore, String preparer, String role, Object defaultValue, String defaultValueRole, String defaultValueType, String name, Attribute value, Request request, ModelBody modelBody) throws IOException {
        TilesContainer container = TilesAccess.getCurrentContainer(request);
        Deque<Object> composeStack = ComposeStackUtil.getComposeStack(request);
        Attribute attribute = this.resolveAttribute(container, ignore, preparer, role, defaultValue, defaultValueRole, defaultValueType, name, value, request);
        if (attribute != null) {
            composeStack.push(attribute);
        }
        modelBody.evaluateWithoutWriting();
        container = TilesAccess.getCurrentContainer(request);
        Writer writer = request.getWriter();
        if (attribute != null) {
            attribute = (Attribute)composeStack.pop();
        }
        this.renderAttribute(attribute, container, writer, ignore, request);
    }

    private Attribute resolveAttribute(TilesContainer container, boolean ignore, String preparer, String role, Object defaultValue, String defaultValueRole, String defaultValueType, String name, Attribute value, Request request) {
        if (preparer != null) {
            container.prepare(preparer, request);
        }
        Attribute attribute = this.attributeResolver.computeAttribute(container, value, name, role, ignore, defaultValue, defaultValueRole, defaultValueType, request);
        container.startContext(request);
        return attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderAttribute(Attribute attribute, TilesContainer container, Writer writer, boolean ignore, Request request) throws IOException {
        try {
            if (attribute == null && ignore) {
                return;
            }
            Object value = container.evaluate(attribute, request);
            if (value != null) {
                writer.write(value.toString());
            }
        }
        catch (IOException | RuntimeException e) {
            if (!ignore) {
                throw e;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring exception", (Throwable)e);
            }
        }
        finally {
            container.endContext(request);
        }
    }
}

