/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.locale;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tiles.request.ApplicationResource;

public abstract class PostfixedApplicationResource
implements ApplicationResource {
    private static final Logger LOG = LogManager.getLogger(PostfixedApplicationResource.class);
    private String pathPrefix;
    private final String suffix;
    private final Locale locale;
    private static final Set<Locale> availableLocales = new HashSet<Locale>(Arrays.asList(Locale.getAvailableLocales()));

    protected PostfixedApplicationResource(String localePath) {
        int prefixIndex = localePath.indexOf(95, localePath.lastIndexOf("/"));
        int suffixIndex = localePath.lastIndexOf(46);
        if (suffixIndex < 0) {
            this.suffix = "";
            suffixIndex = localePath.length();
        } else {
            this.suffix = localePath.substring(suffixIndex);
        }
        if (prefixIndex < 0) {
            this.pathPrefix = localePath.substring(0, suffixIndex);
            this.locale = Locale.ROOT;
        } else {
            this.pathPrefix = localePath.substring(0, prefixIndex);
            String localeString = localePath.substring(prefixIndex + 1, suffixIndex);
            Locale found = PostfixedApplicationResource.localeFrom(localeString);
            this.locale = PostfixedApplicationResource.validateLocale(found);
            if (Locale.ROOT.equals(this.locale)) {
                this.pathPrefix = localePath.substring(0, suffixIndex);
                LOG.warn("No supported matching language for locale \"" + localeString + "\". Using " + this.getPath() + " as a non-localized resource path. see TILES-571");
            } else if (!localeString.equalsIgnoreCase(PostfixedApplicationResource.getPostfix(this.locale).substring(1))) {
                LOG.warn("For resource " + localePath + " the closest supported matching locale to \"" + localeString + "\" is \"" + this.locale + "\". Using " + this.getPath() + " as resource path. see TILES-571");
            }
        }
    }

    protected PostfixedApplicationResource(String path, Locale locale) {
        int suffixIndex = path.lastIndexOf(46);
        if (suffixIndex < 0) {
            this.suffix = "";
            this.pathPrefix = path;
        } else {
            this.pathPrefix = path.substring(0, suffixIndex);
            this.suffix = path.substring(suffixIndex);
        }
        this.locale = locale;
    }

    @Override
    public final String getLocalePath() {
        return this.getLocalePath(this.locale);
    }

    @Override
    public final String getPath() {
        return this.pathPrefix + this.suffix;
    }

    @Override
    public final String getLocalePath(Locale newLocale) {
        return this.pathPrefix + PostfixedApplicationResource.getPostfix(newLocale) + this.suffix;
    }

    private static String getPostfix(Locale locale) {
        if (locale == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (!"".equals(language)) {
            builder.append("_");
            builder.append(language);
            if (!"".equals(country)) {
                builder.append("_");
                builder.append(country);
                if (!"".equals(variant)) {
                    builder.append("_");
                    builder.append(variant);
                }
            }
        }
        return builder.toString();
    }

    @Override
    public final Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.pathPrefix == null ? 0 : this.pathPrefix.hashCode());
        result = 31 * result + (this.suffix == null ? 0 : this.suffix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PostfixedApplicationResource other = (PostfixedApplicationResource)obj;
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.pathPrefix == null ? other.pathPrefix != null : !this.pathPrefix.equals(other.pathPrefix)) {
            return false;
        }
        if (this.suffix == null) {
            return other.suffix == null;
        }
        return this.suffix.equals(other.suffix);
    }

    private static Locale localeFrom(String localeString) {
        int variantIndex;
        int countryIndex = localeString.indexOf(95);
        Locale result = countryIndex < 0 ? new Locale(localeString) : ((variantIndex = localeString.indexOf(95, countryIndex + 1)) < 0 ? new Locale(localeString.substring(0, countryIndex), localeString.substring(countryIndex + 1)) : new Locale(localeString.substring(0, countryIndex), localeString.substring(countryIndex + 1, variantIndex), localeString.substring(variantIndex + 1)));
        return result;
    }

    private static Locale validateLocale(Locale locale) {
        Locale withoutVariant = locale.getVariant().isEmpty() ? locale : new Locale(locale.getLanguage(), locale.getCountry());
        Locale result = locale;
        if (!availableLocales.contains(withoutVariant)) {
            if (!result.getCountry().isEmpty()) {
                result = new Locale(result.getLanguage());
            }
            if (!availableLocales.contains(result)) {
                result = Locale.ROOT;
            }
        }
        return result;
    }
}

