/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.core.definition.digester;

import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.apache.tiles.api.Attribute;
import org.apache.tiles.api.Definition;
import org.apache.tiles.api.Expression;
import org.xml.sax.Attributes;

class FillDefinitionRule
extends Rule {
    private final Digester digester;

    public FillDefinitionRule(Digester digester) {
        this.digester = digester;
    }

    public void begin(String namespace, String name, Attributes attributes) {
        Definition definition = (Definition)this.digester.peek();
        definition.setName(attributes.getValue("name"));
        definition.setPreparer(attributes.getValue("preparer"));
        String extendsAttribute = attributes.getValue("extends");
        definition.setExtends(extendsAttribute);
        String template = attributes.getValue("template");
        Attribute attribute = Attribute.createTemplateAttribute(template);
        attribute.setExpressionObject(Expression.createExpressionFromDescribedExpression(attributes.getValue("templateExpression")));
        attribute.setRole(attributes.getValue("role"));
        String templateType = attributes.getValue("templateType");
        if (templateType != null) {
            attribute.setRenderer(templateType);
        } else if (extendsAttribute != null) {
            attribute.setRenderer(null);
        }
        definition.setTemplateAttribute(attribute);
    }
}

