/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.memory;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.apache.spark.unsafe.memory.MemoryBlock;

public class HeapMemoryAllocator
implements MemoryAllocator {
    @GuardedBy(value="this")
    private final Map<Long, LinkedList<WeakReference<MemoryBlock>>> bufferPoolsBySize = new HashMap<Long, LinkedList<WeakReference<MemoryBlock>>>();
    private static final int POOLING_THRESHOLD_BYTES = 0x100000;

    private boolean shouldPool(long size) {
        return size >= 0x100000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryBlock allocate(long size) throws OutOfMemoryError {
        if (this.shouldPool(size)) {
            HeapMemoryAllocator heapMemoryAllocator = this;
            synchronized (heapMemoryAllocator) {
                LinkedList<WeakReference<MemoryBlock>> pool = this.bufferPoolsBySize.get(size);
                if (pool != null) {
                    while (!pool.isEmpty()) {
                        WeakReference<MemoryBlock> blockReference = pool.pop();
                        MemoryBlock memory = (MemoryBlock)blockReference.get();
                        if (memory == null) continue;
                        assert (memory.size() == size);
                        return memory;
                    }
                    this.bufferPoolsBySize.remove(size);
                }
            }
        }
        long[] array = new long[(int)((size + 7L) / 8L)];
        return new MemoryBlock(array, Platform.LONG_ARRAY_OFFSET, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(MemoryBlock memory) {
        long size = memory.size();
        if (this.shouldPool(size)) {
            HeapMemoryAllocator heapMemoryAllocator = this;
            synchronized (heapMemoryAllocator) {
                LinkedList<WeakReference<MemoryBlock>> pool = this.bufferPoolsBySize.get(size);
                if (pool == null) {
                    pool = new LinkedList();
                    this.bufferPoolsBySize.put(size, pool);
                }
                pool.add(new WeakReference<MemoryBlock>(memory));
            }
        }
    }
}

