/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.apache.spark.sql.execution.datasources.v2.jdbc.JDBCTableCatalog;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.jdbc.JDBCV2Suite$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0004\b\u00013!)A\u0005\u0001C\u0001K!9\u0001\u0006\u0001b\u0001\n\u0003I\u0003B\u0002\u001a\u0001A\u0003%!\u0006C\u00044\u0001\t\u0007I\u0011\u0001\u001b\t\r\t\u0003\u0001\u0015!\u00036\u0011\u001d\u0019\u0005\u00011A\u0005\u0002\u0011CqA\u0013\u0001A\u0002\u0013\u00051\n\u0003\u0004S\u0001\u0001\u0006K!\u0012\u0005\u0006'\u0002!\t\u0005\u0016\u0005\u00063\u0002!IA\u0017\u0005\u0006Y\u0002!\t%\u001c\u0005\u0006]\u0002!\t%\u001c\u0002\f\u0015\u0012\u00135I\u0016\u001aTk&$XM\u0003\u0002\u0010!\u0005!!\u000e\u001a2d\u0015\t\t\"#A\u0002tc2T!a\u0005\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005U1\u0012AB1qC\u000eDWMC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\r\u0001!D\b\t\u00037qi\u0011\u0001E\u0005\u0003;A\u0011\u0011\"U;fef$Vm\u001d;\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005\u0002\u0012\u0001\u0002;fgRL!a\t\u0011\u0003%MC\u0017M]3e'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0002\"a\n\u0001\u000e\u00039\tq\u0001^3na\u0012K'/F\u0001+!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0002j_*\tq&\u0001\u0003kCZ\f\u0017BA\u0019-\u0005\u00111\u0015\u000e\\3\u0002\u0011Q,W\u000e\u001d#je\u0002\n1!\u001e:m+\u0005)\u0004C\u0001\u001c@\u001d\t9T\b\u0005\u00029w5\t\u0011H\u0003\u0002;1\u00051AH]8pizR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\na\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011ahO\u0001\u0005kJd\u0007%\u0001\u0003d_:tW#A#\u0011\u0005\u0019CU\"A$\u000b\u0005Eq\u0013BA%H\u0005)\u0019uN\u001c8fGRLwN\\\u0001\tG>tgn\u0018\u0013fcR\u0011A\n\u0015\t\u0003\u001b:k\u0011aO\u0005\u0003\u001fn\u0012A!\u00168ji\"9\u0011kBA\u0001\u0002\u0004)\u0015a\u0001=%c\u0005)1m\u001c8oA\u0005I1\u000f]1sW\u000e{gNZ\u000b\u0002+B\u0011akV\u0007\u0002%%\u0011\u0001L\u0005\u0002\n'B\f'o[\"p]\u001a\fab^5uQ\u000e{gN\\3di&|g.\u0006\u0002\\=R\u0011Al\u001a\t\u0003;zc\u0001\u0001B\u0003`\u0015\t\u0007\u0001MA\u0001U#\t\tG\r\u0005\u0002NE&\u00111m\u000f\u0002\b\u001d>$\b.\u001b8h!\tiU-\u0003\u0002gw\t\u0019\u0011I\\=\t\u000b!T\u0001\u0019A5\u0002\u0003\u0019\u0004B!\u00146F9&\u00111n\u000f\u0002\n\rVt7\r^5p]F\n\u0011BY3g_J,\u0017\t\u001c7\u0015\u00031\u000b\u0001\"\u00194uKJ\fE\u000e\u001c")
public class JDBCV2Suite
extends QueryTest
implements SharedSparkSession {
    private final File tempDir;
    private final String url;
    private Connection conn;
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$(this, f);
    }

    @Override
    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$(this, testName, f);
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$(this, testName, testTags, testFun, pos);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$(this, numPaths, f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        SQLHelper.withSQLConf$((SQLHelper)this, (Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions2, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$(this, cacheNames, f);
    }

    @Override
    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$(this, tableName);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$(this, namespaces, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    @Override
    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$(this, file);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.calendarIntervalData;
    }

    @Override
    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.calendarIntervalData$lzycompute() : this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x8000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public String url() {
        return this.url;
    }

    public Connection conn() {
        return this.conn;
    }

    public void conn_$eq(Connection x$1) {
        this.conn = x$1;
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this).set("spark.sql.catalog.h2", JDBCTableCatalog.class.getName()).set("spark.sql.catalog.h2.url", this.url()).set("spark.sql.catalog.h2.driver", "org.h2.Driver");
    }

    private <T> T withConnection(Function1<Connection, T> f) {
        Object object;
        try (Connection conn = DriverManager.getConnection(this.url(), new Properties());){
            object = f.apply((Object)conn);
        }
        return (T)object;
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
        Utils$.MODULE$.classForName("org.h2.Driver", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        this.withConnection((Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToInteger((int)JDBCV2Suite.$anonfun$beforeAll$1(conn)));
    }

    @Override
    public void afterAll() {
        Utils$.MODULE$.deleteRecursively(this.tempDir());
        SharedSparkSession.afterAll$(this);
    }

    private final void testImplicits$lzycompute$1() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ int $anonfun$beforeAll$1(Connection conn) {
        conn.prepareStatement("CREATE SCHEMA \"test\"").executeUpdate();
        conn.prepareStatement("CREATE TABLE \"test\".\"empty_table\" (name TEXT(32) NOT NULL, id INTEGER NOT NULL)").executeUpdate();
        conn.prepareStatement("CREATE TABLE \"test\".\"people\" (name TEXT(32) NOT NULL, id INTEGER NOT NULL)").executeUpdate();
        conn.prepareStatement("INSERT INTO \"test\".\"people\" VALUES ('fred', 1)").executeUpdate();
        return conn.prepareStatement("INSERT INTO \"test\".\"people\" VALUES ('mary', 2)").executeUpdate();
    }

    public JDBCV2Suite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        this.url = new StringBuilder(40).append("jdbc:h2:").append(this.tempDir().getCanonicalPath()).append(";user=testUser;password=testPass").toString();
        this.conn = null;
        this.test("simple scan", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM h2.test.empty_table"), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM h2.test.people"), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)}))}))));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.people"), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)}))}))));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("scan with filter push-down", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq filters;
            Dataset df = this.spark().table("h2.test.people").filter(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)1)));
            Seq $org_scalatest_assert_macro_left = filters = df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Filter filter;
                    A1 A1 = x1;
                    Object object = A1 instanceof Filter ? (filter = (Filter)A1) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    boolean bl = logicalPlan instanceof Filter;
                    return bl;
                }
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)})));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("scan with column pruning", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().table("h2.test.people").select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            DataSourceV2ScanRelation scan = (DataSourceV2ScanRelation)df.queryExecution().optimizedPlan().collectFirst((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    DataSourceV2ScanRelation dataSourceV2ScanRelation;
                    A1 A1 = x2;
                    Object object = A1 instanceof DataSourceV2ScanRelation ? (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1) : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x2) {
                    LogicalPlan logicalPlan = x2;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
            }).get();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scan.schema().names())).sameElements((GenIterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ID"}))), "scala.Predef.refArrayOps[String](scan.schema.names).sameElements[String](scala.collection.Seq.apply[String](\"ID\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))}))));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("scan with filter push-down and column pruning", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq filters;
            Dataset df = this.spark().table("h2.test.people").filter(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)1))).select("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            Seq $org_scalatest_assert_macro_left = filters = df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    Filter filter;
                    A1 A1 = x3;
                    Object object = A1 instanceof Filter ? (filter = (Filter)A1) : function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x3) {
                    LogicalPlan logicalPlan = x3;
                    boolean bl = logicalPlan instanceof Filter;
                    return bl;
                }
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            DataSourceV2ScanRelation scan = (DataSourceV2ScanRelation)df.queryExecution().optimizedPlan().collectFirst((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    DataSourceV2ScanRelation dataSourceV2ScanRelation;
                    A1 A1 = x4;
                    Object object = A1 instanceof DataSourceV2ScanRelation ? (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1) : function1.apply(x4);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x4) {
                    LogicalPlan logicalPlan = x4;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
            }).get();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scan.schema().names())).sameElements((GenIterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NAME"}))), "scala.Predef.refArrayOps[String](scan.schema.names).sameElements[String](scala.collection.Seq.apply[String](\"NAME\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary"})));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("read/write with partition info", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String e;
            this.sql().apply((Object)"CREATE TABLE h2.test.abc AS SELECT * FROM h2.test.people");
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(JDBCV2Suite.class.getClassLoader());
            public final class Org_apache_spark_sql_jdbc_JDBCV2Suite$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_jdbc_JDBCV2Suite$$typecreator5$1(JDBCV2Suite $outer) {
                }
            }
            Dataset df1 = this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"evan", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"cathy", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple2((Object)"alex", (Object)BoxesRunTime.boxToInteger((int)5))})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_jdbc_JDBCV2Suite$$typecreator5$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NAME", "ID"}));
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df1.write().option("partitionColumn", "id").option("lowerBound", "0").option("upperBound", "3").option("numPartitions", "0").insertInto("h2.test.abc"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116))).getMessage();
            String $org_scalatest_assert_macro_right = "Invalid value `0` for parameter `numPartitions` in table writing via JDBC. The minimum value is 1.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            df1.write().option("partitionColumn", "id").option("lowerBound", "0").option("upperBound", "3").option("numPartitions", "3").insertInto("h2.test.abc");
            Dataset df2 = this.spark().read().option("partitionColumn", "id").option("lowerBound", "0").option("upperBound", "3").option("numPartitions", "2").table("h2.test.abc");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)df2.rdd().getNumPartitions()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df2.count()));
            int $org_scalatest_assert_macro_right3 = 5;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("show tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES IN h2.test"), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"test", "people"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"test", "empty_table"}))})))), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.test("SQL API: create table as select", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE h2.test.abc AS SELECT * FROM h2.test.people");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)}))}))));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("DataFrameWriterV2: create table as select", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().table("h2.test.people").writeTo("h2.test.abc").create();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)}))}))));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("SQL API: replace table as select", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"REPLACE TABLE h2.test.abc AS SELECT 1 as col"), ClassTag$.MODULE$.apply(CannotReplaceMissingTableException.class), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            this.sql().apply((Object)"CREATE OR REPLACE TABLE h2.test.abc AS SELECT 1 as col");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT col FROM h2.test.abc"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            this.sql().apply((Object)"REPLACE TABLE h2.test.abc AS SELECT * FROM h2.test.people");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)}))}))));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        this.test("DataFrameWriterV2: replace table as select", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Dataset)this.sql().apply((Object)"SELECT 1 AS col")).writeTo("h2.test.abc").replace(), ClassTag$.MODULE$.apply(CannotReplaceMissingTableException.class), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            ((Dataset)this.sql().apply((Object)"SELECT 1 AS col")).writeTo("h2.test.abc").createOrReplace();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT col FROM h2.test.abc"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            this.spark().table("h2.test.people").writeTo("h2.test.abc").replace();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)}))}))));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        this.test("SQL API: insert and overwrite", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE h2.test.abc AS SELECT * FROM h2.test.people");
            this.sql().apply((Object)"INSERT INTO h2.test.abc SELECT 'lucy', 3");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"lucy", BoxesRunTime.boxToInteger((int)3)}))}))));
            this.sql().apply((Object)"INSERT OVERWRITE h2.test.abc SELECT 'bob', 4");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"bob", BoxesRunTime.boxToInteger((int)4)})));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("DataFrameWriterV2: insert and overwrite", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE h2.test.abc AS SELECT * FROM h2.test.people");
            ((Dataset)this.sql().apply((Object)"SELECT 3 AS ID, 'lucy' AS NAME")).writeTo("h2.test.abc").append();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"lucy", BoxesRunTime.boxToInteger((int)3)}))}))));
            ((Dataset)this.sql().apply((Object)"SELECT 'bob' AS NAME, 4 AS ID")).writeTo("h2.test.abc").overwrite(functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"bob", BoxesRunTime.boxToInteger((int)4)})));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
    }
}

