/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.LocalSparkContext$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.streaming.CreateAtomicTestManager;
import org.apache.spark.sql.execution.streaming.CreateAtomicTestManager$;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.RenameLikeHDFSFileSystem;
import org.apache.spark.sql.execution.streaming.state.RenameReturnsFalseFileSystem;
import org.apache.spark.sql.execution.streaming.state.RenameReturnsFalseFileSystem$;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorSuite$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCustomMetric;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreMetrics;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StateStoreSuiteBase;
import org.apache.spark.sql.execution.streaming.state.StateStoreTestsHelper$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\r\u001b\u0001%BQA\u000f\u0001\u0005\u0002m*A!\u0010\u0001\u0001}\u0015!\u0001\u000b\u0001\u0001R\u0011\u001dY\u0006A1A\u0005\u0002qCaa\u0019\u0001!\u0002\u0013i\u0006b\u00023\u0001\u0005\u0004%\t\u0001\u0018\u0005\u0007K\u0002\u0001\u000b\u0011B/\t\u000b\u0019\u0004A\u0011A4\t\u000bU\u0004A\u0011\u0001<\t\u000be\u0004A\u0011\u0001>\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u0011\u0011\n\u0001\u0005B\u0005-\u0003bBA%\u0001\u0011\u0005\u0013Q\n\u0005\b\u00033\u0002A\u0011IA.\u0011\u001d\ti\u0007\u0001C!\u0003_B\u0011\"!\u001e\u0001#\u0003%\t!a\u001e\t\u000f\u0005%\u0003\u0001\"\u0001\u0002\u000e\"I\u0011q\u0017\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0018\u0005\n\u0003{\u0003\u0011\u0013!C\u0001\u0003oB\u0011\"a0\u0001#\u0003%\t!a\u001e\t\u0013\u0005\u0005\u0007!%A\u0005\u0002\u0005\r\u0007bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u00033\u0004A\u0011AAn\u0011\u001d\t\t\u000f\u0001C\u0001\u0003G\u0014qb\u0015;bi\u0016\u001cFo\u001c:f'VLG/\u001a\u0006\u00037q\tQa\u001d;bi\u0016T!!\b\u0010\u0002\u0013M$(/Z1nS:<'BA\u0010!\u0003%)\u00070Z2vi&|gN\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001UE:\u0004cA\u0016-]5\t!$\u0003\u0002.5\t\u00192\u000b^1uKN#xN]3Tk&$XMQ1tKB\u00111fL\u0005\u0003ai\u0011A\u0004\u0013#G'\n\u000b7m[3e'R\fG/Z*u_J,\u0007K]8wS\u0012,'\u000f\u0005\u00023k5\t1G\u0003\u00025M\u0005I1oY1mCR,7\u000f^\u0005\u0003mM\u0012aBQ3g_J,\u0017I\u001c3BMR,'\u000f\u0005\u00023q%\u0011\u0011h\r\u0002\u0014!JLg/\u0019;f\u001b\u0016$\bn\u001c3UKN$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0002\"a\u000b\u0001\u0003\u000f5\u000b\u0007\u000fV=qKB!qH\u0012%I\u001b\u0005\u0001%BA!C\u0003\u001diW\u000f^1cY\u0016T!a\u0011#\u0002\u0015\r|G\u000e\\3di&|gNC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9\u0005IA\u0004ICNDW*\u00199\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015aC3yaJ,7o]5p]NT!!\u0014\u0011\u0002\u0011\r\fG/\u00197zgRL!a\u0014&\u0003\u0013Us7/\u00194f%><(a\u0004)s_ZLG-\u001a:NCB$\u0016\u0010]3\u0011\tIK\u0006\nS\u0007\u0002'*\u0011A+V\u0001\u000bG>t7-\u001e:sK:$(B\u0001,X\u0003\u0011)H/\u001b7\u000b\u0003a\u000bAA[1wC&\u0011!l\u0015\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\u0018!C6fsN\u001b\u0007.Z7b+\u0005i\u0006C\u00010b\u001b\u0005y&B\u00011!\u0003\u0015!\u0018\u0010]3t\u0013\t\u0011wL\u0001\u0006TiJ,8\r\u001e+za\u0016\f!b[3z'\u000eDW-\\1!\u0003-1\u0018\r\\;f'\u000eDW-\\1\u0002\u0019Y\fG.^3TG\",W.\u0019\u0011\u0002\u001fU\u0004H-\u0019;f-\u0016\u00148/[8o)>$B\u0001\u001b7rgB\u0011\u0011N[\u0007\u0002\t&\u00111\u000e\u0012\u0002\u0004\u0013:$\b\"B7\t\u0001\u0004q\u0017\u0001\u00039s_ZLG-\u001a:\u0011\u0005-z\u0017B\u00019\u001b\u0005I\u0019F/\u0019;f'R|'/\u001a)s_ZLG-\u001a:\t\u000bID\u0001\u0019\u00015\u0002\u001d\r,(O]3oiZ+'o]5p]\")A\u000f\u0003a\u0001Q\u0006iA/\u0019:hKR4VM]:j_:\f\u0001#\u001b8de\u0016lWM\u001c;WKJ\u001c\u0018n\u001c8\u0015\u0007!<\b\u0010C\u0003n\u0013\u0001\u0007a\u000eC\u0003s\u0013\u0001\u0007\u0001.A\ndQ\u0016\u001c7\u000eT8bI\u0016$g+\u001a:tS>t7\u000f\u0006\u0005|}\u0006M\u0011qCA\u000e!\tIG0\u0003\u0002~\t\n!QK\\5u\u0011\u0019y(\u00021\u0001\u0002\u0002\u0005QAn\\1eK\u0012l\u0015\r]:\u0011\u0011\u0005\r\u0011QAA\u0005\u0003\u001fi\u0011!V\u0005\u0004\u0003\u000f)&!C*peR,G-T1q!\rI\u00171B\u0005\u0004\u0003\u001b!%\u0001\u0002'p]\u001e\u00042!!\u0005\u0004\u001b\u0005\u0001\u0001BBA\u000b\u0015\u0001\u0007\u0001.A\u0003d_VtG\u000fC\u0004\u0002\u001a)\u0001\r!!\u0003\u0002\u0017\u0015\f'\u000f\\5fgR\\U-\u001f\u0005\b\u0003;Q\u0001\u0019AA\u0005\u0003%a\u0017\r^3ti.+\u00170\u0001\u0007dQ\u0016\u001c7NV3sg&|g\u000eF\u0004|\u0003G\t)#!\u000b\t\r}\\\u0001\u0019AA\u0001\u0011\u001d\t9c\u0003a\u0001\u0003\u0013\tqA^3sg&|g\u000eC\u0004\u0002,-\u0001\r!!\f\u0002\u0019\u0015D\b/Z2uK\u0012$\u0015\r^1\u0011\u000f\u0005=\u0012QHA\"Q:!\u0011\u0011GA\u001d!\r\t\u0019\u0004R\u0007\u0003\u0003kQ1!a\u000e)\u0003\u0019a$o\\8u}%\u0019\u00111\b#\u0002\rA\u0013X\rZ3g\u0013\u0011\ty$!\u0011\u0003\u00075\u000b\u0007OC\u0002\u0002<\u0011\u0003B!a\f\u0002F%!\u0011qIA!\u0005\u0019\u0019FO]5oO\u0006\u0001b.Z<Ti>\u0014X\r\u0015:pm&$WM\u001d\u000b\u0002]Q\u0019a&a\u0014\t\u000f\u0005ES\u00021\u0001\u0002T\u000591\u000f^8sK&#\u0007cA\u0016\u0002V%\u0019\u0011q\u000b\u000e\u0003\u0019M#\u0018\r^3Ti>\u0014X-\u00133\u0002\u001b\u001d,G\u000fT1uKN$H)\u0019;b)\u0011\ti&!\u001b\u0011\r\u0005=\u0012qLA2\u0013\u0011\t\t'!\u0011\u0003\u0007M+G\u000f\u0005\u0004j\u0003K\n\u0019\u0005[\u0005\u0004\u0003O\"%A\u0002+va2,'\u0007\u0003\u0004\u0002l9\u0001\rAL\u0001\u000egR|'/\u001a)s_ZLG-\u001a:\u0002\u000f\u001d,G\u000fR1uCR1\u0011QLA9\u0003gBQ!\\\bA\u00029B\u0001\"a\n\u0010!\u0003\u0005\r\u0001[\u0001\u0012O\u0016$H)\u0019;bI\u0011,g-Y;mi\u0012\u0012TCAA=U\rA\u00171P\u0016\u0003\u0003{\u0002B!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0011#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\f\u0006\u0005%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKRia&a$\u0002\u0014\u0006]\u00151TAP\u0003GCq!!%\u0012\u0001\u0004\tI!\u0001\u0003pa&#\u0007BBAK#\u0001\u0007\u0001.A\u0005qCJ$\u0018\u000e^5p]\"I\u0011\u0011T\t\u0011\u0002\u0003\u0007\u00111I\u0001\u0004I&\u0014\b\u0002CAO#A\u0005\t\u0019\u00015\u0002)5Lg\u000eR3mi\u0006\u001chi\u001c:T]\u0006\u00048\u000f[8u\u0011!\t\t+\u0005I\u0001\u0002\u0004A\u0017!\u00078v[>3g+\u001a:t)>\u0014V\r^1j]&sW*Z7pefD\u0011\"!*\u0012!\u0003\u0005\r!a*\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002*\u0006MVBAAV\u0015\u0011\ti+a,\u0002\t\r|gN\u001a\u0006\u0004\u0003c#\u0013A\u00025bI>|\u0007/\u0003\u0003\u00026\u0006-&!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u000eoK^\u001cFo\u001c:f!J|g/\u001b3fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002<*\"\u00111IA>\u0003iqWm^*u_J,\u0007K]8wS\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003iqWm^*u_J,\u0007K]8wS\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003iqWm^*u_J,\u0007K]8wS\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\t)M\u000b\u0003\u0002(\u0006m\u0014A\u00034jY\u0016,\u00050[:ugRA\u00111ZAi\u0003'\f)\u000eE\u0002j\u0003\u001bL1!a4E\u0005\u001d\u0011un\u001c7fC:DQ!\u001c\fA\u00029Bq!a\n\u0017\u0001\u0004\tI\u0001C\u0004\u0002XZ\u0001\r!a3\u0002\u0015%\u001c8K\\1qg\"|G/A\u000feK2,G/\u001a$jY\u0016\u001cX)\u0019:mS\u0016\u0014H\u000b[1o-\u0016\u00148/[8o)\u0015Y\u0018Q\\Ap\u0011\u0015iw\u00031\u0001/\u0011\u001d\t9c\u0006a\u0001\u0003\u0013\t1bY8seV\u0004HOR5mKR910!:\u0002h\u0006%\b\"B7\u0019\u0001\u0004q\u0003bBA\u00141\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003/D\u0002\u0019AAf\u0001")
public class StateStoreSuite
extends StateStoreSuiteBase<HDFSBackedStateStoreProvider>
implements BeforeAndAfter,
PrivateMethodTester {
    private final StructType keySchema;
    private final StructType valueSchema;
    private volatile PrivateMethodTester$PrivateMethod$ PrivateMethod$module;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.anyRefToInvoker$((PrivateMethodTester)this, (Object)target);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        if (this.PrivateMethod$module == null) {
            this.PrivateMethod$lzycompute$1();
        }
        return this.PrivateMethod$module;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public StructType keySchema() {
        return this.keySchema;
    }

    public StructType valueSchema() {
        return this.valueSchema;
    }

    public int updateVersionTo(StateStoreProvider provider, int currentVersion, int targetVersion) {
        IntRef newCurrentVersion = IntRef.create((int)currentVersion);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(newCurrentVersion.elem), targetVersion).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            newCurrentVersion$1.elem = this.incrementVersion(provider, i);
        });
        Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)newCurrentVersion.elem)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)targetVersion), Equality$.MODULE$.default()));
        return newCurrentVersion.elem;
    }

    public int incrementVersion(StateStoreProvider provider, int currentVersion) {
        StateStore store = provider.getStore((long)currentVersion);
        StateStoreTestsHelper$.MODULE$.put(store, "a", currentVersion + 1);
        store.commit();
        return currentVersion + 1;
    }

    public void checkLoadedVersions(SortedMap<Object, ConcurrentHashMap<UnsafeRow, UnsafeRow>> loadedMaps, int count, long earliestKey, long latestKey) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
        int $org_scalatest_assert_macro_right = count;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(loadedMaps.firstKey());
        long $org_scalatest_assert_macro_right2 = earliestKey;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(loadedMaps.lastKey());
        long $org_scalatest_assert_macro_right3 = latestKey;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
    }

    public void checkVersion(SortedMap<Object, ConcurrentHashMap<UnsafeRow, UnsafeRow>> loadedMaps, long version, Map<String, Object> expectedData) {
        Map originValueMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter((ConcurrentMap)loadedMaps.get(BoxesRunTime.boxToLong((long)version))).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StateStoreTestsHelper$.MODULE$.rowToString((UnsafeRow)entry._1())), (Object)BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.rowToInt((UnsafeRow)entry._2()))), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(originValueMap);
        Map<String, Object> $org_scalatest_assert_macro_right = expectedData;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider() {
        return this.newStoreProvider(Random$.MODULE$.nextInt(), 0, this.newStoreProvider$default$3(), this.newStoreProvider$default$4(), this.newStoreProvider$default$5(), this.newStoreProvider$default$6());
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(StateStoreId storeId) {
        return this.newStoreProvider(storeId.operatorId(), storeId.partitionId(), storeId.checkpointRootLocation(), this.newStoreProvider$default$4(), this.newStoreProvider$default$5(), this.newStoreProvider$default$6());
    }

    @Override
    public Set<Tuple2<String, Object>> getLatestData(HDFSBackedStateStoreProvider storeProvider) {
        return this.getData(storeProvider, this.getData$default$2());
    }

    @Override
    public Set<Tuple2<String, Object>> getData(HDFSBackedStateStoreProvider provider, int version) {
        HDFSBackedStateStoreProvider reloadedProvider = this.newStoreProvider(provider.stateStoreId());
        return version < 0 ? reloadedProvider.latestIterator().map((Function1 & Serializable & scala.Serializable)row -> StateStoreTestsHelper$.MODULE$.rowsToStringInt((UnsafeRowPair)row)).toSet() : reloadedProvider.getStore((long)version).iterator().map((Function1 & Serializable & scala.Serializable)row -> StateStoreTestsHelper$.MODULE$.rowsToStringInt((UnsafeRowPair)row)).toSet();
    }

    public int getData$default$2() {
        return -1;
    }

    public HDFSBackedStateStoreProvider newStoreProvider(long opId, int partition, String dir, int minDeltasForSnapshot, int numOfVersToRetainInMemory, Configuration hadoopConf) {
        SQLConf sqlConf = new SQLConf();
        sqlConf.setConf(SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT(), (Object)BoxesRunTime.boxToInteger((int)minDeltasForSnapshot));
        sqlConf.setConf(SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY(), (Object)BoxesRunTime.boxToInteger((int)numOfVersToRetainInMemory));
        sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
        sqlConf.setConf(SQLConf$.MODULE$.STATE_STORE_COMPRESSION_CODEC(), (Object)SQLConf$.MODULE$.get().stateStoreCompressionCodec());
        HDFSBackedStateStoreProvider provider = new HDFSBackedStateStoreProvider();
        provider.init(new StateStoreId(dir, opId, partition, StateStoreId$.MODULE$.apply$default$4()), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, new StateStoreConf(sqlConf, StateStoreConf$.MODULE$.$lessinit$greater$default$2()), hadoopConf);
        return provider;
    }

    public String newStoreProvider$default$3() {
        return StateStoreTestsHelper$.MODULE$.newDir();
    }

    public int newStoreProvider$default$4() {
        return BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT().defaultValue().get());
    }

    public int newStoreProvider$default$5() {
        return BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY().defaultValue().get());
    }

    public Configuration newStoreProvider$default$6() {
        return new Configuration();
    }

    public boolean fileExists(HDFSBackedStateStoreProvider provider, long version, boolean isSnapshot) {
        PrivateMethodTester.PrivateMethod method = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "baseDir"));
        Path basePath = (Path)this.anyRefToInvoker(provider).invokePrivate(method.apply((Seq)Nil$.MODULE$));
        String fileName = isSnapshot ? new StringBuilder(9).append(version).append(".snapshot").toString() : new StringBuilder(6).append(version).append(".delta").toString();
        File filePath = new File(basePath.toString(), fileName);
        return filePath.exists();
    }

    public void deleteFilesEarlierThanVersion(HDFSBackedStateStoreProvider provider, long version2) {
        PrivateMethodTester.PrivateMethod method = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "baseDir"));
        Path basePath = (Path)this.anyRefToInvoker(provider).invokePrivate(method.apply((Seq)Nil$.MODULE$));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)version2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)isSnapshot -> StateStoreSuite.$anonfun$deleteFilesEarlierThanVersion$2(version, basePath, BoxesRunTime.unboxToBoolean((Object)isSnapshot))));
    }

    public void corruptFile(HDFSBackedStateStoreProvider provider, long version, boolean isSnapshot) {
        PrivateMethodTester.PrivateMethod method = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "baseDir"));
        Path basePath = (Path)this.anyRefToInvoker(provider).invokePrivate(method.apply((Seq)Nil$.MODULE$));
        String fileName = isSnapshot ? new StringBuilder(9).append(version).append(".snapshot").toString() : new StringBuilder(6).append(version).append(".delta").toString();
        File filePath = new File(basePath.toString(), fileName);
        filePath.delete();
        filePath.createNewFile();
    }

    private final void PrivateMethod$lzycompute$1() {
        StateStoreSuite stateStoreSuite = this;
        synchronized (stateStoreSuite) {
            if (this.PrivateMethod$module == null) {
                this.PrivateMethod$module = new PrivateMethodTester$PrivateMethod$((PrivateMethodTester)this);
            }
        }
    }

    public static final /* synthetic */ Assertion $anonfun$new$7(StateStoreSuite $this, HDFSBackedStateStoreProvider provider$2, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$2, i, false), "StateStoreSuite.this.fileExists(provider, i.toLong, false)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$2, i, true), "StateStoreSuite.this.fileExists(provider, i.toLong, true)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
    }

    public static final /* synthetic */ boolean $anonfun$new$16(File x$1) {
        return x$1.getName().startsWith("temp-");
    }

    public static final /* synthetic */ boolean $anonfun$new$26(Tuple2 x$2) {
        String string = ((StateStoreCustomMetric)x$2._1()).name();
        String string2 = "stateOnCurrentVersionSizeBytes";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final long getSizeOfStateForCurrentVersion$1(StateStoreMetrics metrics) {
        Option metricPair = metrics.customMetrics().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$26(x$2)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metricPair.isDefined(), "metricPair.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        return ((Tuple2)metricPair.get())._2$mcJ$sp();
    }

    private final void generateStoreVersions$1(StateStoreProviderId storeProviderId$1, IntRef latestStoreVersion$1, StateStoreConf storeConf$2, Configuration hadoopConf$2) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            StateStore store = StateStore$.MODULE$.get(storeProviderId$1, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, (long)latestStoreVersion$1.elem, storeConf$2, hadoopConf$2);
            StateStoreTestsHelper$.MODULE$.put(store, "a", i);
            store.commit();
            ++latestStoreVersion$1.elem;
        });
    }

    public static final /* synthetic */ void $anonfun$new$35(StateStoreSuite $this, Span timeoutDuration$1, StateStoreProviderId storeProviderId$1, IntRef latestStoreVersion$1, HDFSBackedStateStoreProvider provider$5, StateStoreConf storeConf$2, Configuration hadoopConf$2, StateStoreCoordinatorRef coordinatorRef) {
        Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning(), (Function0 & Serializable & scala.Serializable)() -> "StateStore is unexpectedly running");
        $this.generateStoreVersions$1(storeProviderId$1, latestStoreVersion$1, storeConf$2, hadoopConf$2);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedSeq snapshotVersions;
            Option $org_scalatest_assert_macro_left = coordinatorRef.getLocation(storeProviderId$1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"active instance was not reported", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Maintenance task is not running", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
            IndexedSeq $org_scalatest_assert_macro_left2 = snapshotVersions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), latestStoreVersion$1.elem).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)version -> $this.fileExists(provider$5, version, true));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
        $this.generateStoreVersions$1(storeProviderId$1, latestStoreVersion$1, storeConf$2, hadoopConf$2);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$5, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"earliest file not deleted", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        coordinatorRef.deactivateInstances(storeProviderId$1.queryRunId());
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId$1), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
        StateStore$.MODULE$.get(storeProviderId$1, $this.keySchema(), $this.valueSchema(), (Option)None$.MODULE$, (long)latestStoreVersion$1.elem, storeConf$2, hadoopConf$2);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId$1), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
        coordinatorRef.reportActiveInstance(storeProviderId$1, "other-host", "other-exec");
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId$1), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
        StateStore$.MODULE$.get(storeProviderId$1, $this.keySchema(), $this.valueSchema(), (Option)None$.MODULE$, (long)latestStoreVersion$1.elem, storeConf$2, hadoopConf$2);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId$1), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
    }

    private static final int numTempFiles$1(File deltaFileDir$1) {
        return deltaFileDir$1.exists() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltaFileDir$1.listFiles())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).count((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)n.endsWith(".tmp"))) : 0;
    }

    public static final /* synthetic */ boolean $anonfun$new$49(String n) {
        return n.contains(".delta") && !n.startsWith(".");
    }

    private static final int numDeltaFiles$1(File deltaFileDir$1) {
        return deltaFileDir$1.exists() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltaFileDir$1.listFiles())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).count((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$49(n))) : 0;
    }

    private final Object shouldNotCreateTempFile$1(Function0 body, File deltaFileDir$1) {
        int before = StateStoreSuite.numTempFiles$1(deltaFileDir$1);
        Object result = body.apply();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir$1)));
        int $org_scalatest_assert_macro_right = before;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$new$52(String x$5) {
        String string = x$5;
        String string2 = "a";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Seq runQueryAndGetLoadedProviders$1(MemoryStream inputData$1, File checkpointLocation$1) {
        Seq seq;
        HashMap loadedProvidersMap;
        Dataset aggregated = inputData$1.toDF().groupBy("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg((Column)functions$.MODULE$.count("*"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
        StreamingQuery query = aggregated.writeStream().format("memory").outputMode("complete").queryName("query").option("checkpointLocation", checkpointLocation$1.toString()).start();
        inputData$1.addData((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        query.processAllAvailable();
        Predef$.MODULE$.require(query.lastProgress() != null);
        PrivateMethodTester.PrivateMethod loadedProvidersMethod = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "loadedProviders"));
        HashMap hashMap = loadedProvidersMap = (HashMap)this.anyRefToInvoker(StateStore$.MODULE$).invokePrivate(loadedProvidersMethod.apply((Seq)Nil$.MODULE$));
        synchronized (hashMap) {
            seq = loadedProvidersMap.values().toSeq();
        }
        Seq loadedProviders = seq;
        query.stop();
        return loadedProviders;
    }

    public static final /* synthetic */ void $anonfun$new$55(SparkSession spark) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spark.streams().active())).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.stop();
            return BoxedUnit.UNIT;
        });
        spark.stop();
    }

    public static final /* synthetic */ String $anonfun$new$59(long x$7) {
        return ((Object)BoxesRunTime.boxToLong((long)x$7)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$new$64(String name$1, Tuple2 x$8) {
        String string = ((StateStoreCustomMetric)x$8._1()).name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final long getCustomMetric$1(StateStoreMetrics metrics, String name) {
        Option metricPair = metrics.customMetrics().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$64(name, x$8)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metricPair.isDefined(), "metricPair.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 655));
        return ((Tuple2)metricPair.get())._2$mcJ$sp();
    }

    private static final long getLoadedMapSizeMetric$1(StateStoreMetrics metrics) {
        return metrics.memoryUsedBytes();
    }

    private final void assertCacheHitAndMiss$1(StateStoreMetrics metrics, long expectedCacheHitCount, long expectedCacheMissCount) {
        long cacheHitCount = StateStoreSuite.getCustomMetric$1(metrics, "loadedMapCacheHitCount");
        long cacheMissCount = StateStoreSuite.getCustomMetric$1(metrics, "loadedMapCacheMissCount");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cacheHitCount));
        long $org_scalatest_assert_macro_right = expectedCacheHitCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cacheMissCount));
        long $org_scalatest_assert_macro_right2 = expectedCacheMissCount;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
    }

    public static final /* synthetic */ Object $anonfun$deleteFilesEarlierThanVersion$2(int version$1, Path basePath$1, boolean isSnapshot) {
        String fileName = isSnapshot ? new StringBuilder(9).append(version$1).append(".snapshot").toString() : new StringBuilder(6).append(version$1).append(".delta").toString();
        File filePath = new File(basePath$1.toString(), fileName);
        return filePath.exists() ? BoxesRunTime.boxToBoolean((boolean)filePath.delete()) : BoxedUnit.UNIT;
    }

    public StateStoreSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        PrivateMethodTester.$init$((PrivateMethodTester)this);
        this.keySchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        this.valueSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("value", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("retaining only two latest versions when MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long x$1 = Random$.MODULE$.nextInt();
            int x$2 = 0;
            int x$3 = 2;
            String x$4 = this.newStoreProvider$default$3();
            int x$5 = this.newStoreProvider$default$4();
            Configuration x$6 = this.newStoreProvider$default$6();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$1, x$2, x$4, x$5, x$3, x$6);
            int currentVersion = 0;
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            SortedMap loadedMaps = provider.getLoadedMaps();
            this.checkLoadedVersions(loadedMaps, 1, 1L, 1L);
            this.checkVersion(loadedMaps, 1L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}))));
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            loadedMaps = provider.getLoadedMaps();
            this.checkLoadedVersions(loadedMaps, 2, 2L, 1L);
            this.checkVersion(loadedMaps, 2L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
            this.checkVersion(loadedMaps, 1L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}))));
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            loadedMaps = provider.getLoadedMaps();
            this.checkLoadedVersions(loadedMaps, 2, 3L, 2L);
            this.checkVersion(loadedMaps, 3L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)3))}))));
            this.checkVersion(loadedMaps, 2L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("failure after committing with MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long x$7 = Random$.MODULE$.nextInt();
            int x$8 = 0;
            int x$9 = 1;
            String x$10 = this.newStoreProvider$default$3();
            int x$11 = this.newStoreProvider$default$4();
            Configuration x$12 = this.newStoreProvider$default$6();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$7, x$8, x$10, x$11, x$9, x$12);
            int currentVersion = 0;
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            SortedMap loadedMaps = provider.getLoadedMaps();
            this.checkLoadedVersions(loadedMaps, 1, 1L, 1L);
            this.checkVersion(loadedMaps, 1L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}))));
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            loadedMaps = provider.getLoadedMaps();
            this.checkLoadedVersions(loadedMaps, 1, 2L, 2L);
            this.checkVersion(loadedMaps, 2L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
            currentVersion = 1;
            StateStore store = provider.getStore((long)currentVersion);
            StateStoreTestsHelper$.MODULE$.put(store, "a", -2);
            store.commit();
            ++currentVersion;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)-2))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            loadedMaps = provider.getLoadedMaps();
            this.checkLoadedVersions(loadedMaps, 1, 2L, 2L);
            this.checkVersion(loadedMaps, 2L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)-2))}))));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("no cache data with MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long x$13 = Random$.MODULE$.nextInt();
            int x$14 = 0;
            int x$15 = 0;
            String x$16 = this.newStoreProvider$default$3();
            int x$17 = this.newStoreProvider$default$4();
            Configuration x$18 = this.newStoreProvider$default$6();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$13, x$14, x$16, x$17, x$15, x$18);
            int currentVersion = 0;
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            SortedMap loadedMaps = provider.getLoadedMaps();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            loadedMaps = provider.getLoadedMaps();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        this.test("snapshotting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option latestSnapshotVersion;
            Option snapshotVersion;
            long x$19 = Random$.MODULE$.nextInt();
            int x$20 = 0;
            int x$21 = 5;
            String x$22 = this.newStoreProvider$default$3();
            int x$23 = this.newStoreProvider$default$5();
            Configuration x$24 = this.newStoreProvider$default$6();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$19, x$20, x$22, x$21, x$23, x$24);
            int currentVersion = 0;
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 2);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getData(provider, this.getData$default$2())).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))})), Equality$.MODULE$.default()));
            provider.doMaintenance();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), currentVersion).foreach((Function1 & Serializable & scala.Serializable)i -> StateStoreSuite.$anonfun$new$7(this, provider, BoxesRunTime.unboxToInt((Object)i)));
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 6);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getData(provider, this.getData$default$2())).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)6))})), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "store not updated correctly");
            provider.doMaintenance();
            Option $org_scalatest_assert_macro_left2 = snapshotVersion = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)version -> this.fileExists(provider, version, true));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"snapshot file not generated", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
            this.deleteFilesEarlierThanVersion(provider, BoxesRunTime.unboxToInt((Object)snapshotVersion.get()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getData(provider, BoxesRunTime.unboxToInt((Object)snapshotVersion.get())));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), snapshotVersion.get())}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"snapshotting messed up the data of the snapshotted version", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)6))}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"snapshotting messed up the data of the final version", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 20);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getData(provider, this.getData$default$2())).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))})), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "store not updated correctly");
            provider.doMaintenance();
            Option $org_scalatest_assert_macro_left5 = latestSnapshotVersion = ((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)version -> this.fileExists(provider, version, true))).lastOption();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            int $org_scalatest_assert_macro_left6 = BoxesRunTime.unboxToInt((Object)latestSnapshotVersion.get());
            int $org_scalatest_assert_macro_right4 = BoxesRunTime.unboxToInt((Object)snapshotVersion.get());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left6 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"newer snapshot not generated", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            this.deleteFilesEarlierThanVersion(provider, BoxesRunTime.unboxToInt((Object)latestSnapshotVersion.get()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))}));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"snapshotting messed up the data", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("cleaning", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long x$25 = Random$.MODULE$.nextInt();
            int x$26 = 0;
            int x$27 = 5;
            String x$28 = this.newStoreProvider$default$3();
            int x$29 = this.newStoreProvider$default$5();
            Configuration x$30 = this.newStoreProvider$default$6();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$25, x$26, x$28, x$27, x$29, x$30);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                StateStore store = provider.getStore((long)(i - 1));
                StateStoreTestsHelper$.MODULE$.put(store, "a", i);
                store.commit();
                provider.doMaintenance();
            });
            Predef$.MODULE$.require(this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowsToSet((Iterator<UnsafeRowPair>)provider.latestIterator())).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))})), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "store not updated correctly");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.fileExists(provider, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, 20));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData(provider, 19));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)19))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        this.testQuietly("SPARK-19677: Committing a delta file atop an existing one should not fail on HDFS", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Iterable tempFiles;
            Configuration conf = new Configuration();
            conf.set("fs.fake.impl", RenameLikeHDFSFileSystem.class.getName());
            conf.set("fs.defaultFS", "fake:///");
            long x$31 = Random$.MODULE$.nextInt();
            int x$32 = 0;
            Configuration x$33 = conf;
            String x$34 = this.newStoreProvider$default$3();
            int x$35 = this.newStoreProvider$default$4();
            int x$36 = this.newStoreProvider$default$5();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$31, x$32, x$34, x$35, x$36, x$33);
            provider.getStore(0L).commit();
            provider.getStore(0L).commit();
            Iterable $org_scalatest_assert_macro_left = tempFiles = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)new File(provider.stateStoreId().checkpointRootLocation()), null, (boolean)true)).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$16(x$1)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        });
        this.test("corrupted file handling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long x$37 = Random$.MODULE$.nextInt();
            int x$38 = 0;
            int x$39 = 5;
            String x$40 = this.newStoreProvider$default$3();
            int x$41 = this.newStoreProvider$default$5();
            Configuration x$42 = this.newStoreProvider$default$6();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$37, x$38, x$40, x$39, x$41, x$42);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                StateStore store = provider.getStore((long)(i - 1));
                StateStoreTestsHelper$.MODULE$.put(store, "a", i);
                store.commit();
                provider.doMaintenance();
            });
            int snapshotVersion = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)version -> this.fileExists(provider, version, true)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("snapshot file not found", new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, snapshotVersion));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)snapshotVersion))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            this.corruptFile(provider, snapshotVersion, true);
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.getData(provider, snapshotVersion), ClassTag$.MODULE$.apply(Exception.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData(provider, snapshotVersion - 1));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)(snapshotVersion - 1)))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            this.corruptFile(provider, snapshotVersion - 1, false);
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.getData(provider, snapshotVersion - 1), ClassTag$.MODULE$.apply(Exception.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            this.deleteFilesEarlierThanVersion(provider, snapshotVersion);
            return (Exception)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.getData(provider, snapshotVersion - 1), ClassTag$.MODULE$.apply(Exception.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        this.test("reports memory usage", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            HDFSBackedStateStoreProvider provider = this.newStoreProvider();
            StateStore store = provider.getStore(0L);
            long noDataMemoryUsed = store.metrics().memoryUsedBytes();
            StateStoreTestsHelper$.MODULE$.put(store, "a", 1);
            store.commit();
            long $org_scalatest_assert_macro_left = store.metrics().memoryUsedBytes();
            long $org_scalatest_assert_macro_right = noDataMemoryUsed;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        this.test("reports memory usage on current version", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            HDFSBackedStateStoreProvider provider = this.newStoreProvider();
            StateStore store = provider.getStore(0L);
            long noDataMemoryUsed = StateStoreSuite.getSizeOfStateForCurrentVersion$1(store.metrics());
            StateStoreTestsHelper$.MODULE$.put(store, "a", 1);
            store.commit();
            long $org_scalatest_assert_macro_left = StateStoreSuite.getSizeOfStateForCurrentVersion$1(store.metrics());
            long $org_scalatest_assert_macro_right = noDataMemoryUsed;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
        this.test("StateStore.get", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> {
            String dir = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeId = new StateStoreProviderId(new StateStoreId(dir, 0L, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            StateStoreConf storeConf = StateStoreConf$.MODULE$.empty();
            Configuration hadoopConf = new Configuration();
            this.intercept((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, -1L, storeConf, hadoopConf), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeId), "StateStore.isLoaded(storeId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 1L, storeConf, hadoopConf), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
            StateStore store0 = StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 0L, storeConf, hadoopConf);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store0.version()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            StateStoreTestsHelper$.MODULE$.put(store0, "a", 1);
            store0.commit();
            StateStore store1 = StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 1L, storeConf, hadoopConf);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeId), "StateStore.isLoaded(storeId)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store1.version()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowsToSet((Iterator<UnsafeRowPair>)store1.iterator()));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
            StateStore store0reloaded = StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 0L, storeConf, hadoopConf);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store0reloaded.version()));
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowsToSet((Iterator<UnsafeRowPair>)store0reloaded.iterator()));
            Set $org_scalatest_assert_macro_right5 = Predef$.MODULE$.Set().empty();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
            StateStore$.MODULE$.unload(storeId);
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeId), "StateStore.isLoaded(storeId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
            StateStore store1reloaded = StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 1L, storeConf, hadoopConf);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeId), "StateStore.isLoaded(storeId)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store1reloaded.version()));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            StateStoreTestsHelper$.MODULE$.put(store1reloaded, "a", 2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store1reloaded.commit()));
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowsToSet((Iterator<UnsafeRowPair>)store1reloaded.iterator()));
            Set $org_scalatest_assert_macro_right8 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        }), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        this.test("maintenance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("test").set(Network$.MODULE$.RPC_NUM_RETRIES(), (Object)BoxesRunTime.boxToInteger((int)1));
            int opId = 0;
            String dir = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeProviderId = new StateStoreProviderId(new StateStoreId(dir, (long)opId, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            SQLConf sqlConf = new SQLConf();
            sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
            sqlConf.setConf(SQLConf$.MODULE$.STREAMING_MAINTENANCE_INTERVAL(), (Object)BoxesRunTime.boxToLong((long)10L));
            StateStoreConf storeConf = StateStoreConf$.MODULE$.apply(sqlConf);
            Configuration hadoopConf = new Configuration();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(storeProviderId.storeId());
            IntRef latestStoreVersion = IntRef.create((int)0);
            Span timeoutDuration = SpanSugar$.MODULE$.convertIntToGrainOfTime(1).minute();
            return (Assertion)package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> {
                LocalSparkContext$.MODULE$.withSpark(new SparkContext(conf), (Function1 & Serializable & scala.Serializable)sc -> {
                    StateStoreCoordinatorSuite$.MODULE$.withCoordinatorRef(sc, (Function1<StateStoreCoordinatorRef, BoxedUnit>)(Function1 & Serializable & scala.Serializable)coordinatorRef -> {
                        StateStoreSuite.$anonfun$new$35($this, timeoutDuration$1, storeProviderId$1, latestStoreVersion$1, provider$5, storeConf$2, hadoopConf$2, coordinatorRef);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration), (Function0 & Serializable & scala.Serializable)() -> {
                    Predef$.MODULE$.require(this.convertToEqualizer(SparkEnv$.MODULE$.get()).$eq$eq$eq(null));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        this.testQuietly("SPARK-18342: commit fails when rename fails", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String dir = new StringBuilder(3).append(RenameReturnsFalseFileSystem$.MODULE$.scheme()).append("://").append(StateStoreTestsHelper$.MODULE$.newDir()).toString();
            Configuration conf = new Configuration();
            conf.set(new StringBuilder(8).append("fs.").append(RenameReturnsFalseFileSystem$.MODULE$.scheme()).append(".impl").toString(), RenameReturnsFalseFileSystem.class.getName());
            long x$43 = Random$.MODULE$.nextInt();
            int x$44 = 0;
            String x$45 = dir;
            Configuration x$46 = conf;
            int x$47 = this.newStoreProvider$default$4();
            int x$48 = this.newStoreProvider$default$5();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$43, x$44, x$45, x$47, x$48, x$46);
            StateStore store = provider.getStore(0L);
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0);
            IllegalStateException e = (IllegalStateException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> store.commit(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
            String $org_scalatest_assert_macro_left = e.getCause().getMessage();
            String $org_scalatest_assert_macro_right = "Failed to rename";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
        });
        this.test("SPARK-18416: do not create temp delta file until the store is updated", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String dir = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeId = new StateStoreProviderId(new StateStoreId(dir, 0L, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            StateStoreConf storeConf = StateStoreConf$.MODULE$.empty();
            Configuration hadoopConf = new Configuration();
            File deltaFileDir = new File(new StringBuilder(5).append(dir).append("/0/0/").toString());
            StateStore store0 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 0L, storeConf, hadoopConf), deltaFileDir);
            StateStoreTestsHelper$.MODULE$.put(store0, "a", 1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
            store0.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
            StateStore store1 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 1L, storeConf, hadoopConf), deltaFileDir);
            StateStoreTestsHelper$.MODULE$.remove(store1, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$52(x$5)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 549));
            store1.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right8 = 2;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 554));
            StateStore store2 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 2L, storeConf, hadoopConf), deltaFileDir);
            store2.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right9 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right10 = 3;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
        this.test("SPARK-21145: Restarted queries create new provider instances", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            try {
                File checkpointLocation = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsoluteFile();
                SparkSession spark2 = SparkSession$.MODULE$.builder().master("local[2]").getOrCreate();
                SparkSession$.MODULE$.setActiveSession(spark2);
                SQLContext sqlContext = spark2.sqlContext();
                spark2.conf().set(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key(), "1");
                MemoryStream inputData = MemoryStream$.MODULE$.apply(spark2.implicits().newIntEncoder(), sqlContext);
                Seq loadedProvidersAfterRun1 = this.runQueryAndGetLoadedProviders$1(inputData, checkpointLocation);
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedProvidersAfterRun1.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                Seq loadedProvidersAfterRun2 = this.runQueryAndGetLoadedProviders$1(inputData, checkpointLocation);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedProvidersAfterRun2.length()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 601));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((StateStoreProvider)loadedProvidersAfterRun2.apply(0)).stateStoreId());
                StateStoreId $org_scalatest_assert_macro_right2 = ((StateStoreProvider)loadedProvidersAfterRun2.apply(1)).stateStoreId();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 604));
                StateStoreProvider $org_scalatest_assert_macro_left3 = (StateStoreProvider)loadedProvidersAfterRun2.apply(0);
                StateStoreProvider $org_scalatest_assert_macro_right3 = (StateStoreProvider)loadedProvidersAfterRun2.apply(1);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "ne", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 != $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 605));
            }
            finally {
                SparkSession$.MODULE$.getActiveSession().foreach((Function1 & Serializable & scala.Serializable)spark -> {
                    StateStoreSuite.$anonfun$new$55(spark);
                    return BoxedUnit.UNIT;
                });
            }
            return assertion;
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
        this.test("error writing [version].delta cancels the output stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration hadoopConf = new Configuration();
            hadoopConf.set(SQLConf$.MODULE$.STREAMING_CHECKPOINT_FILE_MANAGER_CLASS().parent().key(), CreateAtomicTestManager.class.getName());
            String remoteDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath();
            long x$49 = Random$.MODULE$.nextInt();
            int x$50 = 0;
            String x$51 = remoteDir;
            Configuration x$52 = hadoopConf;
            int x$53 = this.newStoreProvider$default$4();
            int x$54 = this.newStoreProvider$default$5();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$49, x$50, x$51, x$53, x$54, x$52);
            CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(false);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)version -> {
                StateStore store = provider.getStore((long)(version - 1));
                StateStoreTestsHelper$.MODULE$.put(store, ((Object)BoxesRunTime.boxToInteger((int)version)).toString(), version);
                return store.commit();
            });
            Set version10Data = ((TraversableOnce)((TraversableLike)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)10L)).map((Function1 & Serializable & scala.Serializable)x$7 -> StateStoreSuite.$anonfun$new$59(BoxesRunTime.unboxToLong((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), x), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
            CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic_$eq(false);
            StateStore store = provider.getStore(10L);
            CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(true);
            StateStoreTestsHelper$.MODULE$.put(store, "11", 11);
            IllegalStateException e = (IllegalStateException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)package$.MODULE$.quietly((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> store.commit())), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
            Throwable $org_scalatest_assert_macro_left = e.getCause();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "java.io.IOException", $org_scalatest_assert_macro_left instanceof IOException, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
            CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(false);
            CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic_$eq(false);
            StateStore store2 = provider.getStore(10L);
            StateStoreTestsHelper$.MODULE$.put(store2, "11", 11);
            store2.abort();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic(), "org.apache.spark.sql.execution.streaming.CreateAtomicTestManager.cancelCalledInCreateAtomic", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 649));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
        this.test("expose metrics with custom metrics to StateStoreMetrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long loadedMapSizeForVersion1And2;
            long loadedMapSizeForVersion1;
            long initialLoadedMapSize;
            HDFSBackedStateStoreProvider provider = this.newStoreProvider();
            Set<Tuple2<String, Object>> $org_scalatest_assert_macro_left = this.getLatestData(provider);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
            StateStore store = provider.getStore(0L);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(store.hasCommitted(), "store.hasCommitted", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store.metrics().numKeys()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 681));
            long $org_scalatest_assert_macro_left3 = initialLoadedMapSize = StateStoreSuite.getLoadedMapSizeMetric$1(store.metrics());
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 >= (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
            this.assertCacheHitAndMiss$1(store.metrics(), 0L, 0L);
            StateStoreTestsHelper$.MODULE$.put(store, "a", 1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store.metrics().numKeys()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
            StateStoreTestsHelper$.MODULE$.put(store, "b", 2);
            StateStoreTestsHelper$.MODULE$.put(store, "aa", 3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store.metrics().numKeys()));
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
            StateStoreTestsHelper$.MODULE$.remove(store, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.startsWith("a")));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store.metrics().numKeys()));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store.commit()));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(store.hasCommitted(), "store.hasCommitted", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 697));
            long $org_scalatest_assert_macro_left8 = loadedMapSizeForVersion1 = StateStoreSuite.getLoadedMapSizeMetric$1(store.metrics());
            long $org_scalatest_assert_macro_right7 = initialLoadedMapSize;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left8), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8 > $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
            this.assertCacheHitAndMiss$1(store.metrics(), 0L, 0L);
            StateStore storeV2 = provider.getStore(1L);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(storeV2.hasCommitted(), "storeV2.hasCommitted", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 704));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.metrics().numKeys()));
            int $org_scalatest_assert_macro_right8 = 1;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
            StateStoreTestsHelper$.MODULE$.put(storeV2, "cc", 4);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.metrics().numKeys()));
            int $org_scalatest_assert_macro_right9 = 2;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.commit()));
            int $org_scalatest_assert_macro_right10 = 2;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(storeV2.hasCommitted(), "storeV2.hasCommitted", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
            long $org_scalatest_assert_macro_left12 = loadedMapSizeForVersion1And2 = StateStoreSuite.getLoadedMapSizeMetric$1(storeV2.metrics());
            long $org_scalatest_assert_macro_right11 = loadedMapSizeForVersion1;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left12), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left12 > $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 714));
            this.assertCacheHitAndMiss$1(storeV2.metrics(), 1L, 0L);
            HDFSBackedStateStoreProvider reloadedProvider = this.newStoreProvider(store.id());
            StateStore reloadedStore = reloadedProvider.getStore(1L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)reloadedStore.metrics().numKeys()));
            int $org_scalatest_assert_macro_right12 = 1;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 721));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)StateStoreSuite.getLoadedMapSizeMetric$1(reloadedStore.metrics())));
            long $org_scalatest_assert_macro_right13 = loadedMapSizeForVersion1;
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
            this.assertCacheHitAndMiss$1(reloadedStore.metrics(), 0L, 1L);
            StateStore reloadedStoreV2 = reloadedProvider.getStore(2L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)reloadedStoreV2.metrics().numKeys()));
            int $org_scalatest_assert_macro_right14 = 2;
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729));
            long $org_scalatest_assert_macro_left16 = StateStoreSuite.getLoadedMapSizeMetric$1(reloadedStoreV2.metrics());
            long $org_scalatest_assert_macro_right15 = loadedMapSizeForVersion1;
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left16), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left16 > $org_scalatest_assert_macro_right15, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
            this.assertCacheHitAndMiss$1(reloadedStoreV2.metrics(), 0L, 2L);
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
    }
}

