/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.v2.V2SessionCatalog;
import org.apache.spark.sql.execution.datasources.v2.V2SessionCatalogBaseSuite;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001)3Aa\u0002\u0005\u0001/!)A\u0004\u0001C\u0001;!)q\u0004\u0001C)A!)q\u0005\u0001C)A!9\u0001\u0006\u0001b\u0001\n\u0013I\u0003B\u0002\u001a\u0001A\u0003%!\u0006C\u00034\u0001\u0011%AG\u0001\u000eWeM+7o]5p]\u000e\u000bG/\u00197pOR\u000b'\r\\3Tk&$XM\u0003\u0002\n\u0015\u0005\u0011aO\r\u0006\u0003\u00171\t1\u0002Z1uCN|WO]2fg*\u0011QBD\u0001\nKb,7-\u001e;j_:T!a\u0004\t\u0002\u0007M\fHN\u0003\u0002\u0012%\u0005)1\u000f]1sW*\u00111\u0003F\u0001\u0007CB\f7\r[3\u000b\u0003U\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eQR\"\u0001\u0005\n\u0005mA!!\u0007,3'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h\u0005\u0006\u001cXmU;ji\u0016\fa\u0001P5oSRtD#\u0001\u0010\u0011\u0005e\u0001\u0011!\u00032fM>\u0014X-\u00117m)\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#\u0001B+oSR\f\u0001\"\u00194uKJ\fE\u000e\\\u0001\ri\u0016\u001cH/\u00133f]RtUm^\u000b\u0002UA\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\bG\u0006$\u0018\r\\8h\u0015\tyc\"A\u0005d_:tWm\u0019;pe&\u0011\u0011\u0007\f\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018!\u0004;fgRLE-\u001a8u\u001d\u0016<\b%\u0001\u0010nC.,\u0017+^1mS\u001aLW\r\u001a)bi\"<\u0016\u000e\u001e5XCJ,\u0007n\\;tKR\u0011Q'\u0010\t\u0003mmj\u0011a\u000e\u0006\u0003qe\n1A\\3u\u0015\u0005Q\u0014\u0001\u00026bm\u0006L!\u0001P\u001c\u0003\u0007U\u0013\u0016\nC\u0003?\r\u0001\u0007q(\u0001\u0003qCRD\u0007C\u0001!H\u001d\t\tU\t\u0005\u0002CG5\t1I\u0003\u0002E-\u00051AH]8pizJ!AR\u0012\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\r\u000e\u0002")
public class V2SessionCatalogTableSuite
extends V2SessionCatalogBaseSuite {
    private final Identifier testIdentNew;

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
        V2SessionCatalog catalog = this.newCatalog();
        catalog.createNamespace((String[])((Object[])new String[]{"db"}), this.emptyProps());
        catalog.createNamespace((String[])((Object[])new String[]{"db2"}), this.emptyProps());
        catalog.createNamespace((String[])((Object[])new String[]{"ns"}), this.emptyProps());
        catalog.createNamespace((String[])((Object[])new String[]{"ns2"}), this.emptyProps());
    }

    @Override
    public void afterAll() {
        V2SessionCatalog catalog = this.newCatalog();
        catalog.dropNamespace((String[])((Object[])new String[]{"db"}));
        catalog.dropNamespace((String[])((Object[])new String[]{"db2"}));
        catalog.dropNamespace((String[])((Object[])new String[]{"ns"}));
        catalog.dropNamespace((String[])((Object[])new String[]{"ns2"}));
        SharedSparkSession.afterAll$(this);
    }

    private Identifier testIdentNew() {
        return this.testIdentNew;
    }

    private URI makeQualifiedPathWithWarehouse(String path) {
        Path p = new Path(this.spark().sessionState().conf().warehousePath(), path);
        FileSystem fs = p.getFileSystem(this.spark().sessionState().newHadoopConf());
        return fs.makeQualified(p).toUri();
    }

    public V2SessionCatalogTableSuite() {
        this.after((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.newCatalog().dropTable(this.testIdent());
            return this.newCatalog().dropTable(this.testIdentNew());
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.testIdentNew = Identifier.of((String[])this.testNs(), (String)"test_table_new");
        this.test("listTables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"test_table_1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"test_table_2");
            Identifier ident3 = Identifier.of((String[])((String[])((Object[])new String[]{"ns2"})), (String)"test_table_1");
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            catalog.createTable(ident1, this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Set $org_scalatest_assert_macro_left2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})))).toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident1}));
            Set set = $org_scalatest_assert_macro_left2;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns2"})));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left3).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            catalog.createTable(ident3, this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            catalog.createTable(ident2, this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Set $org_scalatest_assert_macro_left4 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})))).toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident1, ident2}));
            Set set3 = $org_scalatest_assert_macro_left4;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            Set $org_scalatest_assert_macro_left5 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns2"})))).toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident3}));
            Set set5 = $org_scalatest_assert_macro_left5;
            Set set6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            catalog.dropTable(ident1);
            Set $org_scalatest_assert_macro_left6 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})))).toSet();
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident2}));
            Set set7 = $org_scalatest_assert_macro_left6;
            Set set8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            catalog.dropTable(ident2);
            Object[] $org_scalatest_assert_macro_left7 = Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left7), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left7).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            Set $org_scalatest_assert_macro_left8 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns2"})))).toSet();
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident3}));
            Set set9 = $org_scalatest_assert_macro_left8;
            Set set10 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right5, !(set9 != null ? !set9.equals(set10) : set10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            return catalog.dropTable(ident3);
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("createTable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Seq parsed;
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Seq $org_scalatest_assert_macro_left = parsed = CatalystSqlParser$.MODULE$.parseMultipartIdentifier(table.name());
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "test_table"}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("createTable: with properties", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Seq parsed;
            V2SessionCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("property", "value");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            Seq $org_scalatest_assert_macro_left = parsed = CatalystSqlParser$.MODULE$.parseMultipartIdentifier(table.name());
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "test_table"}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            Map $org_scalatest_assert_macro_left3 = table.properties();
            HashMap<String, String> $org_scalatest_assert_macro_right3 = properties;
            Map map = $org_scalatest_assert_macro_left3;
            HashMap<String, String> hashMap = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", $org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(hashMap) : hashMap != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("createTable: table already exists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            TableAlreadyExistsException exc = (TableAlreadyExistsException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps()), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = table.name();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = "already exists";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("createTable: location", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            V1Table t1 = (V1Table)catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(t1.catalogTable().location());
            URI $org_scalatest_assert_macro_right = this.spark().sessionState().catalog().defaultTablePath(CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).asTableIdentifier());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            catalog.dropTable(this.testIdent());
            properties.put("location", "relative/path");
            V1Table t2 = (V1Table)catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(t2.catalogTable().location());
            URI $org_scalatest_assert_macro_right2 = this.makeQualifiedPathWithWarehouse("db.db/relative/path");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            catalog.dropTable(this.testIdent());
            properties.put("location", "/absolute/path");
            V1Table t3 = (V1Table)catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(t3.catalogTable().location().toString());
            String $org_scalatest_assert_macro_right3 = "file:/absolute/path";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("tableExists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("loadTable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Table loaded = catalog.loadTable(this.testIdent());
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = loaded.name();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = loaded.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            Map $org_scalatest_assert_macro_left3 = table.properties();
            Map $org_scalatest_assert_macro_right3 = loaded.properties();
            Map map = $org_scalatest_assert_macro_left3;
            Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        this.test("loadTable: table does not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.loadTable(this.testIdent()), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223))));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = "not found";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("invalidateTable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            catalog.invalidateTable(this.testIdent());
            Table loaded = catalog.loadTable(this.testIdent());
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = loaded.name();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = loaded.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
            Map $org_scalatest_assert_macro_left3 = table.properties();
            Map $org_scalatest_assert_macro_right3 = loaded.properties();
            Map map = $org_scalatest_assert_macro_left3;
            Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        this.test("invalidateTable: table does not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.tableExists(this.testIdent())));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            catalog.invalidateTable(this.testIdent());
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        this.test("alterTable: add property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop-1", (String)"1")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        this.test("alterTable: add property to existing", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("prop-1", "1");
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop-2", (String)"2")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-2"), (Object)"2")}));
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-2"), (Object)"2")}));
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        this.test("alterTable: remove existing property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("prop-1", "1");
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.removeProperty((String)"prop-1")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        this.test("alterTable: remove missing property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.removeProperty((String)"prop-1")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        this.test("alterTable: add top-level column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$)}));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema().add("ts", (DataType)TimestampType$.MODULE$);
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("alterTable: add required column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$, (boolean)false)}));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema().add("ts", (DataType)TimestampType$.MODULE$, false);
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        this.test("alterTable: add column with comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$, (boolean)false, (String)"comment text")}));
            StructField field = new StructField("ts", (DataType)TimestampType$.MODULE$, false, StructField$.MODULE$.apply$default$4()).withComment("comment text");
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema().add(field);
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        this.test("alterTable: add nested column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"point", "z"})), (DataType)DoubleType$.MODULE$)}));
            StructType expectedSchema = this.schema().add("point", (DataType)pointStruct.add("z", (DataType)DoubleType$.MODULE$));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
        this.test("alterTable: add column to primitive field fails", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"data", "ts"})), (DataType)TimestampType$.MODULE$)})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "Not a struct";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "data";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            StructType $org_scalatest_assert_macro_left4 = catalog.loadTable(this.testIdent()).schema();
            StructType $org_scalatest_assert_macro_right4 = this.schema();
            StructType structType3 = $org_scalatest_assert_macro_left4;
            StructType structType4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        this.test("alterTable: add field to missing column fails", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"missing_col", "new_field"})), (DataType)StringType$.MODULE$)})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        this.test("alterTable: update column data type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnType((String[])((String[])((Object[])new String[]{"id"})), (DataType)LongType$.MODULE$)}));
            StructType expectedSchema = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        this.test("alterTable: update column nullability", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType originalSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("data", (DataType)StringType$.MODULE$);
            Table table = catalog.createTable(this.testIdent(), originalSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = originalSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnNullability((String[])((String[])((Object[])new String[]{"id"})), (boolean)true)}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
        this.test("alterTable: update missing column fails", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnType((String[])((String[])((Object[])new String[]{"missing_col"})), (DataType)LongType$.MODULE$)})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
        this.test("alterTable: add comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"comment text")}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, true, "comment text").add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
        this.test("alterTable: replace comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
            catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"comment text")}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, true, "replacement comment").add("data", (DataType)StringType$.MODULE$);
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"replacement comment")}));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
        this.test("alterTable: add comment to missing column fails", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"missing_col"})), (String)"comment")})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
        this.test("alterTable: rename top-level column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"id"})), (String)"some_id")}));
            StructType expectedSchema = new StructType().add("some_id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
        this.test("alterTable: rename nested column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "x"})), (String)"first")}));
            StructType newPointStruct = new StructType().add("first", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("point", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
        this.test("alterTable: rename struct column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point"})), (String)"p")}));
            StructType newPointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("p", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
        this.test("alterTable: rename missing column fails", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"missing_col"})), (String)"new_name")})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 574));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 575));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
        this.test("alterTable: multiple changes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "x"})), (String)"first"), TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "y"})), (String)"second")}));
            StructType newPointStruct = new StructType().add("first", (DataType)DoubleType$.MODULE$).add("second", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("point", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
        this.test("alterTable: delete top-level column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"id"})))}));
            StructType expectedSchema = new StructType().add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 609));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 598));
        this.test("alterTable: delete nested column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"point", "y"})))}));
            StructType newPointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("point", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
        this.test("alterTable: delete missing column fails", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"missing_col"})))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 643));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
        this.test("alterTable: delete missing nested column fails", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 654));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"point", "z"})))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "z";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 661));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 646));
        this.test("alterTable: table does not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop", (String)"val")})), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667))));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = "not found";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
        this.test("alterTable: location", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
            V1Table t1 = (V1Table)catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(t1.catalogTable().location());
            URI $org_scalatest_assert_macro_right = this.spark().sessionState().catalog().defaultTablePath(CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).asTableIdentifier());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 681));
            V1Table t2 = (V1Table)catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"location", (String)"relative/path")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(t2.catalogTable().location());
            URI $org_scalatest_assert_macro_right2 = this.makeQualifiedPathWithWarehouse("db.db/relative/path");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 687));
            V1Table t3 = (V1Table)catalog.alterTable(this.testIdent(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"location", (String)"/absolute/path")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(t3.catalogTable().location().toString());
            String $org_scalatest_assert_macro_right3 = "file:/absolute/path";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
        this.test("dropTable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702));
            boolean wasDropped = catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(wasDropped, "wasDropped", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
        this.test("dropTable: table does not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
            boolean wasDropped = catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(wasDropped, "wasDropped", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 710));
        this.test("renameTable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdentNew)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729));
            catalog.renameTable(this.testIdent(), this.testIdentNew());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 732));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdentNew)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 733));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 721));
        this.test("renameTable: fail if table does not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renameTable(this.testIdent(), this.testIdentNew()), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 739))));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = "not found";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 736));
        this.test("renameTable: fail if new table name already exists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 750));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdentNew)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 751));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            catalog.createTable(this.testIdentNew(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdentNew)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
            TableAlreadyExistsException exc = (TableAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renameTable(this.testIdent(), this.testIdentNew()), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 759));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdentNew()).quoted();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = "already exists";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        this.test("renameTable: fail if db does not match for old and new table names", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Identifier testIdentNewOtherDb = Identifier.of((String[])((String[])((Object[])new String[]{"db2"})), (String)"test_table_new");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 771));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(testIdentNewOtherDb), "catalog.tableExists(testIdentNewOtherDb)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 772));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 776));
            AnalysisException exc = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renameTable(this.testIdent(), testIdentNewOtherDb), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778))));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testIdent().namespace()).quoted();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = CatalogV2Implicits$.MODULE$.NamespaceHelper(testIdentNewOtherDb.namespace()).quoted();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 783));
            String $org_scalatest_assert_macro_left3 = exc.message();
            String $org_scalatest_assert_macro_right3 = "RENAME TABLE source and destination databases do not match";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 784));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
    }
}

