/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc.connection;

import java.sql.Driver;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.connection.ConnectionProviderSuiteBase;
import org.apache.spark.sql.execution.datasources.jdbc.connection.MSSQLConnectionProvider;
import org.apache.spark.sql.execution.datasources.jdbc.connection.SecureConnectionProvider;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m2Aa\u0001\u0003\u0001+!)!\u0004\u0001C\u00017!)Q\u0004\u0001C\u0005=\taRjU*R\u0019\u000e{gN\\3di&|g\u000e\u0015:pm&$WM]*vSR,'BA\u0003\u0007\u0003)\u0019wN\u001c8fGRLwN\u001c\u0006\u0003\u000f!\tAA\u001b3cG*\u0011\u0011BC\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\f\u0019\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u001b9\t1a]9m\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\r\u000e\u0003\u0011I!!\u0007\u0003\u00037\r{gN\\3di&|g\u000e\u0015:pm&$WM]*vSR,')Y:f\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u0018\u0001\u0005iA/Z:u!J|g/\u001b3feN$RaH\u0013/ge\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012A!\u00168ji\")aE\u0001a\u0001O\u00051AM]5wKJ\u0004\"\u0001\u000b\u0017\u000e\u0003%R!!\u0004\u0016\u000b\u0003-\nAA[1wC&\u0011Q&\u000b\u0002\u0007\tJLg/\u001a:\t\u000b=\u0012\u0001\u0019\u0001\u0019\u0002\u0011A\u0014xN^5eKJ\u0004\"aF\u0019\n\u0005I\"!\u0001G*fGV\u0014XmQ8o]\u0016\u001cG/[8o!J|g/\u001b3fe\")AG\u0001a\u0001k\u0005qA-\u001a4bk2$x\n\u001d;j_:\u001c\bC\u0001\u001c8\u001b\u00051\u0011B\u0001\u001d\u0007\u0005-QEIQ\"PaRLwN\\:\t\u000bi\u0012\u0001\u0019A\u001b\u0002\u001b\r,8\u000f^8n\u001fB$\u0018n\u001c8t\u0001")
public class MSSQLConnectionProviderSuite
extends ConnectionProviderSuiteBase {
    private void testProviders(Driver driver, SecureConnectionProvider provider, JDBCOptions defaultOptions, JDBCOptions customOptions) {
        this.testSecureConnectionProvider(provider, driver, defaultOptions);
        this.testSecureConnectionProvider(provider, driver, customOptions);
    }

    public MSSQLConnectionProviderSuite() {
        this.test("setAuthenticationConfigIfNeeded default parser must set authentication if not set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            MSSQLConnectionProvider provider = new MSSQLConnectionProvider();
            Driver driver = this.registerDriver(provider.driverClass());
            this.testProviders(driver, (SecureConnectionProvider)provider, this.options("jdbc:sqlserver://localhost/mssql"), this.options("jdbc:sqlserver://localhost/mssql;jaasConfigurationName=custommssql"));
        }, new Position("MSSQLConnectionProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 25));
        this.test("setAuthenticationConfigIfNeeded custom parser must set authentication if not set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            MSSQLConnectionProvider provider = new MSSQLConnectionProvider(null){
                private final String parserMethod;

                public String parserMethod() {
                    return this.parserMethod;
                }
                {
                    this.parserMethod = "IntentionallyNotExistingMethod";
                }
            };
            Driver driver = this.registerDriver(provider.driverClass());
            this.testProviders(driver, (SecureConnectionProvider)provider, this.options("jdbc:sqlserver://localhost/mssql"), this.options("jdbc:sqlserver://localhost/mssql;jaasConfigurationName=custommssql"));
        }, new Position("MSSQLConnectionProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
    }
}

