/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.ModifiedDateFilter$;
import org.apache.spark.sql.execution.datasources.PathFilterSuite$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\u0006\f\u0001aAQa\t\u0001\u0005\u0002\u0011BQa\n\u0001\u0005\n!Bq!\u0019\u0001\u0012\u0002\u0013%!\rC\u0004n\u0001E\u0005I\u0011\u00022\t\u000b9\u0004A\u0011B8\t\u000ba\u0004A\u0011B=\t\u000by\u0004A\u0011B@\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006!9\u00111\u0003\u0001\u0005\n\u0005U!a\u0004)bi\"4\u0015\u000e\u001c;feN+\u0018\u000e^3\u000b\u00051i\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!AD\b\u0002\u0013\u0015DXmY;uS>t'B\u0001\t\u0012\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO\u000e\u00011c\u0001\u0001\u001a;A\u0011!dG\u0007\u0002\u001f%\u0011Ad\u0004\u0002\n#V,'/\u001f+fgR\u0004\"AH\u0011\u000e\u0003}Q!\u0001I\b\u0002\tQ,7\u000f^\u0005\u0003E}\u0011!c\u00155be\u0016$7\u000b]1sWN+7o]5p]\u00061A(\u001b8jiz\"\u0012!\n\t\u0003M\u0001i\u0011aC\u0001\fKb,7-\u001e;f)\u0016\u001cH\u000f\u0006\u0004*_ej%k\u0018\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0005+:LG\u000fC\u00031\u0005\u0001\u0007\u0011'A\u0002eSJ\u0004\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\u0005%|'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012AAR5mK\")!H\u0001a\u0001w\u0005Ia-\u001b7f\t\u0006$Xm\u001d\t\u0004y\u0011;eBA\u001fC\u001d\tq\u0014)D\u0001@\u0015\t\u0001u#\u0001\u0004=e>|GOP\u0005\u0002Y%\u00111iK\u0001\ba\u0006\u001c7.Y4f\u0013\t)eIA\u0002TKFT!aQ\u0016\u0011\u0005![U\"A%\u000b\u0005)+\u0014\u0001\u0002;j[\u0016L!\u0001T%\u0003\u001b1{7-\u00197ECR,G+[7f\u0011\u0015q%\u00011\u0001P\u00035)\u0007\u0010]3di\u0016$7i\\;oiB\u0011!\u0006U\u0005\u0003#.\u0012A\u0001T8oO\"91K\u0001I\u0001\u0002\u0004!\u0016AD7pI&4\u0017.\u001a3CK\u001a|'/\u001a\t\u0004UU;\u0016B\u0001,,\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001\f\u0018\b\u00033j\u0003\"AP\u0016\n\u0005m[\u0013A\u0002)sK\u0012,g-\u0003\u0002^=\n11\u000b\u001e:j]\u001eT!aW\u0016\t\u000f\u0001\u0014\u0001\u0013!a\u0001)\u0006iQn\u001c3jM&,G-\u00114uKJ\fQ#\u001a=fGV$X\rV3ti\u0012\"WMZ1vYR$C'F\u0001dU\t!FmK\u0001f!\t17.D\u0001h\u0015\tA\u0017.A\u0005v]\u000eDWmY6fI*\u0011!nK\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00017h\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016Kb,7-\u001e;f)\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003a)\u00070Z2vi\u0016$Vm\u001d;XSRD')\u00193PaRLwN\u001c\u000b\u0004SA,\b\"B9\u0006\u0001\u0004\u0011\u0018aB8qi&|gn\u001d\t\u00051N<v+\u0003\u0002u=\n\u0019Q*\u00199\t\u000bY,\u0001\u0019A<\u0002!\u0015D\b/Z2uK\u0012l5o\u001a)beR\u001c\bc\u0001\u001fE/\u0006\u0011C/Z:u\u001b>$\u0017NZ5fI\u0012\u000bG/\u001a$jYR,'oV5uQRKW.\u001a>p]\u0016$2!\u000b>}\u0011\u0015Yh\u00011\u0001X\u0003)!\u0018.\\3{_:,\u0017\n\u001a\u0005\u0006{\u001a\u0001\raV\u0001\u0010M&dG/\u001a:QCJ\fWNT1nK\u0006\u00012M]3bi\u0016\u001c\u0016N\\4mK\u001aKG.\u001a\u000b\u0004c\u0005\u0005\u0001\"\u0002\u0019\b\u0001\u0004\t\u0014aC:fi\u001aKG.\u001a+j[\u0016$b!a\u0002\u0002\u000e\u0005=\u0001c\u0001\u0016\u0002\n%\u0019\u00111B\u0016\u0003\u000f\t{w\u000e\\3b]\")!\n\u0003a\u0001\u000f\"1\u0011\u0011\u0003\u0005A\u0002E\nAAZ5mK\u0006Qam\u001c:nCR$\u0016.\\3\u0015\u0007]\u000b9\u0002C\u0003K\u0013\u0001\u0007q\t")
public class PathFilterSuite
extends QueryTest
implements SharedSparkSession {
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$(this, f);
    }

    @Override
    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$(this, testName, f);
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$(this, testName, testTags, testFun, pos);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$(this, numPaths, f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        SQLHelper.withSQLConf$((SQLHelper)this, (Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions2, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$(this, cacheNames, f);
    }

    @Override
    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$(this, tableName);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$(this, namespaces, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    @Override
    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$(this, file);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.calendarIntervalData;
    }

    @Override
    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.calendarIntervalData$lzycompute() : this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x8000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    private void executeTest(File dir, Seq<LocalDateTime> fileDates, long expectedCount, Option<String> modifiedBefore, Option<String> modifiedAfter) {
        fileDates.foreach((Function1 & Serializable & scala.Serializable)fileDate -> BoxesRunTime.boxToBoolean((boolean)PathFilterSuite.$anonfun$executeTest$1(this, dir, fileDate)));
        StructType schema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        ObjectRef dfReader = ObjectRef.create((Object)this.spark().read().format("csv").option("timeZone", "UTC").schema(schema));
        modifiedBefore.foreach((Function1 & Serializable & scala.Serializable)opt -> {
            dfReader.elem = ((DataFrameReader)dfReader.elem).option("modifiedBefore", opt);
            return BoxedUnit.UNIT;
        });
        modifiedAfter.foreach((Function1 & Serializable & scala.Serializable)opt -> {
            dfReader.elem = ((DataFrameReader)dfReader.elem).option("modifiedAfter", opt);
            return BoxedUnit.UNIT;
        });
        if (expectedCount > 0L) {
            Dataset df1 = ((DataFrameReader)dfReader.elem).load(dir.getCanonicalPath());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df1.count()));
            long $org_scalatest_assert_macro_right = expectedCount;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            Dataset df2 = ((DataFrameReader)dfReader.elem).option("pathGlobFilter", "*.csv").load(dir.getCanonicalPath());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df2.count()));
            long $org_scalatest_assert_macro_right2 = expectedCount;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            Dataset df3 = ((DataFrameReader)dfReader.elem).option("pathGlobFilter", "*.txt").load(dir.getCanonicalPath());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df3.count()));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        } else {
            Dataset df = ((DataFrameReader)dfReader.elem).load(dir.getCanonicalPath());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        }
    }

    private Option<String> executeTest$default$4() {
        return None$.MODULE$;
    }

    private Option<String> executeTest$default$5() {
        return None$.MODULE$;
    }

    private void executeTestWithBadOption(Map<String, String> options, Seq<String> expectedMsgParts) {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$executeTestWithBadOption$1(this, options, expectedMsgParts, dir);
            return BoxedUnit.UNIT;
        });
    }

    private void testModifiedDateFilterWithTimezone(String timezoneId, String filterParamName) {
        LocalDateTime curTime = LocalDateTime.now(ZoneOffset.UTC);
        ZoneId zoneId = DateTimeUtils$.MODULE$.getTimeZone(timezoneId).toZoneId();
        long strategyTimeInMicros = ModifiedDateFilter$.MODULE$.toThreshold(curTime.toString(), timezoneId, filterParamName);
        long strategyTimeInSeconds = strategyTimeInMicros / 1000L / 1000L;
        long curTimeAsSeconds = curTime.atZone(zoneId).toEpochSecond();
        this.withClue(new StringBuilder(21).append("timezone: ").append(timezoneId).append(" / param: ").append(filterParamName).append(",").toString(), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)strategyTimeInSeconds));
            long $org_scalatest_assert_macro_right = curTimeAsSeconds;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        });
    }

    private File createSingleFile(File dir) {
        File file = new File(dir, new StringBuilder(8).append("temp").append(Random$.MODULE$.nextInt(1000000)).append(".csv").toString());
        return org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(file, "text");
    }

    private boolean setFileTime(LocalDateTime time, File file) {
        long sameTime = time.toEpochSecond(ZoneOffset.UTC);
        return file.setLastModified(sameTime * 1000L);
    }

    private String formatTime(LocalDateTime time) {
        return time.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
    }

    private final void testImplicits$lzycompute$1() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        PathFilterSuite pathFilterSuite = this;
        synchronized (pathFilterSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(PathFilterSuite $this, File dir) {
        LocalDateTime curTime = LocalDateTime.now(ZoneOffset.UTC);
        $this.executeTest(dir, (Seq<LocalDateTime>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{curTime}))), 0L, (Option<String>)new Some((Object)$this.formatTime(curTime)), $this.executeTest$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$4(PathFilterSuite $this, File dir) {
        LocalDateTime curTime = LocalDateTime.now(ZoneOffset.UTC);
        File x$1 = dir;
        Seq x$2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{curTime}));
        long x$3 = 0L;
        Some x$4 = new Some((Object)$this.formatTime(curTime));
        Option<String> x$5 = $this.executeTest$default$4();
        $this.executeTest(x$1, (Seq<LocalDateTime>)x$2, x$3, x$5, (Option<String>)x$4);
    }

    public static final /* synthetic */ void $anonfun$new$6(PathFilterSuite $this, File dir) {
        LocalDateTime curTime = LocalDateTime.now(ZoneOffset.UTC);
        String formattedTime = $this.formatTime(curTime);
        $this.executeTest(dir, (Seq<LocalDateTime>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{curTime}))), 0L, (Option<String>)new Some((Object)formattedTime), (Option<String>)new Some((Object)formattedTime));
    }

    public static final /* synthetic */ void $anonfun$new$8(PathFilterSuite $this, File dir) {
        LocalDateTime curTime = LocalDateTime.now(ZoneOffset.UTC);
        LocalDateTime fileTime = curTime.minusDays(3L);
        String formattedTime = $this.formatTime(curTime);
        $this.executeTest(dir, (Seq<LocalDateTime>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{fileTime}))), 0L, (Option<String>)new Some((Object)formattedTime), (Option<String>)new Some((Object)formattedTime));
    }

    public static final /* synthetic */ void $anonfun$new$10(PathFilterSuite $this, File dir) {
        LocalDateTime curTime = LocalDateTime.now(ZoneOffset.UTC);
        String formattedTime = $this.formatTime(curTime);
        $this.executeTest(dir, (Seq<LocalDateTime>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{curTime}))), 0L, (Option<String>)new Some((Object)formattedTime), (Option<String>)new Some((Object)formattedTime));
    }

    public static final /* synthetic */ void $anonfun$new$12(PathFilterSuite $this, File dir) {
        LocalDateTime curTime = LocalDateTime.now(ZoneOffset.UTC);
        LocalDateTime pastTime = curTime.minusYears(1L);
        String formattedTime = $this.formatTime(pastTime);
        File x$6 = dir;
        Seq x$7 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{curTime}));
        long x$8 = 1L;
        Some x$9 = new Some((Object)formattedTime);
        Option<String> x$10 = $this.executeTest$default$4();
        $this.executeTest(x$6, (Seq<LocalDateTime>)x$7, x$8, x$10, (Option<String>)x$9);
    }

    public static final /* synthetic */ void $anonfun$new$14(PathFilterSuite $this, File dir) {
        LocalDateTime curTime = LocalDateTime.now(ZoneOffset.UTC);
        LocalDateTime futureTime = curTime.plusYears(1L);
        String formattedTime = $this.formatTime(futureTime);
        $this.executeTest(dir, (Seq<LocalDateTime>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{curTime}))), 1L, (Option<String>)new Some((Object)formattedTime), $this.executeTest$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$16(PathFilterSuite $this, File dir) {
        LocalDateTime curTime = LocalDateTime.now(ZoneOffset.UTC);
        LocalDateTime pastTime = curTime.minusYears(1L);
        String formattedTime = $this.formatTime(pastTime);
        $this.executeTest(dir, (Seq<LocalDateTime>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{curTime}))), 0L, (Option<String>)new Some((Object)formattedTime), $this.executeTest$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$18(PathFilterSuite $this, File dir) {
        LocalDateTime fileTime1 = LocalDateTime.now(ZoneOffset.UTC);
        LocalDateTime fileTime2 = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
        LocalDateTime pastTime = fileTime1.minusYears(1L);
        String formattedTime = $this.formatTime(pastTime);
        File x$11 = dir;
        Seq x$12 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{fileTime1, fileTime2}));
        long x$13 = 1L;
        Some x$14 = new Some((Object)formattedTime);
        Option<String> x$15 = $this.executeTest$default$4();
        $this.executeTest(x$11, (Seq<LocalDateTime>)x$12, x$13, x$15, (Option<String>)x$14);
    }

    public static final /* synthetic */ void $anonfun$new$20(PathFilterSuite $this, File dir) {
        LocalDateTime curTime = LocalDateTime.now(ZoneOffset.UTC);
        LocalDateTime pastTime = curTime.minusYears(1L);
        String formattedTime = $this.formatTime(pastTime);
        File x$16 = dir;
        Seq x$17 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{curTime, curTime}));
        long x$18 = 2L;
        Some x$19 = new Some((Object)formattedTime);
        Option<String> x$20 = $this.executeTest$default$4();
        $this.executeTest(x$16, (Seq<LocalDateTime>)x$17, x$18, x$20, (Option<String>)x$19);
    }

    public static final /* synthetic */ void $anonfun$new$22(PathFilterSuite $this, File dir) {
        LocalDateTime fileTime = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
        LocalDateTime pastTime = LocalDateTime.now(ZoneOffset.UTC).minusYears(1L);
        String formattedTime = $this.formatTime(pastTime);
        File x$21 = dir;
        Seq x$22 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{fileTime, fileTime}));
        long x$23 = 0L;
        Some x$24 = new Some((Object)formattedTime);
        Option<String> x$25 = $this.executeTest$default$4();
        $this.executeTest(x$21, (Seq<LocalDateTime>)x$22, x$23, x$25, (Option<String>)x$24);
    }

    public static final /* synthetic */ void $anonfun$new$24(PathFilterSuite $this, File dir) {
        LocalDateTime fileTime = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
        LocalDateTime futureTime = LocalDateTime.now(ZoneOffset.UTC).plusYears(1L);
        String formattedTime = $this.formatTime(futureTime);
        $this.executeTest(dir, (Seq<LocalDateTime>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{fileTime, fileTime}))), 2L, (Option<String>)new Some((Object)formattedTime), $this.executeTest$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$26(PathFilterSuite $this, File dir) {
        LocalDateTime curTime = LocalDateTime.now(ZoneOffset.UTC);
        LocalDateTime fileTime1 = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
        LocalDateTime fileTime2 = curTime.plusDays(3L);
        String formattedTime = $this.formatTime(curTime);
        $this.executeTest(dir, (Seq<LocalDateTime>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{fileTime1, fileTime2}))), 1L, (Option<String>)new Some((Object)formattedTime), $this.executeTest$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$28(PathFilterSuite $this, File dir) {
        LocalDateTime fileTime = LocalDateTime.now(ZoneOffset.UTC).minusDays(1L);
        String formattedTime = $this.formatTime(fileTime);
        $this.executeTest(dir, (Seq<LocalDateTime>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{fileTime, fileTime}))), 0L, (Option<String>)new Some((Object)formattedTime), $this.executeTest$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$32(PathFilterSuite $this, String filterName) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CET", "HST"}))).foreach((Function1 & Serializable & scala.Serializable)tzId -> {
            $this.testModifiedDateFilterWithTimezone(tzId, filterName);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$35(PathFilterSuite $this, File path) {
        String dataDir = path.getCanonicalPath();
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), $this.testImplicits().newStringEncoder()).toDS().write().text(dataDir);
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})), $this.testImplicits().newStringEncoder()).toDS().write().mode("append").orc(dataDir);
        Dataset df = $this.spark().read().option("pathGlobFilter", "*.txt").text(dataDir);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"foo"})));
        Dataset df2 = $this.spark().read().option("pathGlobFilter", "*.txt").text(new StringBuilder(6).append(dataDir).append("/*.orc").toString());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df2, (Seq<Row>)((Seq)Seq$.MODULE$.empty()));
        Dataset df3 = $this.spark().read().option("pathGlobFilter", "*.txt").text(new StringBuilder(4).append(dataDir).append("/*xt").toString());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df3, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"foo"})));
    }

    public static final /* synthetic */ void $anonfun$new$40(PathFilterSuite $this, File path) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(PathFilterSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_PathFilterSuite$$typecreator17$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_execution_datasources_PathFilterSuite$$typecreator17$1(PathFilterSuite $outer) {
            }
        }
        Dataset input = $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"foo", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"oof", (Object)BoxesRunTime.boxToInteger((int)2))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_PathFilterSuite$$typecreator17$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
        input.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).text(path.getCanonicalPath());
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})), $this.testImplicits().newStringEncoder()).toDS().write().mode("append").orc(new StringBuilder(4).append(path.getCanonicalPath()).append("/b=1").toString());
        Dataset df = $this.spark().read().text(new StringBuilder(8).append(path.getCanonicalPath()).append("/*/*.txt").toString());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Dataset<Row>)input.select("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
        Dataset df2 = $this.spark().read().option("pathGlobFilter", "*.txt").text(path.getCanonicalPath());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df2, (Dataset<Row>)input);
    }

    public static final /* synthetic */ boolean $anonfun$executeTest$1(PathFilterSuite $this, File dir$1, LocalDateTime fileDate) {
        File file = $this.createSingleFile(dir$1);
        return $this.setFileTime(fileDate, file);
    }

    public static final /* synthetic */ void $anonfun$executeTestWithBadOption$3(ObjectRef dfReader$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        dfReader$2.elem = ((DataFrameReader)dfReader$2.elem).option(key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$executeTestWithBadOption$1(PathFilterSuite $this, Map options$1, Seq expectedMsgParts$1, File dir) {
        $this.createSingleFile(dir);
        AnalysisException exc = (AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            ObjectRef dfReader = ObjectRef.create((Object)$this.spark().read().format("csv"));
            options$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                PathFilterSuite.$anonfun$executeTestWithBadOption$3(dfReader, x0$1);
                return BoxedUnit.UNIT;
            });
            return ((DataFrameReader)dfReader.elem).load(dir.getCanonicalPath());
        }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        expectedMsgParts$1.foreach((Function1 & Serializable & scala.Serializable)msg -> {
            String $org_scalatest_assert_macro_left = exc.getMessage();
            String $org_scalatest_assert_macro_right = msg;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        });
    }

    public PathFilterSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.test("SPARK-31962: modifiedBefore specified and sharing same timestamp with file last modified time.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$2(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("SPARK-31962: modifiedAfter specified and sharing same timestamp with file last modified time.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$4(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("SPARK-31962: modifiedBefore and modifiedAfter option share same timestamp with file last modified time.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$6(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("SPARK-31962: modifiedBefore and modifiedAfter option share same timestamp with earlier file last modified time.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$8(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("SPARK-31962: modifiedBefore and modifiedAfter option share same timestamp with later file last modified time.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$10(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("SPARK-31962: when modifiedAfter specified with a past date", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$12(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("SPARK-31962: when modifiedBefore specified with a future date", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$14(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("SPARK-31962: with modifiedBefore option provided using a past date", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$16(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("SPARK-31962: modifiedAfter specified with a past date, multiple files, one valid", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$18(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("SPARK-31962: modifiedAfter specified with a past date, multiple files, both valid", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$20(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("SPARK-31962: modifiedAfter specified with a past date, multiple files, none valid", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$22(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("SPARK-31962: modifiedBefore specified with a future date, multiple files, both valid", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$24(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("SPARK-31962: modifiedBefore specified with a future date, multiple files, one valid", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$26(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        this.test("SPARK-31962: modifiedBefore specified with a future date, multiple files, none valid", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PathFilterSuite.$anonfun$new$28(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("SPARK-31962: modifiedBefore/modifiedAfter is specified with an invalid date", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.executeTestWithBadOption((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modifiedBefore"), (Object)"2024-05+1 01:00:00")}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The timestamp provided", "modifiedbefore", "2024-05+1 01:00:00"}))));
            this.executeTestWithBadOption((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modifiedAfter"), (Object)"2024-05+1 01:00:00")}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The timestamp provided", "modifiedafter", "2024-05+1 01:00:00"}))));
        }, new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("SPARK-31962: modifiedBefore/modifiedAfter - empty option", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.executeTestWithBadOption((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modifiedBefore"), (Object)"")}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The timestamp provided", "modifiedbefore"}))));
            this.executeTestWithBadOption((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modifiedAfter"), (Object)"")}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The timestamp provided", "modifiedafter"}))));
        }, new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("SPARK-31962: modifiedBefore/modifiedAfter filter takes into account local timezone when specified as an option.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"modifiedbefore", "modifiedafter"}))).foreach((Function1 & Serializable & scala.Serializable)filterName -> {
            PathFilterSuite.$anonfun$new$32(this, filterName);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("Option pathGlobFilter: filter files correctly", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            PathFilterSuite.$anonfun$new$35(this, path);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test("Option pathGlobFilter: simple extension filtering should contains partition info", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            PathFilterSuite.$anonfun$new$40(this, path);
            return BoxedUnit.UNIT;
        }), new Position("PathFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
    }
}

