/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStats;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStatsTracker;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\r\u001b\u0001\u001dBQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013%\u0011\u0007\u0003\u0004;\u0001\u0001\u0006IA\r\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u0011\u0019)\u0005\u0001)A\u0005{!9a\t\u0001b\u0001\n\u00139\u0005BB'\u0001A\u0003%\u0001\nC\u0004O\u0001\t\u0007I\u0011B(\t\rM\u0003\u0001\u0015!\u0003Q\u0011\u001d!\u0006A1A\u0005\nUCaa\u0018\u0001!\u0002\u00131\u0006b\u00021\u0001\u0005\u0004%I!\u0016\u0005\u0007C\u0002\u0001\u000b\u0011\u0002,\t\u000f\t\u0004!\u0019!C\u0005G\"1q\r\u0001Q\u0001\n\u0011Dq\u0001\u001b\u0001C\u0002\u0013%1\r\u0003\u0004j\u0001\u0001\u0006I\u0001\u001a\u0005\u0006U\u0002!\tf\u001b\u0005\u0006_\u0002!I\u0001\u001d\u0005\u0006u\u0002!Ia\u001f\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017Aq!a\b\u0001\t\u0013\t\t\u0003C\u0004\u0002&\u0001!I!a\n\u0003?\t\u000b7/[2Xe&$X\rV1tWN#\u0018\r^:Ue\u0006\u001c7.\u001a:Tk&$XM\u0003\u0002\u001c9\u0005YA-\u0019;bg>,(oY3t\u0015\tib$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0004I\u0001\u0004gFd'BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u000b\t\u0003S)j\u0011\u0001I\u0005\u0003W\u0001\u0012Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001/!\ty\u0003!D\u0001\u001b\u0003\u001d!X-\u001c9ESJ,\u0012A\r\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\n!![8\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u0005\r&dW-\u0001\u0005uK6\u0004H)\u001b:!\u0003-!X-\u001c9ESJ\u0004\u0016\r\u001e5\u0016\u0003u\u0002\"AP\"\u000e\u0003}R!\u0001Q!\u0002\u0005\u0019\u001c(B\u0001\"#\u0003\u0019A\u0017\rZ8pa&\u0011Ai\u0010\u0002\u0005!\u0006$\b.\u0001\u0007uK6\u0004H)\u001b:QCRD\u0007%\u0001\u0003d_:4W#\u0001%\u0011\u0005%[U\"\u0001&\u000b\u0005\u0019\u000b\u0015B\u0001'K\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006)1m\u001c8gA\u00059An\\2bY\u001a\u001cX#\u0001)\u0011\u0005y\n\u0016B\u0001*@\u0005)1\u0015\u000e\\3TsN$X-\\\u0001\tY>\u001c\u0017\r\u001c4tA\u0005)A-\u0019;bcU\ta\u000bE\u0002X5rk\u0011\u0001\u0017\u0006\u00023\u0006)1oY1mC&\u00111\f\u0017\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003/vK!A\u0018-\u0003\t\tKH/Z\u0001\u0007I\u0006$\u0018-\r\u0011\u0002\u000b\u0011\fG/\u0019\u001a\u0002\r\u0011\fG/\u0019\u001a!\u0003\u0011aWM\\\u0019\u0016\u0003\u0011\u0004\"aV3\n\u0005\u0019D&aA%oi\u0006)A.\u001a82A\u0005!A.\u001a83\u0003\u0015aWM\u001c\u001a!\u0003!\tg\r^3s\u00032dG#\u00017\u0011\u0005]k\u0017B\u00018Y\u0005\u0011)f.\u001b;\u0002\u0017\u0005\u001c8/\u001a:u'R\fGo\u001d\u000b\u0005YF4\b\u0010C\u0003s'\u0001\u00071/A\u0004ue\u0006\u001c7.\u001a:\u0011\u0005=\"\u0018BA;\u001b\u0005i\u0011\u0015m]5d/JLG/\u001a+bg.\u001cF/\u0019;t)J\f7m[3s\u0011\u001598\u00031\u0001e\u0003\u00151\u0017\u000e\\3t\u0011\u0015I8\u00031\u0001e\u0003\u0015\u0011\u0017\u0010^3t\u0003-1\u0017N\\1m'R\fG/^:\u0015\u0005q|\bCA\u0018~\u0013\tq(DA\nCCNL7m\u0016:ji\u0016$\u0016m]6Ti\u0006$8\u000fC\u0003s)\u0001\u00071/A\u0003u_V\u001c\u0007\u000eF\u0002m\u0003\u000bAa!a\u0002\u0016\u0001\u0004i\u0014\u0001\u00024jY\u0016\fQa\u001e:ji\u0016$b!!\u0004\u0002\u001a\u0005m\u0001\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005Ma'\u0001\u0003mC:<\u0017\u0002BA\f\u0003#\u0011q!\u00138uK\u001e,'\u000f\u0003\u0004\u0002\bY\u0001\r!\u0010\u0005\u0007\u0003;1\u0002\u0019\u0001,\u0002\t\u0011\fG/Y\u0001\u0007oJLG/Z\u0019\u0015\u00071\f\u0019\u0003\u0003\u0004\u0002\b]\u0001\r!P\u0001\u0007oJLG/\u001a\u001a\u0015\u00071\fI\u0003\u0003\u0004\u0002\ba\u0001\r!\u0010")
public class BasicWriteTaskStatsTrackerSuite
extends SparkFunSuite {
    private final File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
    private final Path tempDirPath = new Path(this.tempDir().toURI());
    private final Configuration conf = new Configuration();
    private final FileSystem localfs = this.tempDirPath().getFileSystem(this.conf());
    private final byte[] data1 = "0123456789".getBytes(Charset.forName("US-ASCII"));
    private final byte[] data2 = "012".getBytes(Charset.forName("US-ASCII"));
    private final int len1 = this.data1().length;
    private final int len2 = this.data2().length;

    private File tempDir() {
        return this.tempDir;
    }

    private Path tempDirPath() {
        return this.tempDirPath;
    }

    private Configuration conf() {
        return this.conf;
    }

    private FileSystem localfs() {
        return this.localfs;
    }

    private byte[] data1() {
        return this.data1;
    }

    private byte[] data2() {
        return this.data2;
    }

    private int len1() {
        return this.len1;
    }

    private int len2() {
        return this.len2;
    }

    public void afterAll() {
        try {
            Utils$.MODULE$.deleteRecursively(this.tempDir());
        }
        finally {
            super.afterAll();
        }
    }

    private void assertStats(BasicWriteTaskStatsTracker tracker, int files, int bytes) {
        BasicWriteTaskStats stats = this.finalStatus(tracker);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)files));
        int $org_scalatest_assert_macro_right = stats.numFiles();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Wrong number of files", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)bytes));
        long $org_scalatest_assert_macro_right2 = stats.numBytes();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Wrong byte count of file size", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
    }

    private BasicWriteTaskStats finalStatus(BasicWriteTaskStatsTracker tracker) {
        return (BasicWriteTaskStats)tracker.getFinalStats();
    }

    private void touch(Path file) {
        this.localfs().create(file, true).close();
    }

    private Integer write(Path file, byte[] data) {
        try (FSDataOutputStream stream = this.localfs().create(file, true);){
            stream.write(data);
        }
        return Predef$.MODULE$.int2Integer(data.length);
    }

    private void write1(Path file) {
        this.write(file, this.data1());
    }

    private void write2(Path file) {
        this.write(file, this.data2());
    }

    public BasicWriteTaskStatsTrackerSuite() {
        this.test("No files in run", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf());
            this.assertStats(tracker, 0, 0);
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("Missing File", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path missing = new Path(this.tempDirPath(), "missing");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf());
            tracker.newFile(missing.toString());
            this.assertStats(tracker, 0, 0);
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("Empty filename is forwarded", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf());
            tracker.newFile("");
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.finalStatus(tracker), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("Null filename is only picked up in final status", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf());
            tracker.newFile(null);
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.finalStatus(tracker), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("0 byte file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path file = new Path(this.tempDirPath(), "file0");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf());
            tracker.newFile(file.toString());
            this.touch(file);
            this.assertStats(tracker, 1, 0);
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("File with data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path file = new Path(this.tempDirPath(), "file-with-data");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf());
            tracker.newFile(file.toString());
            this.write1(file);
            this.assertStats(tracker, 1, this.len1());
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("Open file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Path file = new Path(this.tempDirPath(), "file-open");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf());
            tracker.newFile(file.toString());
            try (FSDataOutputStream stream = this.localfs().create(file, true);){
                this.assertStats(tracker, 1, 0);
                stream.write(this.data1());
                stream.flush();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)1));
                int $org_scalatest_assert_macro_right = this.finalStatus(tracker).numFiles();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Wrong number of files", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            }
            return assertion;
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("Two files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path file1 = new Path(this.tempDirPath(), "f-2-1");
            Path file2 = new Path(this.tempDirPath(), "f-2-2");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf());
            tracker.newFile(file1.toString());
            this.write1(file1);
            tracker.newFile(file2.toString());
            this.write2(file2);
            this.assertStats(tracker, 2, this.len1() + this.len2());
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("Three files, last one empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path file1 = new Path(this.tempDirPath(), "f-3-1");
            Path file2 = new Path(this.tempDirPath(), "f-3-2");
            Path file3 = new Path(this.tempDirPath(), "f-3-2");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf());
            tracker.newFile(file1.toString());
            this.write1(file1);
            tracker.newFile(file2.toString());
            this.write2(file2);
            tracker.newFile(file3.toString());
            this.touch(file3);
            this.assertStats(tracker, 3, this.len1() + this.len2());
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("Three files, one not found", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path file1 = new Path(this.tempDirPath(), "f-4-1");
            Path file2 = new Path(this.tempDirPath(), "f-4-2");
            Path file3 = new Path(this.tempDirPath(), "f-3-2");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf());
            tracker.newFile(file1.toString());
            this.write1(file1);
            tracker.newFile(file2.toString());
            tracker.newFile(file3.toString());
            this.write2(file3);
            this.assertStats(tracker, 2, this.len1() + this.len2());
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
    }
}

