/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.util.collection.SortDataFormat;
import org.apache.spark.util.collection.Sorter;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparators;
import org.apache.spark.util.collection.unsafe.sort.RadixSort;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSortDataFormat;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class SortBenchmark$
extends BenchmarkBase {
    public static SortBenchmark$ MODULE$;

    static {
        new SortBenchmark$();
    }

    private void referenceKeyPrefixSort(LongArray buf, int lo, int hi, PrefixComparator refCmp) {
        LongArray sortBuffer = new LongArray(MemoryBlock.fromLongArray((long[])new long[(int)buf.size()]));
        new Sorter((SortDataFormat)new UnsafeSortDataFormat(sortBuffer)).sort((Object)buf, lo, hi, (r1, r2) -> refCmp.compare(r1.keyPrefix, r2.keyPrefix));
    }

    private Tuple2<LongArray, LongArray> generateKeyPrefixTestData(int size, Function0<Object> rand) {
        long[] ref = (long[])Array$.MODULE$.tabulate(size * 2, (Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> rand.apply$mcJ$sp(), ClassTag$.MODULE$.Long());
        long[] extended = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(ref)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])Array$.MODULE$.ofDim(size * 2, ClassTag$.MODULE$.Long()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        return new Tuple2((Object)new LongArray(MemoryBlock.fromLongArray((long[])ref)), (Object)new LongArray(MemoryBlock.fromLongArray((long[])extended)));
    }

    public void sortBenchmark() {
        int size = 25000000;
        XORShiftRandom rand = new XORShiftRandom(123L);
        String x$1 = new StringBuilder(11).append("radix sort ").append(size).toString();
        long x$2 = size;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        benchmark.addTimerCase("reference TimSort key prefix array", benchmark.addTimerCase$default$2(), (Function1 & Serializable & scala.Serializable)timer -> {
            SortBenchmark$.$anonfun$sortBenchmark$1(size, rand, timer);
            return BoxedUnit.UNIT;
        });
        benchmark.addTimerCase("reference Arrays.sort", benchmark.addTimerCase$default$2(), (Function1 & Serializable & scala.Serializable)timer -> {
            SortBenchmark$.$anonfun$sortBenchmark$3(size, rand, timer);
            return BoxedUnit.UNIT;
        });
        benchmark.addTimerCase("radix sort one byte", benchmark.addTimerCase$default$2(), (Function1 & Serializable & scala.Serializable)timer -> {
            SortBenchmark$.$anonfun$sortBenchmark$5(size, rand, timer);
            return BoxedUnit.UNIT;
        });
        benchmark.addTimerCase("radix sort two bytes", benchmark.addTimerCase$default$2(), (Function1 & Serializable & scala.Serializable)timer -> {
            SortBenchmark$.$anonfun$sortBenchmark$6(size, rand, timer);
            return BoxedUnit.UNIT;
        });
        benchmark.addTimerCase("radix sort eight bytes", benchmark.addTimerCase$default$2(), (Function1 & Serializable & scala.Serializable)timer -> {
            SortBenchmark$.$anonfun$sortBenchmark$7(size, rand, timer);
            return BoxedUnit.UNIT;
        });
        benchmark.addTimerCase("radix sort key prefix array", benchmark.addTimerCase$default$2(), (Function1 & Serializable & scala.Serializable)timer -> {
            SortBenchmark$.$anonfun$sortBenchmark$8(size, rand, timer);
            return BoxedUnit.UNIT;
        });
        benchmark.run();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("radix sort", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.sortBenchmark());
    }

    public static final /* synthetic */ void $anonfun$sortBenchmark$1(int size$1, XORShiftRandom rand$2, Benchmark.Timer timer) {
        long[] array = (long[])Array$.MODULE$.tabulate(size$1 * 2, (Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> rand$2.nextLong(), ClassTag$.MODULE$.Long());
        LongArray buf = new LongArray(MemoryBlock.fromLongArray((long[])array));
        timer.startTiming();
        MODULE$.referenceKeyPrefixSort(buf, 0, size$1, PrefixComparators.BINARY);
        timer.stopTiming();
    }

    public static final /* synthetic */ void $anonfun$sortBenchmark$3(int size$1, XORShiftRandom rand$2, Benchmark.Timer timer) {
        long[] ref = (long[])Array$.MODULE$.tabulate(size$1, (Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> rand$2.nextLong(), ClassTag$.MODULE$.Long());
        timer.startTiming();
        Arrays.sort(ref);
        timer.stopTiming();
    }

    public static final /* synthetic */ void $anonfun$sortBenchmark$5(int size$1, XORShiftRandom rand$2, Benchmark.Timer timer) {
        long[] array = new long[size$1 * 2];
        for (int i = 0; i < size$1; ++i) {
            array[i] = rand$2.nextLong() & 0xFFL;
        }
        LongArray buf = new LongArray(MemoryBlock.fromLongArray((long[])array));
        timer.startTiming();
        RadixSort.sort((LongArray)buf, (long)size$1, (int)0, (int)7, (boolean)false, (boolean)false);
        timer.stopTiming();
    }

    public static final /* synthetic */ void $anonfun$sortBenchmark$6(int size$1, XORShiftRandom rand$2, Benchmark.Timer timer) {
        long[] array = new long[size$1 * 2];
        for (int i = 0; i < size$1; ++i) {
            array[i] = rand$2.nextLong() & 0xFFFFL;
        }
        LongArray buf = new LongArray(MemoryBlock.fromLongArray((long[])array));
        timer.startTiming();
        RadixSort.sort((LongArray)buf, (long)size$1, (int)0, (int)7, (boolean)false, (boolean)false);
        timer.stopTiming();
    }

    public static final /* synthetic */ void $anonfun$sortBenchmark$7(int size$1, XORShiftRandom rand$2, Benchmark.Timer timer) {
        long[] array = new long[size$1 * 2];
        for (int i = 0; i < size$1; ++i) {
            array[i] = rand$2.nextLong();
        }
        LongArray buf = new LongArray(MemoryBlock.fromLongArray((long[])array));
        timer.startTiming();
        RadixSort.sort((LongArray)buf, (long)size$1, (int)0, (int)7, (boolean)false, (boolean)false);
        timer.stopTiming();
    }

    public static final /* synthetic */ void $anonfun$sortBenchmark$8(int size$1, XORShiftRandom rand$2, Benchmark.Timer timer) {
        LongArray buf2;
        Tuple2<LongArray, LongArray> tuple2 = MODULE$.generateKeyPrefixTestData(size$1, (Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> rand$2.nextLong());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LongArray longArray = buf2 = (LongArray)tuple2._2();
        LongArray buf22 = longArray;
        timer.startTiming();
        RadixSort.sortKeyPrefixArray((LongArray)buf22, (long)0L, (long)size$1, (int)0, (int)7, (boolean)false, (boolean)false);
        timer.stopTiming();
    }

    private SortBenchmark$() {
        MODULE$ = this;
    }
}

