/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkContext;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class PrimitiveArrayBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static PrimitiveArrayBenchmark$ MODULE$;
    private final SparkSession spark;
    private String sparkHome;
    private volatile boolean bitmap$0;

    static {
        new PrimitiveArrayBenchmark$();
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private String sparkHome$lzycompute() {
        PrimitiveArrayBenchmark$ primitiveArrayBenchmark$ = this;
        synchronized (primitiveArrayBenchmark$) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    @Override
    public SparkSession getSparkSession() {
        return SparkSession$.MODULE$.builder().master("local[1]").appName("microbenchmark").config("spark.sql.shuffle.partitions", 1L).config("spark.sql.autoBroadcastJoinThreshold", 1L).getOrCreate();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("Write primitive arrays in dataset", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.writeDatasetArray(4));
    }

    public void writeDatasetArray(int iters) {
        int count = 0x200000;
        SparkContext sc = this.spark().sparkContext();
        int[] primitiveIntArray = (int[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 65535, ClassTag$.MODULE$.Int());
        Dataset dsInt = this.spark().implicits().rddToDatasetHolder(sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new int[][]{primitiveIntArray})), 1, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))), this.spark().implicits().newIntArrayEncoder()).toDS();
        dsInt.count();
        JFunction1.mcVI.sp & Serializable & scala.Serializable intArray = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += ((InternalRow[])dsInt.map((Function1 & Serializable & scala.Serializable)e -> e, MODULE$.spark().implicits().newIntArrayEncoder()).queryExecution().toRdd().collect()).length;
            }
        };
        double[] primitiveDoubleArray = (double[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 65535.0, ClassTag$.MODULE$.Double());
        Dataset dsDouble = this.spark().implicits().rddToDatasetHolder(sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{primitiveDoubleArray})), 1, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))), this.spark().implicits().newDoubleArrayEncoder()).toDS();
        dsDouble.count();
        JFunction1.mcVI.sp & Serializable & scala.Serializable doubleArray = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += ((InternalRow[])dsDouble.map((Function1 & Serializable & scala.Serializable)e -> e, MODULE$.spark().implicits().newDoubleArrayEncoder()).queryExecution().toRdd().collect()).length;
            }
        };
        String x$1 = "Write an array in Dataset";
        long x$2 = count * iters;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        benchmark.addCase("Int   ", benchmark.addCase$default$2(), (Function1)intArray);
        benchmark.addCase("Double", benchmark.addCase$default$2(), (Function1)doubleArray);
        benchmark.run();
    }

    private PrimitiveArrayBenchmark$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        SqlBasedBenchmark.$init$(this);
    }
}

