/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.ConfigEntry$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.ScriptInputOutputSchema;
import org.apache.spark.sql.catalyst.plans.logical.ScriptTransformation;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.SparkSqlParser;
import org.apache.spark.sql.execution.command.AddFileCommand;
import org.apache.spark.sql.execution.command.AddJarCommand;
import org.apache.spark.sql.execution.command.CacheTableCommand;
import org.apache.spark.sql.execution.command.ClearCacheCommand$;
import org.apache.spark.sql.execution.command.DescribeQueryCommand;
import org.apache.spark.sql.execution.command.ListFilesCommand;
import org.apache.spark.sql.execution.command.ListJarsCommand;
import org.apache.spark.sql.execution.command.ResetCommand;
import org.apache.spark.sql.execution.command.SetCommand;
import org.apache.spark.sql.execution.command.UncacheTableCommand;
import org.apache.spark.sql.execution.datasources.CreateTempViewUsing;
import org.apache.spark.sql.execution.datasources.RefreshResource;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000193A!\u0002\u0004\u0001#!)a\u0004\u0001C\u0001?!A!\u0005\u0001EC\u0002\u0013%1\u0005C\u0003(\u0001\u0011%\u0001\u0006C\u0003G\u0001\u0011%qIA\nTa\u0006\u00148nU9m!\u0006\u00148/\u001a:Tk&$XM\u0003\u0002\b\u0011\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001I1\u0002CA\n\u0015\u001b\u0005Q\u0011BA\u000b\u000b\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011q\u0003H\u0007\u00021)\u0011\u0011DG\u0001\tC:\fG._:jg*\u00111\u0004C\u0001\tG\u0006$\u0018\r\\=ti&\u0011Q\u0004\u0007\u0002\r\u0003:\fG._:jgR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u0003\u0019\ta\u0001]1sg\u0016\u0014X#\u0001\u0013\u0011\u0005\u0005*\u0013B\u0001\u0014\u0007\u00059\u0019\u0006/\u0019:l'Fd\u0007+\u0019:tKJ\f1\"Y:tKJ$X)];bYR\u0019\u0011f\f\u001f\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006a\r\u0001\r!M\u0001\u000bgFd7i\\7nC:$\u0007C\u0001\u001a:\u001d\t\u0019t\u0007\u0005\u00025W5\tQG\u0003\u00027!\u00051AH]8pizJ!\u0001O\u0016\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003q-BQ!P\u0002A\u0002y\nA\u0001\u001d7b]B\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\bY><\u0017nY1m\u0015\t\u0019%$A\u0003qY\u0006t7/\u0003\u0002F\u0001\nYAj\\4jG\u0006d\u0007\u000b\\1o\u0003%Ig\u000e^3sG\u0016\u0004H\u000fF\u0002*\u0011&CQ\u0001\r\u0003A\u0002EBQA\u0013\u0003A\u0002-\u000b\u0001\"\\3tg\u0006<Wm\u001d\t\u0004U1\u000b\u0014BA',\u0005)a$/\u001a9fCR,GM\u0010")
public class SparkSqlParserSuite
extends SparkFunSuite
implements AnalysisTest {
    private SparkSqlParser parser;
    private String sparkHome;
    private volatile byte bitmap$0;

    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$((AnalysisTest)this);
    }

    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$((AnalysisTest)this);
    }

    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$((AnalysisTest)this, (LogicalPlan)inputPlan, (LogicalPlan)expectedPlan, (boolean)caseSensitive);
    }

    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$((AnalysisTest)this);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$((AnalysisTest)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$((AnalysisTest)this);
    }

    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$((AnalysisTest)this, (LogicalPlan)inputPlan, (boolean)caseSensitive);
    }

    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$((AnalysisTest)this);
    }

    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$((AnalysisTest)this, (LogicalPlan)inputPlan, expectedErrors, (boolean)caseSensitive);
    }

    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$((AnalysisTest)this);
    }

    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        AnalysisTest.interceptParseException$((AnalysisTest)this, parser, (String)sqlCommand, messages);
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        SparkSqlParserSuite sparkSqlParserSuite = this;
        synchronized (sparkSqlParserSuite) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private SparkSqlParser parser$lzycompute() {
        SparkSqlParserSuite sparkSqlParserSuite = this;
        synchronized (sparkSqlParserSuite) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.parser = new SparkSqlParser();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.parser;
    }

    private SparkSqlParser parser() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.parser$lzycompute() : this.parser;
    }

    private void assertEqual(String sqlCommand, LogicalPlan plan) {
        this.comparePlans(this.parser().parsePlan(sqlCommand), plan, this.comparePlans$default$3());
    }

    private void intercept(String sqlCommand, Seq<String> messages) {
        this.interceptParseException((Function1<String, Object>)(Function1 & Serializable & scala.Serializable)sqlText -> this.parser().parsePlan(sqlText), sqlCommand, messages);
    }

    public static final /* synthetic */ void $anonfun$new$2(SparkSqlParserSuite $this, ConfigEntry config) {
        $this.assertEqual(new StringBuilder(4).append("SET ").append(config.key()).toString(), (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.key()), (Object)None$.MODULE$))));
        $this.assertEqual(new StringBuilder(6).append("SET `").append(config.key()).append("`").toString(), (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.key()), (Object)None$.MODULE$))));
        String defaultValueStr = config.defaultValueString();
        if (config.defaultValue().isDefined() && defaultValueStr != null) {
            $this.assertEqual(new StringBuilder(7).append("SET ").append(config.key()).append("=`").append(defaultValueStr).append("`").toString(), (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.key()), (Object)new Some((Object)defaultValueStr)))));
            $this.assertEqual(new StringBuilder(9).append("SET `").append(config.key()).append("`=`").append(defaultValueStr).append("`").toString(), (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.key()), (Object)new Some((Object)defaultValueStr)))));
            if (!defaultValueStr.contains(";")) {
                $this.assertEqual(new StringBuilder(5).append("SET ").append(config.key()).append("=").append(defaultValueStr).toString(), (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.key()), (Object)new Some((Object)defaultValueStr)))));
                $this.assertEqual(new StringBuilder(7).append("SET `").append(config.key()).append("`=").append(defaultValueStr).toString(), (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.key()), (Object)new Some((Object)defaultValueStr)))));
            }
        }
        $this.assertEqual(new StringBuilder(6).append("RESET ").append(config.key()).toString(), (LogicalPlan)new ResetCommand((Option)new Some((Object)config.key())));
    }

    public SparkSqlParserSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$((SQLHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
        AnalysisTest.$init$((AnalysisTest)this);
        this.test("Checks if SET/RESET can parse all the configurations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(ConfigEntry$.MODULE$.knownConfigs().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)config -> {
            SparkSqlParserSuite.$anonfun$new$2(this, config);
            return BoxedUnit.UNIT;
        }), new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("Report Error for invalid usage of SET command", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("SET", (LogicalPlan)new SetCommand((Option)None$.MODULE$));
            this.assertEqual("SET -v", (LogicalPlan)new SetCommand((Option)new Some((Object)new Tuple2((Object)"-v", (Object)None$.MODULE$))));
            this.assertEqual("SET spark.sql.key", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.key"), (Object)None$.MODULE$))));
            this.assertEqual("SET  spark.sql.key   ", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.key"), (Object)None$.MODULE$))));
            this.assertEqual("SET spark:sql:key=false", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark:sql:key"), (Object)new Some((Object)"false")))));
            this.assertEqual("SET spark:sql:key=", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark:sql:key"), (Object)new Some((Object)"")))));
            this.assertEqual("SET spark:sql:key=  ", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark:sql:key"), (Object)new Some((Object)"")))));
            this.assertEqual("SET spark:sql:key=-1 ", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark:sql:key"), (Object)new Some((Object)"-1")))));
            this.assertEqual("SET spark:sql:key = -1", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark:sql:key"), (Object)new Some((Object)"-1")))));
            this.assertEqual("SET 1.2.key=value", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1.2.key"), (Object)new Some((Object)"value")))));
            this.assertEqual("SET spark.sql.3=4", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.3"), (Object)new Some((Object)"4")))));
            this.assertEqual("SET 1:2:key=value", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1:2:key"), (Object)new Some((Object)"value")))));
            this.assertEqual("SET spark:sql:3=4", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark:sql:3"), (Object)new Some((Object)"4")))));
            this.assertEqual("SET 5=6", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"5"), (Object)new Some((Object)"6")))));
            this.assertEqual("SET spark:sql:key = va l u  e ", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark:sql:key"), (Object)new Some((Object)"va l u  e")))));
            this.assertEqual("SET `spark.sql.    key`=value", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.    key"), (Object)new Some((Object)"value")))));
            this.assertEqual("SET `spark.sql.    key`= v  a lu e ", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.    key"), (Object)new Some((Object)"v  a lu e")))));
            this.assertEqual("SET `spark.sql.    key`=  -1", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.    key"), (Object)new Some((Object)"-1")))));
            this.assertEqual("SET key=", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)new Some((Object)"")))));
            String expectedErrMsg = "Expected format is 'SET', 'SET key', or 'SET key=value'. If you want to include special characters in key, or include semicolon in value, please use quotes, e.g., SET `ke y`=`v;alue`.";
            this.intercept("SET spark.sql.key value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("SET spark.sql.key   'value'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("SET    spark.sql.key \"value\" ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("SET spark.sql.key value1 value2", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("SET spark.   sql.key=value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("SET spark   :sql:key=value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("SET spark .  sql.key=value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("SET spark.sql.   key=value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("SET spark.sql   :key=value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("SET spark.sql .  key=value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("SET =", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("SET =value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("Report Error for invalid usage of RESET command", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("RESET", (LogicalPlan)new ResetCommand((Option)None$.MODULE$));
            this.assertEqual("RESET spark.sql.key", (LogicalPlan)new ResetCommand((Option)new Some((Object)"spark.sql.key")));
            this.assertEqual("RESET  spark.sql.key  ", (LogicalPlan)new ResetCommand((Option)new Some((Object)"spark.sql.key")));
            this.assertEqual("RESET 1.2.key ", (LogicalPlan)new ResetCommand((Option)new Some((Object)"1.2.key")));
            this.assertEqual("RESET spark.sql.3", (LogicalPlan)new ResetCommand((Option)new Some((Object)"spark.sql.3")));
            this.assertEqual("RESET 1:2:key ", (LogicalPlan)new ResetCommand((Option)new Some((Object)"1:2:key")));
            this.assertEqual("RESET spark:sql:3", (LogicalPlan)new ResetCommand((Option)new Some((Object)"spark:sql:3")));
            this.assertEqual("RESET `spark.sql.    key`", (LogicalPlan)new ResetCommand((Option)new Some((Object)"spark.sql.    key")));
            String expectedErrMsg = "Expected format is 'RESET' or 'RESET key'. If you want to include special characters in key, please use quotes, e.g., RESET `ke y`.";
            this.intercept("RESET spark.sql.key1 key2", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("RESET spark.  sql.key1 key2", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("RESET spark.sql.key1 key2 key3", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("RESET spark:   sql:key", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("RESET spark   .sql.key", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("RESET spark :  sql:key", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("RESET spark.sql:   key", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("RESET spark.sql   .key", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("RESET spark.sql :  key", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("SPARK-33419: Semicolon handling in SET command", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("SET a=1;", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new Some((Object)"1")))));
            this.assertEqual("SET a=1;;", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new Some((Object)"1")))));
            this.assertEqual("SET a=`1`;", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new Some((Object)"1")))));
            this.assertEqual("SET a=`1;`", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new Some((Object)"1;")))));
            this.assertEqual("SET a=`1;`;", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new Some((Object)"1;")))));
            this.assertEqual("SET `a`=1;;", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new Some((Object)"1")))));
            this.assertEqual("SET `a`=`1;`", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new Some((Object)"1;")))));
            this.assertEqual("SET `a`=`1;`;", (LogicalPlan)new SetCommand((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new Some((Object)"1;")))));
            String expectedErrMsg = "Expected format is 'SET', 'SET key', or 'SET key=value'. If you want to include special characters in key, or include semicolon in value, please use quotes, e.g., SET `ke y`=`v;alue`.";
            this.intercept("SET a=1; SELECT 1", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("SET a=1;2;;", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedErrMsg}));
            this.intercept("SET a b=`1;;`", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'a b' is an invalid property key, please use quotes, e.g. SET `a b`=`1;;`"}));
            this.intercept("SET `a`=1;2;;", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'1;2;;' is an invalid property value, please use quotes, e.g. SET `a`=`1;2;;`"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("refresh resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("REFRESH prefix_path", (LogicalPlan)new RefreshResource("prefix_path"));
            this.assertEqual("REFRESH /", (LogicalPlan)new RefreshResource("/"));
            this.assertEqual("REFRESH /path///a", (LogicalPlan)new RefreshResource("/path///a"));
            this.assertEqual("REFRESH pat1h/112/_1a", (LogicalPlan)new RefreshResource("pat1h/112/_1a"));
            this.assertEqual("REFRESH pat1h/112/_1a/a-1", (LogicalPlan)new RefreshResource("pat1h/112/_1a/a-1"));
            this.assertEqual("REFRESH path-with-dash", (LogicalPlan)new RefreshResource("path-with-dash"));
            this.assertEqual("REFRESH 'path with space'", (LogicalPlan)new RefreshResource("path with space"));
            this.assertEqual("REFRESH \"path with space 2\"", (LogicalPlan)new RefreshResource("path with space 2"));
            this.intercept("REFRESH a b", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH a\tb", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH a\nb", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH a\rb", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH a\r\nb", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH @ $a$", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH  ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resource paths cannot be empty in REFRESH statements"}));
            this.intercept("REFRESH", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resource paths cannot be empty in REFRESH statements"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("SPARK-33118 CREATE TEMPORARY TABLE with LOCATION", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("CREATE TEMPORARY TABLE t USING parquet OPTIONS (path '/data/tmp/testspark1')", (LogicalPlan)new CreateTempViewUsing(new TableIdentifier("t", (Option)None$.MODULE$), (Option)None$.MODULE$, false, false, "parquet", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"/data/tmp/testspark1")}))));
            this.assertEqual("CREATE TEMPORARY TABLE t USING parquet LOCATION '/data/tmp/testspark1'", (LogicalPlan)new CreateTempViewUsing(new TableIdentifier("t", (Option)None$.MODULE$), (Option)None$.MODULE$, false, false, "parquet", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"/data/tmp/testspark1")}))));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("describe query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String query = "SELECT * FROM t";
            this.assertEqual(new StringBuilder(15).append("DESCRIBE QUERY ").append(query).toString(), (LogicalPlan)new DescribeQueryCommand(query, this.parser().parsePlan(query)));
            this.assertEqual(new StringBuilder(9).append("DESCRIBE ").append(query).toString(), (LogicalPlan)new DescribeQueryCommand(query, this.parser().parsePlan(query)));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("query organization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String baseSql = "select * from t";
            Project basePlan = new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedStar[]{new UnresolvedStar((Option)None$.MODULE$)})), (LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("t")));
            UnresolvedAttribute unresolvedAttribute = UnresolvedAttribute$.MODULE$.apply("a");
            UnresolvedAttribute unresolvedAttribute2 = UnresolvedAttribute$.MODULE$.apply("b");
            this.assertEqual(new StringBuilder(19).append(baseSql).append(" distribute by a, b").toString(), (LogicalPlan)new RepartitionByExpression((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute), (LogicalPlan)basePlan, (Option)None$.MODULE$));
            SortOrder sortOrder = SortOrder$.MODULE$.apply((Expression)UnresolvedAttribute$.MODULE$.apply("b"), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            UnresolvedAttribute unresolvedAttribute3 = UnresolvedAttribute$.MODULE$.apply("a");
            this.assertEqual(new StringBuilder(26).append(baseSql).append(" distribute by a sort by b").toString(), (LogicalPlan)new Sort((Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), false, (LogicalPlan)new RepartitionByExpression((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute3), (LogicalPlan)basePlan, (Option)None$.MODULE$)));
            SortOrder sortOrder2 = SortOrder$.MODULE$.apply((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            SortOrder sortOrder3 = SortOrder$.MODULE$.apply((Expression)UnresolvedAttribute$.MODULE$.apply("b"), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            UnresolvedAttribute unresolvedAttribute4 = UnresolvedAttribute$.MODULE$.apply("a");
            UnresolvedAttribute unresolvedAttribute5 = UnresolvedAttribute$.MODULE$.apply("b");
            this.assertEqual(new StringBuilder(16).append(baseSql).append(" cluster by a, b").toString(), (LogicalPlan)new Sort((Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder3).$colon$colon((Object)sortOrder2), false, (LogicalPlan)new RepartitionByExpression((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute5).$colon$colon((Object)unresolvedAttribute4), (LogicalPlan)basePlan, (Option)None$.MODULE$)));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("pipeline concatenation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedAttribute unresolvedAttribute = UnresolvedAttribute$.MODULE$.apply("a");
            UnresolvedAttribute unresolvedAttribute2 = UnresolvedAttribute$.MODULE$.apply("b");
            Concat concat = new Concat((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute));
            UnresolvedAttribute unresolvedAttribute3 = UnresolvedAttribute$.MODULE$.apply("c");
            Concat concat2 = new Concat((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute3).$colon$colon((Object)concat));
            UnresolvedAlias unresolvedAlias = new UnresolvedAlias((Expression)concat2, UnresolvedAlias$.MODULE$.apply$default$2());
            this.assertEqual("SELECT a || b || c FROM t", (LogicalPlan)new Project((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAlias), (LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("t"))));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        this.test("database and schema tokens are interchangeable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("CREATE DATABASE foo", this.parser().parsePlan("CREATE SCHEMA foo"));
            this.assertEqual("DROP DATABASE foo", this.parser().parsePlan("DROP SCHEMA foo"));
            this.assertEqual("ALTER DATABASE foo SET DBPROPERTIES ('x' = 'y')", this.parser().parsePlan("ALTER SCHEMA foo SET DBPROPERTIES ('x' = 'y')"));
            this.assertEqual("DESC DATABASE foo", this.parser().parsePlan("DESC SCHEMA foo"));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        this.test("manage resources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("ADD FILE abc.txt", (LogicalPlan)new AddFileCommand("abc.txt"));
            this.assertEqual("ADD FILE 'abc.txt'", (LogicalPlan)new AddFileCommand("abc.txt"));
            this.assertEqual("ADD FILE \"/path/to/abc.txt\"", (LogicalPlan)new AddFileCommand("/path/to/abc.txt"));
            this.assertEqual("LIST FILE abc.txt", (LogicalPlan)new ListFilesCommand((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc.txt"})));
            this.assertEqual("LIST FILE '/path//abc.txt'", (LogicalPlan)new ListFilesCommand((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/path//abc.txt"})));
            this.assertEqual("LIST FILE \"/path2/abc.txt\"", (LogicalPlan)new ListFilesCommand((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/path2/abc.txt"})));
            this.assertEqual("ADD JAR /path2/_2/abc.jar", (LogicalPlan)new AddJarCommand("/path2/_2/abc.jar"));
            this.assertEqual("ADD JAR '/test/path_2/jar/abc.jar'", (LogicalPlan)new AddJarCommand("/test/path_2/jar/abc.jar"));
            this.assertEqual("ADD JAR \"abc.jar\"", (LogicalPlan)new AddJarCommand("abc.jar"));
            this.assertEqual("LIST JAR /path-with-dash/abc.jar", (LogicalPlan)new ListJarsCommand((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/path-with-dash/abc.jar"})));
            this.assertEqual("LIST JAR 'abc.jar'", (LogicalPlan)new ListJarsCommand((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc.jar"})));
            this.assertEqual("LIST JAR \"abc.jar\"", (LogicalPlan)new ListJarsCommand((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc.jar"})));
            this.assertEqual("ADD FILE /path with space/abc.txt", (LogicalPlan)new AddFileCommand("/path with space/abc.txt"));
            this.assertEqual("ADD JAR /path with space/abc.jar", (LogicalPlan)new AddJarCommand("/path with space/abc.jar"));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        this.test("SPARK-32608: script transform with row format delimit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AttributeReference[] attributeReferenceArray = new AttributeReference[3];
            String x$1 = "a";
            StringType$ x$2 = StringType$.MODULE$;
            boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
            attributeReferenceArray[0] = new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
            String x$7 = "b";
            StringType$ x$8 = StringType$.MODULE$;
            boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
            Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, (DataType)x$8, x$9, x$10);
            attributeReferenceArray[1] = new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$11, x$12);
            String x$13 = "c";
            StringType$ x$14 = StringType$.MODULE$;
            boolean x$15 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$17 = AttributeReference$.MODULE$.apply$default$5(x$13, (DataType)x$14, x$15, x$16);
            Seq x$18 = AttributeReference$.MODULE$.apply$default$6(x$13, (DataType)x$14, x$15, x$16);
            attributeReferenceArray[2] = new AttributeReference(x$13, (DataType)x$14, x$15, x$16, x$17, x$18);
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TRANSFORM(a, b, c)\n        |  ROW FORMAT DELIMITED\n        |  FIELDS TERMINATED BY ','\n        |  COLLECTION ITEMS TERMINATED BY '#'\n        |  MAP KEYS TERMINATED BY '@'\n        |  LINES TERMINATED BY '\\n'\n        |  NULL DEFINED AS 'null'\n        |  USING 'cat' AS (a, b, c)\n        |  ROW FORMAT DELIMITED\n        |  FIELDS TERMINATED BY ','\n        |  COLLECTION ITEMS TERMINATED BY '#'\n        |  MAP KEYS TERMINATED BY '@'\n        |  LINES TERMINATED BY '\\n'\n        |  NULL DEFINED AS 'NULL'\n        |FROM testData\n      ")).stripMargin(), (LogicalPlan)new ScriptTransformation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), "cat", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])attributeReferenceArray)), (LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("testData")), new ScriptInputOutputSchema((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"TOK_TABLEROWFORMATFIELD", (Object)","), new Tuple2((Object)"TOK_TABLEROWFORMATCOLLITEMS", (Object)"#"), new Tuple2((Object)"TOK_TABLEROWFORMATMAPKEYS", (Object)"@"), new Tuple2((Object)"TOK_TABLEROWFORMATNULL", (Object)"null"), new Tuple2((Object)"TOK_TABLEROWFORMATLINES", (Object)"\n")})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"TOK_TABLEROWFORMATFIELD", (Object)","), new Tuple2((Object)"TOK_TABLEROWFORMATCOLLITEMS", (Object)"#"), new Tuple2((Object)"TOK_TABLEROWFORMATMAPKEYS", (Object)"@"), new Tuple2((Object)"TOK_TABLEROWFORMATNULL", (Object)"NULL"), new Tuple2((Object)"TOK_TABLEROWFORMATLINES", (Object)"\n")})), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        this.test("SPARK-32607: Script Transformation ROW FORMAT DELIMITED `TOK_TABLEROWFORMATLINES` only support '\\n'", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept(new StringOps(Predef$.MODULE$.augmentString("\n             |SELECT TRANSFORM(a, b, c, d, e)\n             |  ROW FORMAT DELIMITED\n             |  FIELDS TERMINATED BY ','\n             |  LINES TERMINATED BY '@'\n             |  NULL DEFINED AS 'null'\n             |  USING 'cat' AS (value)\n             |  ROW FORMAT DELIMITED\n             |  FIELDS TERMINATED BY '&'\n             |  LINES TERMINATED BY '\n'\n             |  NULL DEFINED AS 'NULL'\n             |FROM v\n        ")).stripMargin(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LINES TERMINATED BY only supports newline '\\n' right now"}));
            this.intercept(new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT TRANSFORM(a, b, c, d, e)\n         |  ROW FORMAT DELIMITED\n         |  FIELDS TERMINATED BY ','\n         |  LINES TERMINATED BY '\n'\n         |  NULL DEFINED AS 'null'\n         |  USING 'cat' AS (value)\n         |  ROW FORMAT DELIMITED\n         |  FIELDS TERMINATED BY '&'\n         |  LINES TERMINATED BY '@'\n         |  NULL DEFINED AS 'NULL'\n         |FROM v\n        ")).stripMargin(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LINES TERMINATED BY only supports newline '\\n' right now"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        this.test("CACHE TABLE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("CACHE TABLE a.b.c", (LogicalPlan)new CacheTableCommand((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()));
            this.assertEqual("CACHE TABLE t AS SELECT * FROM testData", (LogicalPlan)new CacheTableCommand((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})), (Option)new Some((Object)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedStar[]{new UnresolvedStar((Option)None$.MODULE$)})), (LogicalPlan)new UnresolvedRelation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testData"})), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()))), (Option)new Some((Object)"SELECT * FROM testData"), false, Predef$.MODULE$.Map().empty()));
            this.assertEqual("CACHE LAZY TABLE a.b.c", (LogicalPlan)new CacheTableCommand((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (Option)None$.MODULE$, (Option)None$.MODULE$, true, Predef$.MODULE$.Map().empty()));
            this.assertEqual("CACHE LAZY TABLE a.b.c OPTIONS('storageLevel' 'DISK_ONLY')", (LogicalPlan)new CacheTableCommand((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (Option)None$.MODULE$, (Option)None$.MODULE$, true, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"storageLevel"), (Object)"DISK_ONLY")}))));
            this.intercept("CACHE TABLE a.b.c AS SELECT * FROM testData", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It is not allowed to add catalog/namespace prefix a.b"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        this.test("UNCACHE TABLE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("UNCACHE TABLE a.b.c", (LogicalPlan)new UncacheTableCommand((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), false));
            this.assertEqual("UNCACHE TABLE IF EXISTS a.b.c", (LogicalPlan)new UncacheTableCommand((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), true));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        this.test("CLEAR CACHE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("CLEAR CACHE", (LogicalPlan)ClearCacheCommand$.MODULE$), new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
    }
}

