/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.CoalescedShuffleReader$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.adaptive.CustomShuffleReaderExec;
import org.apache.spark.sql.execution.adaptive.QueryStageExec;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec;
import org.apache.spark.sql.execution.exchange.ReusedExchangeExec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0004\b\u00013!)A\u0005\u0001C\u0001K!I\u0001\u0006\u0001a\u0001\u0002\u0004%I!\u000b\u0005\ni\u0001\u0001\r\u00111A\u0005\nUB\u0011b\u000f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0016\t\u0013q\u0002\u0001\u0019!a\u0001\n\u0013I\u0003\"C\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0003?\u0011%\u0001\u0005\u00011A\u0001B\u0003&!\u0006C\u0003B\u0001\u0011E#\tC\u0003D\u0001\u0011E#\tC\u0004E\u0001\t\u0007I\u0011A#\t\r%\u0003\u0001\u0015!\u0003G\u0011\u0015Q\u0005\u0001\"\u0001L\u0005y\u0019u.\u00197fg\u000e,7\u000b[;gM2,\u0007+\u0019:uSRLwN\\:Tk&$XM\u0003\u0002\u0010!\u0005IQ\r_3dkRLwN\u001c\u0006\u0003#I\t1a]9m\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0004\u0001iq\u0002CA\u000e\u001d\u001b\u0005\u0011\u0012BA\u000f\u0013\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011qDI\u0007\u0002A)\u0011\u0011EF\u0001\ng\u000e\fG.\u0019;fgRL!a\t\u0011\u0003#\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0006cG.\u0001\u0004=S:LGO\u0010\u000b\u0002MA\u0011q\u0005A\u0007\u0002\u001d\u0005QrN]5hS:\fG.Q2uSZ,7\u000b]1sWN+7o]5p]V\t!\u0006E\u0002,]Aj\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005E\u0012T\"\u0001\t\n\u0005M\u0002\"\u0001D*qCJ\\7+Z:tS>t\u0017AH8sS\u001eLg.\u00197BGRLg/Z*qCJ\\7+Z:tS>tw\fJ3r)\t1\u0014\b\u0005\u0002,o%\u0011\u0001\b\f\u0002\u0005+:LG\u000fC\u0004;\u0007\u0005\u0005\t\u0019\u0001\u0016\u0002\u0007a$\u0013'A\u000epe&<\u0017N\\1m\u0003\u000e$\u0018N^3Ta\u0006\u00148nU3tg&|g\u000eI\u0001!_JLw-\u001b8bY&s7\u000f^1oi&\fG/\u001a3Ta\u0006\u00148nU3tg&|g.\u0001\u0013pe&<\u0017N\\1m\u0013:\u001cH/\u00198uS\u0006$X\rZ*qCJ\\7+Z:tS>tw\fJ3r)\t1t\bC\u0004;\r\u0005\u0005\t\u0019\u0001\u0016\u0002C=\u0014\u0018nZ5oC2Len\u001d;b]RL\u0017\r^3e'B\f'o[*fgNLwN\u001c\u0011\u0002\u0013\t,gm\u001c:f\u00032dG#\u0001\u001c\u0002\u0011\u00054G/\u001a:BY2\f!C\\;n\u0013:\u0004X\u000f\u001e)beRLG/[8ogV\ta\t\u0005\u0002,\u000f&\u0011\u0001\n\f\u0002\u0004\u0013:$\u0018a\u00058v[&s\u0007/\u001e;QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001E<ji\"\u001c\u0006/\u0019:l'\u0016\u001c8/[8o)\u00111D*U*\t\u000b5c\u0001\u0019\u0001(\u0002\u0003\u0019\u0004BaK(1m%\u0011\u0001\u000b\f\u0002\n\rVt7\r^5p]FBQA\u0015\u0007A\u0002\u0019\u000b!\u0004^1sO\u0016$\bk\\:u'\",hM\u001a7f\u0013:\u0004X\u000f^*ju\u0016DQ\u0001\u0016\u0007A\u0002U\u000b1$\\5o\u001dVl\u0007k\\:u'\",hM\u001a7f!\u0006\u0014H/\u001b;j_:\u001c\bcA\u0016/\r\u0002")
public class CoalesceShufflePartitionsSuite
extends SparkFunSuite {
    private Option<SparkSession> originalActiveSparkSession;
    private Option<SparkSession> originalInstantiatedSparkSession;
    private final int numInputPartitions;

    private Option<SparkSession> originalActiveSparkSession() {
        return this.originalActiveSparkSession;
    }

    private void originalActiveSparkSession_$eq(Option<SparkSession> x$1) {
        this.originalActiveSparkSession = x$1;
    }

    private Option<SparkSession> originalInstantiatedSparkSession() {
        return this.originalInstantiatedSparkSession;
    }

    private void originalInstantiatedSparkSession_$eq(Option<SparkSession> x$1) {
        this.originalInstantiatedSparkSession = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.originalActiveSparkSession_$eq((Option<SparkSession>)SparkSession$.MODULE$.getActiveSession());
        this.originalInstantiatedSparkSession_$eq((Option<SparkSession>)SparkSession$.MODULE$.getDefaultSession());
        SparkSession$.MODULE$.clearActiveSession();
        SparkSession$.MODULE$.clearDefaultSession();
    }

    public void afterAll() {
        try {
            this.originalActiveSparkSession().foreach((Function1 & Serializable & scala.Serializable)ctx -> {
                SparkSession$.MODULE$.setActiveSession(ctx);
                return BoxedUnit.UNIT;
            });
            this.originalInstantiatedSparkSession().foreach((Function1 & Serializable & scala.Serializable)ctx -> {
                SparkSession$.MODULE$.setDefaultSession(ctx);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            super.afterAll();
        }
    }

    public int numInputPartitions() {
        return this.numInputPartitions;
    }

    public void withSparkSession(Function1<SparkSession, BoxedUnit> f, int targetPostShuffleInputSize, Option<Object> minNumPostShufflePartitions) {
        SparkConf sparkConf;
        SparkConf sparkConf2 = new SparkConf(false).setMaster("local[*]").setAppName("test").set(UI$.MODULE$.UI_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false)).set(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key(), "5").set(SQLConf$.MODULE$.COALESCE_PARTITIONS_INITIAL_PARTITION_NUM().key(), "5").set(SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key(), "true").set(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key(), "-1").set(SQLConf$.MODULE$.ADVISORY_PARTITION_SIZE_IN_BYTES().key(), ((Object)BoxesRunTime.boxToInteger((int)targetPostShuffleInputSize)).toString());
        Option<Object> option = minNumPostShufflePartitions;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            sparkConf = sparkConf2.set(SQLConf$.MODULE$.COALESCE_PARTITIONS_MIN_PARTITION_NUM().key(), ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString());
        } else if (None$.MODULE$.equals(option)) {
            sparkConf = sparkConf2.set(SQLConf$.MODULE$.COALESCE_PARTITIONS_MIN_PARTITION_NUM().key(), "1");
        } else {
            throw new MatchError(option);
        }
        SparkSession spark = SparkSession$.MODULE$.builder().config(sparkConf2).getOrCreate();
        try {
            f.apply((Object)spark);
        }
        finally {
            spark.stop();
        }
    }

    public static final /* synthetic */ void $anonfun$new$3(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 20 as key", "id as value"}));
        Dataset agg = df.groupBy("key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)agg, (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])spark.range(0L, 20L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "50 as cnt"})).collect()), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)agg.queryExecution().executedPlan()).executedPlan();
        Seq shuffleReaders = finalPlan.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                CustomShuffleReaderExec customShuffleReaderExec;
                A1 A1 = x1;
                Object object = A1 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)A1) ? customShuffleReaderExec : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                CustomShuffleReaderExec customShuffleReaderExec;
                SparkPlan sparkPlan2 = x1;
                boolean bl = sparkPlan2 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)sparkPlan2);
                return bl;
            }
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReaders.length()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            shuffleReaders.foreach((Function1 & Serializable & scala.Serializable)reader -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)reader.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = numPartitions;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            shuffleReaders.foreach((Function1 & Serializable & scala.Serializable)reader -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)reader.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$new$7(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df1 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key1", "id as value1"}));
        Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"}));
        Dataset join = df1.join(df2, functions$.MODULE$.col("key1").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key1"), functions$.MODULE$.col("value2")}));
        Dataset expectedAnswer = spark.range(0L, 1000L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key", "id as value"})).union(spark.range(0L, 1000L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key", "id as value"})));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)join, (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])expectedAnswer.collect()), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)join.queryExecution().executedPlan()).executedPlan();
        Seq shuffleReaders = finalPlan.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                CustomShuffleReaderExec customShuffleReaderExec;
                A1 A1 = x2;
                Object object = A1 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)A1) ? customShuffleReaderExec : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                CustomShuffleReaderExec customShuffleReaderExec;
                SparkPlan sparkPlan2 = x2;
                boolean bl = sparkPlan2 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)sparkPlan2);
                return bl;
            }
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReaders.length()));
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            shuffleReaders.foreach((Function1 & Serializable & scala.Serializable)reader -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)reader.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = numPartitions;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            shuffleReaders.foreach((Function1 & Serializable & scala.Serializable)reader -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)reader.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$new$11(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df1 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key1", "id as value1"})).groupBy("key1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key1", "cnt1"}));
        Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"})).groupBy("key2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key2", "cnt2"}));
        Dataset join = df1.join(df2, functions$.MODULE$.col("key1").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key1"), functions$.MODULE$.col("cnt2")}));
        Dataset expectedAnswer = spark.range(0L, 500L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "2 as cnt"}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)join, (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])expectedAnswer.collect()), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)join.queryExecution().executedPlan()).executedPlan();
        Seq shuffleReaders = finalPlan.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                CustomShuffleReaderExec customShuffleReaderExec;
                A1 A1 = x3;
                Object object = A1 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)A1) ? customShuffleReaderExec : function1.apply(x3);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x3) {
                CustomShuffleReaderExec customShuffleReaderExec;
                SparkPlan sparkPlan2 = x3;
                boolean bl = sparkPlan2 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)sparkPlan2);
                return bl;
            }
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReaders.length()));
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            shuffleReaders.foreach((Function1 & Serializable & scala.Serializable)reader -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)reader.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = numPartitions;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            shuffleReaders.foreach((Function1 & Serializable & scala.Serializable)reader -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)reader.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$new$15(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df1 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key1", "id as value1"})).groupBy("key1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key1", "cnt1"}));
        Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"}));
        Dataset join = df1.join(df2, functions$.MODULE$.col("key1").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key1"), functions$.MODULE$.col("cnt1"), functions$.MODULE$.col("value2")}));
        Dataset expectedAnswer = spark.range(0L, 1000L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key", "2 as cnt", "id as value"}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)join, (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])expectedAnswer.collect()), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)join.queryExecution().executedPlan()).executedPlan();
        Seq shuffleReaders = finalPlan.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                CustomShuffleReaderExec customShuffleReaderExec;
                A1 A1 = x4;
                Object object = A1 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)A1) ? customShuffleReaderExec : function1.apply(x4);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x4) {
                CustomShuffleReaderExec customShuffleReaderExec;
                SparkPlan sparkPlan2 = x4;
                boolean bl = sparkPlan2 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)sparkPlan2);
                return bl;
            }
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReaders.length()));
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            shuffleReaders.foreach((Function1 & Serializable & scala.Serializable)reader -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)reader.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = numPartitions;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            shuffleReaders.foreach((Function1 & Serializable & scala.Serializable)reader -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)reader.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$new$19(CoalesceShufflePartitionsSuite $this, SparkSession spark) {
        try {
            spark.range(1000L).write().bucketBy(30, "id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable("t");
            Dataset df1 = spark.read().table("t");
            Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"}));
            Dataset join = df1.join(df2, functions$.MODULE$.col("id").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("value2")}));
            Dataset expectedAnswer = spark.range(0L, 500L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500", "id as value"})).union(spark.range(500L, 1000L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500", "id as value"})));
            QueryTest$.MODULE$.checkAnswer((Dataset<Row>)join, (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])expectedAnswer.collect()), QueryTest$.MODULE$.checkAnswer$default$3());
            SparkPlan finalPlan = ((AdaptiveSparkPlanExec)join.queryExecution().executedPlan()).executedPlan();
            Seq shuffleReaders = finalPlan.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                    CustomShuffleReaderExec customShuffleReaderExec;
                    A1 A1 = x5;
                    Object object = A1 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)A1) ? customShuffleReaderExec : function1.apply(x5);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x5) {
                    CustomShuffleReaderExec customShuffleReaderExec;
                    SparkPlan sparkPlan2 = x5;
                    boolean bl = sparkPlan2 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)sparkPlan2);
                    return bl;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReaders.length()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        }
        finally {
            spark.sql("drop table t");
        }
    }

    public static final /* synthetic */ void $anonfun$new$1(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions) {
        String string;
        Option option = minNumPostShufflePartitions;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            string = new StringBuilder(31).append("(minNumPostShufflePartitions: ").append(numPartitions).append(")").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError((Object)option);
        }
        String testNameNote = string;
        $this.test(new StringBuilder(54).append("determining the number of reducers: aggregate operator").append(testNameNote).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable test = (Function1 & Serializable & scala.Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$3($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 2000, (Option<Object>)minNumPostShufflePartitions);
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        $this.test(new StringBuilder(49).append("determining the number of reducers: join operator").append(testNameNote).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable test = (Function1 & Serializable & scala.Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$7($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 16384, (Option<Object>)minNumPostShufflePartitions);
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        $this.test(new StringBuilder(51).append("determining the number of reducers: complex query 1").append(testNameNote).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable test = (Function1 & Serializable & scala.Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$11($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 16384, (Option<Object>)minNumPostShufflePartitions);
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        $this.test(new StringBuilder(51).append("determining the number of reducers: complex query 2").append(testNameNote).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable test = (Function1 & Serializable & scala.Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$15($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 12000, (Option<Object>)minNumPostShufflePartitions);
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        $this.test(new StringBuilder(60).append("determining the number of reducers: plan already partitioned").append(testNameNote).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable test = (Function1 & Serializable & scala.Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$19($this, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 12000, (Option<Object>)minNumPostShufflePartitions);
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
    }

    public static final /* synthetic */ void $anonfun$new$21(SparkSession spark) {
        Seq reusedStages;
        Seq leafStages;
        Seq level1Stages;
        spark.sql("SET spark.sql.exchange.reuse=true");
        Dataset df = spark.range(1L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id AS key", "id AS value"}));
        Dataset resultDf = df.join(df, "key").join(df, "key");
        Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)resultDf, (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)resultDf.queryExecution().executedPlan()).executedPlan();
        Seq $org_scalatest_assert_macro_left = finalPlan.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Object object;
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan r;
                A1 A1 = x6;
                if (A1 instanceof ShuffleQueryStageExec && (r = (shuffleQueryStageExec = (ShuffleQueryStageExec)A1).plan()) instanceof ReusedExchangeExec) {
                    ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)r;
                    object = reusedExchangeExec;
                } else {
                    object = function1.apply(x6);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x6) {
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan r;
                SparkPlan sparkPlan2 = x6;
                boolean bl = sparkPlan2 instanceof ShuffleQueryStageExec && (r = (shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan2).plan()) instanceof ReusedExchangeExec;
                return bl;
            }
        });
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        Seq $org_scalatest_assert_macro_left2 = finalPlan.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                CustomShuffleReaderExec customShuffleReaderExec;
                A1 A1 = x7;
                Object object = A1 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)A1) ? customShuffleReaderExec : function1.apply(x7);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x7) {
                CustomShuffleReaderExec customShuffleReaderExec;
                SparkPlan sparkPlan2 = x7;
                boolean bl = sparkPlan2 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)sparkPlan2);
                return bl;
            }
        });
        int $org_scalatest_assert_macro_right2 = 3;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
        Dataset grouped = df.groupBy("key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.max("value").as("value"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
        Dataset resultDf2 = grouped.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key").$plus((Object)BoxesRunTime.boxToInteger((int)1))})).max((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})).union(grouped.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key").$plus((Object)BoxesRunTime.boxToInteger((int)2))})).max((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})));
        Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)0)}));
        Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0)}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)resultDf2, (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan2 = ((AdaptiveSparkPlanExec)resultDf2.queryExecution().executedPlan()).executedPlan();
        Seq $org_scalatest_assert_macro_left3 = level1Stages = finalPlan2.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                QueryStageExec queryStageExec;
                A1 A1 = x8;
                Object object = A1 instanceof QueryStageExec ? (queryStageExec = (QueryStageExec)A1) : function1.apply(x8);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x8) {
                SparkPlan sparkPlan2 = x8;
                boolean bl = sparkPlan2 instanceof QueryStageExec;
                return bl;
            }
        });
        int $org_scalatest_assert_macro_right3 = 2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        Seq $org_scalatest_assert_macro_left4 = leafStages = (Seq)level1Stages.flatMap((Function1 & Serializable & scala.Serializable)stage -> {
            void var1_1;
            Seq children;
            Seq $org_scalatest_assert_macro_left = children = stage.plan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                    QueryStageExec queryStageExec;
                    A1 A1 = x9;
                    Object object = A1 instanceof QueryStageExec ? (queryStageExec = (QueryStageExec)A1) : function1.apply(x9);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x9) {
                    SparkPlan sparkPlan2 = x9;
                    boolean bl = sparkPlan2 instanceof QueryStageExec;
                    return bl;
                }
            });
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            return var1_1;
        }, Seq$.MODULE$.canBuildFrom());
        int $org_scalatest_assert_macro_right4 = 2;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        Seq $org_scalatest_assert_macro_left5 = reusedStages = (Seq)level1Stages.flatMap((Function1 & Serializable & scala.Serializable)stage -> stage.plan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                Object object;
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan r;
                A1 A1 = x10;
                if (A1 instanceof ShuffleQueryStageExec && (r = (shuffleQueryStageExec = (ShuffleQueryStageExec)A1).plan()) instanceof ReusedExchangeExec) {
                    ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)r;
                    object = reusedExchangeExec;
                } else {
                    object = function1.apply(x10);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x10) {
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan r;
                SparkPlan sparkPlan2 = x10;
                boolean bl = sparkPlan2 instanceof ShuffleQueryStageExec && (r = (shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan2).plan()) instanceof ReusedExchangeExec;
                return bl;
            }
        }), Seq$.MODULE$.canBuildFrom());
        int $org_scalatest_assert_macro_right5 = 1;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
    }

    public static final /* synthetic */ void $anonfun$new$25(SparkSession spark) {
        Dataset ds = spark.range(3L);
        Dataset resultDf = ds.repartition(2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{ds.col("id")})).toDF();
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)resultDf, (Seq<Row>)((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))})), Seq$.MODULE$.canBuildFrom())), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)resultDf.queryExecution().executedPlan()).executedPlan();
        Seq $org_scalatest_assert_macro_left = finalPlan.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                CustomShuffleReaderExec customShuffleReaderExec;
                A1 A1 = x11;
                Object object = A1 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)A1) ? customShuffleReaderExec : function1.apply(x11);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x11) {
                CustomShuffleReaderExec customShuffleReaderExec;
                SparkPlan sparkPlan2 = x11;
                boolean bl = sparkPlan2 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)sparkPlan2);
                return bl;
            }
        });
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
    }

    public static final /* synthetic */ void $anonfun$new$28(SparkSession spark) {
        Dataset df1 = spark.range(3L).join(spark.range(3L), "id").toDF();
        Dataset df2 = spark.range(3L).groupBy((Seq)Nil$.MODULE$).sum((Seq)Nil$.MODULE$);
        Dataset resultDf = df1.union(df2);
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)resultDf, (Seq<Row>)((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))})), Seq$.MODULE$.canBuildFrom())), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)resultDf.queryExecution().executedPlan()).executedPlan();
        Seq $org_scalatest_assert_macro_left = finalPlan.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                CustomShuffleReaderExec customShuffleReaderExec;
                A1 A1 = x12;
                Object object = A1 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)A1) ? customShuffleReaderExec : function1.apply(x12);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x12) {
                CustomShuffleReaderExec customShuffleReaderExec;
                SparkPlan sparkPlan2 = x12;
                boolean bl = sparkPlan2 instanceof CustomShuffleReaderExec && CoalescedShuffleReader$.MODULE$.unapply(customShuffleReaderExec = (CustomShuffleReaderExec)sparkPlan2);
                return bl;
            }
        });
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
    }

    public CoalesceShufflePartitionsSuite() {
        this.numInputPartitions = 10;
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)5)), None$.MODULE$}))).foreach((Function1 & Serializable & scala.Serializable)minNumPostShufflePartitions -> {
            CoalesceShufflePartitionsSuite.$anonfun$new$1(this, minNumPostShufflePartitions);
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-24705 adaptive query execution works correctly when exchange reuse enabled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable test = (Function1 & Serializable & scala.Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$21(spark);
                return BoxedUnit.UNIT;
            };
            this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 4, (Option<Object>)None$.MODULE$);
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
        this.test("Do not reduce the number of shuffle partition for repartition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable test = (Function1 & Serializable & scala.Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$25(spark);
                return BoxedUnit.UNIT;
            };
            this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 200, (Option<Object>)None$.MODULE$);
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        this.test("Union two datasets with different pre-shuffle partition number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable test = (Function1 & Serializable & scala.Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$28(spark);
                return BoxedUnit.UNIT;
            };
            this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 100, (Option<Object>)None$.MODULE$);
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
    }
}

