/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00013qAB\u0004\u0011\u0002\u0007\u0005!\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0003&\u0001\u0019Ea\u0005C\u0004;\u0001\t\u0007i\u0011C\u001e\t\u000fq\u0002!\u0019!D\tw!)Q\b\u0001C\u0005}\ty\u0011\t\u001c;feR\u000b'\r\\3UKN$8O\u0003\u0002\t\u0013\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0004\u0001M9\u0002C\u0001\u000b\u0016\u001b\u0005Y\u0011B\u0001\f\f\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011\u0001dG\u0007\u00023)\u0011!$C\u0001\u0005i\u0016\u001cH/\u0003\u0002\u001d3\t\u00112\u000b[1sK\u0012\u001c\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019!\u0013N\\5uIQ\tq\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0003V]&$\u0018\u0001E4fiR\u000b'\r\\3NKR\fG-\u0019;b)\t9S\u0006\u0005\u0002)W5\t\u0011F\u0003\u0002+\u000f\u000591-\u0019;bY><\u0017B\u0001\u0017*\u0005\u0015!\u0016M\u00197f\u0011\u0015q#\u00011\u00010\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0005\u00021o9\u0011\u0011'\u000e\t\u0003e\u0005j\u0011a\r\u0006\u0003iE\ta\u0001\u0010:p_Rt\u0014B\u0001\u001c\"\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001(\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\n\u0013aE2bi\u0006dwnZ!oI:\u000bW.Z:qC\u000e,W#A\u0018\u0002\u0011Y\u0014di\u001c:nCR\fQBZ;mYR\u000b'\r\\3OC6,GCA\u0018@\u0011\u0015qS\u00011\u00010\u0001")
public interface AlterTableTests
extends SharedSparkSession {
    public Table getTableMetadata(String var1);

    public String catalogAndNamespace();

    public String v2Format();

    private String fullTableName(String tableName) {
        return this.catalogAndNamespace().isEmpty() ? new StringBuilder(8).append("default.").append(tableName).toString() : new StringBuilder(10).append(this.catalogAndNamespace()).append("table_name").toString();
    }

    public static void $init$(AlterTableTests $this) {
        $this.test("AlterTable: table does not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t2 = new StringBuilder(10).append($this.catalogAndNamespace()).append("fake_table").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t2).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(37).append("ALTER TABLE ").append($this.catalogAndNamespace()).append("table_name DROP COLUMN id").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "Table not found";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        $this.test("AlterTable: change rejected by implementation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                SparkException exc = (SparkException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(27).append("ALTER TABLE ").append(t).append(" DROP COLUMN id").toString()), ClassTag$.MODULE$.apply(SparkException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Unsupported table change";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "Cannot drop all fields";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right3 = tableName;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)IntegerType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        $this.test("AlterTable: add top-level column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(35).append("ALTER TABLE ").append(t).append(" ADD COLUMN data string").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        $this.test("AlterTable: add column with NOT NULL", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(44).append("ALTER TABLE ").append(t).append(" ADD COLUMN data string NOT NULL").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("data", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        $this.test("AlterTable: add column with comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(49).append("ALTER TABLE ").append(t).append(" ADD COLUMN data string COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("data", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc")})));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        $this.test("AlterTable: add column with interval type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(65).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: double, y: double>) USING ").append($this.v2Format()).toString());
                AnalysisException e1 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(37).append("ALTER TABLE ").append(t).append(" ADD COLUMN data interval").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129)))));
                String $org_scalatest_assert_macro_left = e1.getMessage();
                String $org_scalatest_assert_macro_right = "Cannot use interval type in the table schema.";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
                AnalysisException e2 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(40).append("ALTER TABLE ").append(t).append(" ADD COLUMN point.z interval").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132)))));
                String $org_scalatest_assert_macro_left2 = e2.getMessage();
                String $org_scalatest_assert_macro_right2 = "Cannot use interval type in the table schema.";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        $this.test("AlterTable: add column with position", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(43).append("CREATE TABLE ").append(t).append(" (point struct<x: int>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(38).append("ALTER TABLE ").append(t).append(" ADD COLUMN a string FIRST").toString());
                String tableName = $this.fullTableName(t);
                StructType $org_scalatest_assert_macro_left = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right = new StructType().add("a", (DataType)StringType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$));
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
                $this.sql().apply((Object)new StringBuilder(44).append("ALTER TABLE ").append(t).append(" ADD COLUMN b string AFTER point").toString());
                StructType $org_scalatest_assert_macro_left2 = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("a", (DataType)StringType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$)).add("b", (DataType)StringType$.MODULE$);
                StructType structType3 = $org_scalatest_assert_macro_left2;
                StructType structType4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
                AnalysisException e1 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(48).append("ALTER TABLE ").append(t).append(" ADD COLUMN c string AFTER non_exist").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154)))));
                String $org_scalatest_assert_macro_left3 = e1.getMessage();
                String $org_scalatest_assert_macro_right3 = "Couldn't find the reference column";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
                $this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" ADD COLUMN point.y int FIRST").toString());
                StructType $org_scalatest_assert_macro_left4 = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("a", (DataType)StringType$.MODULE$).add("point", (DataType)new StructType().add("y", (DataType)IntegerType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$)).add("b", (DataType)StringType$.MODULE$);
                StructType structType5 = $org_scalatest_assert_macro_left4;
                StructType structType6 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType5 != null ? !structType5.equals(structType6) : structType6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
                $this.sql().apply((Object)new StringBuilder(43).append("ALTER TABLE ").append(t).append(" ADD COLUMN point.z int AFTER x").toString());
                StructType $org_scalatest_assert_macro_left5 = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right5 = new StructType().add("a", (DataType)StringType$.MODULE$).add("point", (DataType)new StructType().add("y", (DataType)IntegerType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$)).add("b", (DataType)StringType$.MODULE$);
                StructType structType7 = $org_scalatest_assert_macro_left5;
                StructType structType8 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(structType7 != null ? !structType7.equals(structType8) : structType8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
                AnalysisException e2 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(52).append("ALTER TABLE ").append(t).append(" ADD COLUMN point.x2 int AFTER non_exist").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175)))));
                String $org_scalatest_assert_macro_left6 = e2.getMessage();
                String $org_scalatest_assert_macro_right6 = "Couldn't find the reference column";
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        $this.test("SPARK-30814: add column with position referencing new columns being added", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(74).append("CREATE TABLE ").append(t).append(" (a string, b int, point struct<x: double, y: double>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(70).append("ALTER TABLE ").append(t).append(" ADD COLUMNS (x int AFTER a, y int AFTER x, z int AFTER y)").toString());
                String tableName = $this.fullTableName(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)$this.getTableMetadata(tableName).schema());
                StructType $org_scalatest_assert_macro_right = new StructType().add("a", (DataType)StringType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$).add("b", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
                $this.sql().apply((Object)new StringBuilder(74).append("ALTER TABLE ").append(t).append(" ADD COLUMNS (point.z double AFTER x, point.zz double AFTER z)").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)$this.getTableMetadata(tableName).schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("a", (DataType)StringType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$).add("b", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)DoubleType$.MODULE$).add("z", (DataType)DoubleType$.MODULE$).add("zz", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
                AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(50).append("ALTER TABLE ").append(t).append(" ADD COLUMNS (yy int AFTER xx, xx int)").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212)))));
                String $org_scalatest_assert_macro_left3 = e.getMessage();
                String $org_scalatest_assert_macro_right3 = "Couldn't find the reference column for AFTER xx at root";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        $this.test("AlterTable: add multiple columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(64).append("ALTER TABLE ").append(t).append(" ADD COLUMNS data string COMMENT 'doc', ts timestamp").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("data", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), new StructField("ts", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        $this.test("AlterTable: add nested column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(65).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: double, y: double>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(38).append("ALTER TABLE ").append(t).append(" ADD COLUMN point.z double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        $this.test("AlterTable: add nested column to map key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE ").append(t).append(" (id int, points map<struct<x: double, y: double>, bigint>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(43).append("ALTER TABLE ").append(t).append(" ADD COLUMN points.key.z double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        $this.test("AlterTable: add nested column to map value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE ").append(t).append(" (id int, points map<string, struct<x: double, y: double>>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(45).append("ALTER TABLE ").append(t).append(" ADD COLUMN points.value.z double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        $this.test("AlterTable: add nested column to array element", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE ").append(t).append(" (id int, points array<struct<x: double, y: double>>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(47).append("ALTER TABLE ").append(t).append(" ADD COLUMN points.element.z double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        $this.test("AlterTable: add complex column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(66).append("ALTER TABLE ").append(t).append(" ADD COLUMN points array<struct<x: double, y: double>>").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        $this.test("AlterTable: add nested column with comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE ").append(t).append(" (id int, points array<struct<x: double, y: double>>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(61).append("ALTER TABLE ").append(t).append(" ADD COLUMN points.element.z double COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc")})))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        $this.test("AlterTable: add nested column parent must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(38).append("ALTER TABLE ").append(t).append(" ADD COLUMN point.z double").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "point";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "missing field";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        $this.test("AlterTable: add column - new column should not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(284).append("CREATE TABLE ").append(t).append(" (\n           |id int,\n           |point struct<x: double, y: double>,\n           |arr array<struct<x: double, y: double>>,\n           |mk map<struct<x: double, y: double>, string>,\n           |mv map<string, struct<x: double, y: double>>\n           |)\n           |USING ").append($this.v2Format()).toString())).stripMargin());
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "point.x", "arr.element.x", "mk.key.x", "mv.value.x"}))).foreach((Function1 & Serializable & scala.Serializable)field -> {
                    AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(32).append("ALTER TABLE ").append(t).append(" ADD COLUMNS ").append((String)field).append(" double").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379))))));
                    String $org_scalatest_assert_macro_left = e.getMessage();
                    String $org_scalatest_assert_macro_right = "add";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
                    String $org_scalatest_assert_macro_left2 = e.getMessage();
                    String $org_scalatest_assert_macro_right2 = new StringBuilder(15).append((String)field).append(" already exists").toString();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
                });
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        $this.test("AlterTable: update column type int -> long", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(40).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id TYPE bigint").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)LongType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        $this.test("AlterTable: update column type to interval", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(42).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id TYPE interval").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406)))));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "id to interval type";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        $this.test("AlterTable: SET/DROP NOT NULL", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(41).append("CREATE TABLE ").append(t).append(" (id bigint NOT NULL) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id SET NOT NULL").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)LongType$.MODULE$, false);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
                $this.sql().apply((Object)new StringBuilder(42).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id DROP NOT NULL").toString());
                Table table2 = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)table2.name());
                String $org_scalatest_assert_macro_right3 = tableName;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)table2.schema());
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)LongType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
                AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id SET NOT NULL").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427)))));
                String $org_scalatest_assert_macro_left5 = e.message();
                String $org_scalatest_assert_macro_right5 = "Cannot change nullable column to non-nullable";
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        $this.test("AlterTable: update nested type float -> double", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(64).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: float, y: double>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(45).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.x TYPE double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        $this.test("AlterTable: update column with struct type fails", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(65).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: double, y: double>) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(76).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point TYPE struct<x: double, y: double, z: double>").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "point";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "update a struct by updating its fields";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right3 = tableName;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        $this.test("AlterTable: update column with array type fails", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id int, points array<int>) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(49).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points TYPE array<long>").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "update the element by updating points.element";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right2 = tableName;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
        $this.test("AlterTable: update column array element type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id int, points array<int>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(50).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.element TYPE long").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
        $this.test("AlterTable: update column with map type fails", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(49).append("CREATE TABLE ").append(t).append(" (id int, m map<string, int>) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(50).append("ALTER TABLE ").append(t).append(" ALTER COLUMN m TYPE map<string, long>").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "update a map by updating m.key or m.value";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right2 = tableName;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("m", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
        $this.test("AlterTable: update column map value type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(49).append("CREATE TABLE ").append(t).append(" (id int, m map<string, int>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(43).append("ALTER TABLE ").append(t).append(" ALTER COLUMN m.value TYPE long").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("m", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
        $this.test("AlterTable: update nested type in map key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id int, points map<struct<x: float, y: double>, bigint>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(50).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.key.x TYPE double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 549));
        $this.test("AlterTable: update nested type in map value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id int, points map<string, struct<x: float, y: double>>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(52).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.value.x TYPE double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
        $this.test("AlterTable: update nested type in array", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(72).append("CREATE TABLE ").append(t).append(" (id int, points array<struct<x: float, y: double>>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(54).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.element.x TYPE double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 596));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
        $this.test("AlterTable: update column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(42).append("ALTER TABLE ").append(t).append(" ALTER COLUMN data TYPE string").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 610)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "data";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "missing field";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 605));
        $this.test("AlterTable: nested update column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(45).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.x TYPE double").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 624)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "point.x";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "missing field";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 619));
        $this.test("AlterTable: update column type must be compatible", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id TYPE boolean").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "id";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "int cannot be cast to boolean";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 643));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
        $this.test("AlterTable: update column comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(42).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc")})));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 657));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
        $this.test("AlterTable: update column position", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE ").append(t).append(" (a int, b int, point struct<x: int, y: int, z: int>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(33).append("ALTER TABLE ").append(t).append(" ALTER COLUMN b FIRST").toString());
                String tableName = $this.fullTableName(t);
                StructType $org_scalatest_assert_macro_left = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right = new StructType().add("b", (DataType)IntegerType$.MODULE$).add("a", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$));
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
                $this.sql().apply((Object)new StringBuilder(39).append("ALTER TABLE ").append(t).append(" ALTER COLUMN b AFTER point").toString());
                StructType $org_scalatest_assert_macro_left2 = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("a", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$)).add("b", (DataType)IntegerType$.MODULE$);
                StructType structType3 = $org_scalatest_assert_macro_left2;
                StructType structType4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
                AnalysisException e1 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(43).append("ALTER TABLE ").append(t).append(" ALTER COLUMN b AFTER non_exist").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685)))));
                String $org_scalatest_assert_macro_left3 = e1.getMessage();
                String $org_scalatest_assert_macro_right3 = "Couldn't resolve positional argument";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 687));
                $this.sql().apply((Object)new StringBuilder(39).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.y FIRST").toString());
                StructType $org_scalatest_assert_macro_left4 = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("a", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("y", (DataType)IntegerType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$)).add("b", (DataType)IntegerType$.MODULE$);
                StructType structType5 = $org_scalatest_assert_macro_left4;
                StructType structType6 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType5 != null ? !structType5.equals(structType6) : structType6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
                $this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.y AFTER z").toString());
                StructType $org_scalatest_assert_macro_left5 = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right5 = new StructType().add("a", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$)).add("b", (DataType)IntegerType$.MODULE$);
                StructType structType7 = $org_scalatest_assert_macro_left5;
                StructType structType8 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(structType7 != null ? !structType7.equals(structType8) : structType8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
                AnalysisException e2 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(49).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.y AFTER non_exist").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707)))));
                String $org_scalatest_assert_macro_left6 = e2.getMessage();
                String $org_scalatest_assert_macro_right6 = "Couldn't resolve positional argument";
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
                ((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(37).append("ALTER TABLE ").append(t).append(" ALTER COLUMN a.y AFTER x").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 661));
        $this.test("AlterTable: update nested column comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(65).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: double, y: double>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(47).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.y COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc")}))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
        $this.test("AlterTable: update nested column comment in map key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE ").append(t).append(" (id int, points map<struct<x: double, y: double>, bigint>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(52).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.key.y COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 745));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc")}))), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 746));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 735));
        $this.test("AlterTable: update nested column comment in map value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE ").append(t).append(" (id int, points map<string, struct<x: double, y: double>>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(54).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.value.y COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc")})))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        $this.test("AlterTable: update nested column comment in array", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE ").append(t).append(" (id int, points array<struct<x: double, y: double>>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(56).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.element.y COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc")})))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 783));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
        $this.test("AlterTable: comment update column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(44).append("ALTER TABLE ").append(t).append(" ALTER COLUMN data COMMENT 'doc'").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 796)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "data";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 800));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "missing field";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 791));
        $this.test("AlterTable: nested comment update column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(47).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.x COMMENT 'doc'").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 810)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "point.x";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 814));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "missing field";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 815));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 805));
        $this.test("AlterTable: rename column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(40).append("ALTER TABLE ").append(t).append(" RENAME COLUMN id TO user_id").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 828));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("user_id", (DataType)IntegerType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 829));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 819));
        $this.test("AlterTable: rename nested column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(65).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: double, y: double>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(39).append("ALTER TABLE ").append(t).append(" RENAME COLUMN point.y TO t").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("t", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 843));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 833));
        $this.test("AlterTable: rename nested column in map key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id int, point map<struct<x: double, y: double>, bigint>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(43).append("ALTER TABLE ").append(t).append(" RENAME COLUMN point.key.y TO t").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("t", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 862));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 851));
        $this.test("AlterTable: rename nested column in map value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE ").append(t).append(" (id int, points map<string, struct<x: double, y: double>>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(46).append("ALTER TABLE ").append(t).append(" RENAME COLUMN points.value.y TO t").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 880));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("t", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 881));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 870));
        $this.test("AlterTable: rename nested column in array element", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE ").append(t).append(" (id int, points array<struct<x: double, y: double>>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(48).append("ALTER TABLE ").append(t).append(" RENAME COLUMN points.element.y TO t").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 898));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("t", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 899));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 889));
        $this.test("AlterTable: rename column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(46).append("ALTER TABLE ").append(t).append(" RENAME COLUMN data TO some_string").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 912)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "data";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 916));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "missing field";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 917));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 907));
        $this.test("AlterTable: nested rename column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(39).append("ALTER TABLE ").append(t).append(" RENAME COLUMN point.x TO z").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 926)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "point.x";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 930));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "missing field";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 931));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 921));
        $this.test("AlterTable: rename column - new name should not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(309).append("CREATE TABLE ").append(t).append(" (\n           |id int,\n           |user_id int,\n           |point struct<x: double, y: double>,\n           |arr array<struct<x: double, y: double>>,\n           |mk map<struct<x: double, y: double>, string>,\n           |mv map<string, struct<x: double, y: double>>\n           |)\n           |USING ").append($this.v2Format()).toString())).stripMargin());
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"user_id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point.x"), (Object)"y"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"arr.element.x"), (Object)"y"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mk.key.x"), (Object)"y"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mv.value.x"), (Object)"y")}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String field = (String)tuple2._1();
                    String newName = (String)tuple2._2();
                    AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(31).append("ALTER TABLE ").append(t).append(" RENAME COLUMN ").append(field).append(" TO ").append(newName).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 956))))));
                    String $org_scalatest_assert_macro_left = e.getMessage();
                    String $org_scalatest_assert_macro_right = "rename";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 959));
                    String $org_scalatest_assert_macro_left2 = e.getMessage();
                    String $org_scalatest_assert_macro_right2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])field.split("\\."))).init())).$colon$plus((Object)newName, ClassTag$.MODULE$.apply(String.class)))).mkString(".");
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 960));
                    String $org_scalatest_assert_macro_left3 = e.getMessage();
                    String $org_scalatest_assert_macro_right3 = "already exists";
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                    Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 961));
                    return assertion;
                });
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 935));
        $this.test("AlterTable: drop column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE ").append(t).append(" (id int, data string) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(29).append("ALTER TABLE ").append(t).append(" DROP COLUMN data").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 975));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 976));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 966));
        $this.test("AlterTable: drop nested column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(76).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: double, y: double, t: double>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(32).append("ALTER TABLE ").append(t).append(" DROP COLUMN point.t").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 990));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 991));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 980));
        $this.test("AlterTable: drop nested column in map key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id int, point map<struct<x: double, y: double>, bigint>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(36).append("ALTER TABLE ").append(t).append(" DROP COLUMN point.key.y").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1009));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1010));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 999));
        $this.test("AlterTable: drop nested column in map value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE ").append(t).append(" (id int, points map<string, struct<x: double, y: double>>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(39).append("ALTER TABLE ").append(t).append(" DROP COLUMN points.value.y").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1027));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1028));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1017));
        $this.test("AlterTable: drop nested column in array element", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE ").append(t).append(" (id int, points array<struct<x: double, y: double>>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" DROP COLUMN points.element.y").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1044));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1045));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1035));
        $this.test("AlterTable: drop column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(29).append("ALTER TABLE ").append(t).append(" DROP COLUMN data").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1057)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "data";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1061));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "missing field";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1062));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1052));
        $this.test("AlterTable: nested drop column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(32).append("ALTER TABLE ").append(t).append(" DROP COLUMN point.x").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1071)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "point.x";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1075));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "missing field";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1076));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1066));
        $this.test("AlterTable: set location", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(44).append("ALTER TABLE ").append(t).append(" SET LOCATION 's3://bucket/path'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1089));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.properties());
                java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)$this.v2Format()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"location"), (Object)"s3://bucket/path")})))).asJava();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1090));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1080));
        $this.test("AlterTable: set partition location", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(71).append("ALTER TABLE ").append(t).append(" PARTITION(ds='2017-06-10') SET LOCATION 's3://bucket/path'").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1100)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "ALTER TABLE SET LOCATION does not support partition for v2 tables";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1103));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1095));
        $this.test("AlterTable: set table property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(44).append("ALTER TABLE ").append(t).append(" SET TBLPROPERTIES ('test'='34')").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1117));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.properties());
                java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)$this.v2Format()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)"34")})))).asJava();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1118));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1108));
        $this.test("AlterTable: remove table property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(58).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).append(" TBLPROPERTIES('test' = '34')").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1131));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.properties());
                java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)$this.v2Format()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)"34")})))).asJava();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1132));
                $this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" UNSET TBLPROPERTIES ('test')").toString());
                Table updated = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)updated.name());
                String $org_scalatest_assert_macro_right3 = tableName;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1139));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)updated.properties());
                java.util.Map $org_scalatest_assert_macro_right4 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)$this.v2Format())})))).asJava();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1140));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1123));
        $this.test("AlterTable: replace columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t).append(" (col1 int, col2 int COMMENT 'c2') USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(65).append("ALTER TABLE ").append(t).append(" REPLACE COLUMNS (col2 string, col3 int COMMENT 'c3')").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1153));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("col2", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("col3", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("c3")})));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1154));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1144));
    }
}

