/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.log4j.Appender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.ThreadUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00112Aa\u0001\u0003\u0001\u001b!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C!;\tA2\u000b]1sWN+7o]5p]\n+\u0018\u000e\u001c3feN+\u0018\u000e^3\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0006\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\f\u0015\u0005I\u0011UMZ8sK\u0006sG-\u00114uKJ,\u0015m\u00195\u0002\rqJg.\u001b;?)\u0005Q\u0002CA\u000e\u0001\u001b\u0005!\u0011!C1gi\u0016\u0014X)Y2i)\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSR\u0004")
public class SparkSessionBuilderSuite
extends SparkFunSuite {
    public void afterEach() {
        SparkSession$.MODULE$.getActiveSession().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.stop();
            return BoxedUnit.UNIT;
        });
        SparkSession$.MODULE$.clearActiveSession();
        SparkSession$.MODULE$.getDefaultSession().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
        SparkSession$.MODULE$.clearDefaultSession();
    }

    public static final /* synthetic */ void $anonfun$new$22(Long v) {
        SparkSession$.MODULE$.builder().master("local").getOrCreate();
    }

    public static final /* synthetic */ void $anonfun$new$24(Long v) {
        SparkSession$.MODULE$.builder().master("local").config(package$.MODULE$.EXECUTOR_ALLOW_SPARK_CONTEXT().key(), true).getOrCreate().stop();
    }

    public static final /* synthetic */ boolean $anonfun$new$32(String msg$1, LoggingEvent x$3) {
        return x$3.getRenderedMessage().contains(msg$1);
    }

    public static final /* synthetic */ boolean $anonfun$new$35(String msg$2, LoggingEvent x$4) {
        return x$4.getRenderedMessage().contains(msg$2);
    }

    public SparkSessionBuilderSuite() {
        this.test("create with config options and propagate them to SparkContext and SparkSession", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").config(UI$.MODULE$.UI_ENABLED().key(), false).config("some-config", "v2").getOrCreate();
            String $org_scalatest_assert_macro_left = session.sparkContext().conf().get("some-config");
            String $org_scalatest_assert_macro_right = "v2";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            String $org_scalatest_assert_macro_left2 = session.conf().get("some-config");
            String $org_scalatest_assert_macro_right2 = "v2";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("use global default session", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession $org_scalatest_assert_macro_left = SparkSession$.MODULE$.builder().getOrCreate();
            SparkSession $org_scalatest_assert_macro_right = session;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparkSession != null ? !sparkSession.equals(sparkSession2) : sparkSession2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("sets default and active session", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option $org_scalatest_assert_macro_left = SparkSession$.MODULE$.getDefaultSession();
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Option option = $org_scalatest_assert_macro_left;
            None$ none$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(none$) : none$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            Option $org_scalatest_assert_macro_left2 = SparkSession$.MODULE$.getActiveSession();
            None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
            Option option2 = $org_scalatest_assert_macro_left2;
            None$ none$2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(none$2) : none$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            Option $org_scalatest_assert_macro_left3 = SparkSession$.MODULE$.getDefaultSession();
            Some $org_scalatest_assert_macro_right3 = new Some((Object)session);
            Option option3 = $org_scalatest_assert_macro_left3;
            Some some = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            Option $org_scalatest_assert_macro_left4 = SparkSession$.MODULE$.getActiveSession();
            Some $org_scalatest_assert_macro_right4 = new Some((Object)session);
            Option option4 = $org_scalatest_assert_macro_left4;
            Some some2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option4 != null ? !option4.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("get active or default session", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession $org_scalatest_assert_macro_left = SparkSession$.MODULE$.active();
            SparkSession $org_scalatest_assert_macro_right = session;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparkSession != null ? !sparkSession.equals(sparkSession2) : sparkSession2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession $org_scalatest_assert_macro_left2 = SparkSession$.MODULE$.active();
            SparkSession $org_scalatest_assert_macro_right2 = session;
            SparkSession sparkSession3 = $org_scalatest_assert_macro_left2;
            SparkSession sparkSession4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(sparkSession3 != null ? !sparkSession3.equals(sparkSession4) : sparkSession4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            SparkSession$.MODULE$.clearDefaultSession();
            this.intercept((Function0 & Serializable & scala.Serializable)() -> SparkSession$.MODULE$.active(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            session.stop();
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("config options are propagated to existing SparkSession", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkSession session1 = SparkSession$.MODULE$.builder().master("local").config("spark-config1", "a").getOrCreate();
            String $org_scalatest_assert_macro_left = session1.conf().get("spark-config1");
            String $org_scalatest_assert_macro_right = "a";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            SparkSession session2 = SparkSession$.MODULE$.builder().config("spark-config1", "b").getOrCreate();
            SparkSession $org_scalatest_assert_macro_left2 = session1;
            SparkSession $org_scalatest_assert_macro_right2 = session2;
            SparkSession sparkSession = $org_scalatest_assert_macro_left2;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(sparkSession != null ? !sparkSession.equals(sparkSession2) : sparkSession2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            String $org_scalatest_assert_macro_left3 = session1.conf().get("spark-config1");
            String $org_scalatest_assert_macro_right3 = "b";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("use session from active thread session and propagate config options", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkSession defaultSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession activeSession = defaultSession.newSession();
            SparkSession$.MODULE$.setActiveSession(activeSession);
            SparkSession session = SparkSession$.MODULE$.builder().config("spark-config2", "a").getOrCreate();
            SparkSession $org_scalatest_assert_macro_left = activeSession;
            SparkSession $org_scalatest_assert_macro_right = defaultSession;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, sparkSession == null ? sparkSession2 != null : !sparkSession.equals(sparkSession2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            SparkSession $org_scalatest_assert_macro_left2 = session;
            SparkSession $org_scalatest_assert_macro_right2 = activeSession;
            SparkSession sparkSession3 = $org_scalatest_assert_macro_left2;
            SparkSession sparkSession4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(sparkSession3 != null ? !sparkSession3.equals(sparkSession4) : sparkSession4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            String $org_scalatest_assert_macro_left3 = session.conf().get("spark-config2");
            String $org_scalatest_assert_macro_right3 = "a";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            SQLConf $org_scalatest_assert_macro_left4 = session.sessionState().conf();
            SQLConf $org_scalatest_assert_macro_right4 = SQLConf$.MODULE$.get();
            SQLConf sQLConf = $org_scalatest_assert_macro_left4;
            SQLConf sQLConf2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(sQLConf != null ? !sQLConf.equals(sQLConf2) : sQLConf2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            String $org_scalatest_assert_macro_left5 = SQLConf$.MODULE$.get().getConfString("spark-config2");
            String $org_scalatest_assert_macro_right5 = "a";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession $org_scalatest_assert_macro_left6 = SparkSession$.MODULE$.builder().getOrCreate();
            SparkSession $org_scalatest_assert_macro_right6 = defaultSession;
            SparkSession sparkSession5 = $org_scalatest_assert_macro_left6;
            SparkSession sparkSession6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(sparkSession5 != null ? !sparkSession5.equals(sparkSession6) : sparkSession6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("create a new session if the default session has been stopped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkSession newSession;
            SparkSession defaultSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession$.MODULE$.setDefaultSession(defaultSession);
            defaultSession.stop();
            SparkSession $org_scalatest_assert_macro_left = newSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession $org_scalatest_assert_macro_right = defaultSession;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, sparkSession == null ? sparkSession2 != null : !sparkSession.equals(sparkSession2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("create a new session if the active thread session has been stopped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkSession newSession;
            SparkSession activeSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession$.MODULE$.setActiveSession(activeSession);
            activeSession.stop();
            SparkSession $org_scalatest_assert_macro_left = newSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession $org_scalatest_assert_macro_right = activeSession;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, sparkSession == null ? sparkSession2 != null : !sparkSession.equals(sparkSession2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("create SparkContext first then SparkSession", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName("test").setMaster("local").set("key1", "value1");
            SparkContext sparkContext2 = new SparkContext(conf);
            SparkSession session = SparkSession$.MODULE$.builder().config("key2", "value2").getOrCreate();
            String $org_scalatest_assert_macro_left = session.conf().get("key1");
            String $org_scalatest_assert_macro_right = "value1";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            String $org_scalatest_assert_macro_left2 = session.conf().get("key2");
            String $org_scalatest_assert_macro_right2 = "value2";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            SparkContext $org_scalatest_assert_macro_left3 = session.sparkContext();
            SparkContext $org_scalatest_assert_macro_right3 = sparkContext2;
            SparkContext sparkContext = $org_scalatest_assert_macro_left3;
            SparkContext sparkContext3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(sparkContext != null ? !sparkContext.equals(sparkContext3) : sparkContext3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            SparkConf $org_scalatest_assert_macro_left4 = sparkContext2.conf();
            String $org_scalatest_assert_macro_right4 = "key2";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            String $org_scalatest_assert_macro_left5 = sparkContext2.conf().get("key1");
            String $org_scalatest_assert_macro_right5 = "value1";
            String string5 = $org_scalatest_assert_macro_left5;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("create SparkContext first then pass context to SparkSession", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName("test").setMaster("local").set("key1", "value1");
            SparkContext newSC = new SparkContext(conf);
            SparkSession session = SparkSession$.MODULE$.builder().sparkContext(newSC).config("key2", "value2").getOrCreate();
            String $org_scalatest_assert_macro_left = session.conf().get("key1");
            String $org_scalatest_assert_macro_right = "value1";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            String $org_scalatest_assert_macro_left2 = session.conf().get("key2");
            String $org_scalatest_assert_macro_right2 = "value2";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            SparkContext $org_scalatest_assert_macro_left3 = session.sparkContext();
            SparkContext $org_scalatest_assert_macro_right3 = newSC;
            SparkContext sparkContext = $org_scalatest_assert_macro_left3;
            SparkContext sparkContext2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(sparkContext != null ? !sparkContext.equals(sparkContext2) : sparkContext2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            String $org_scalatest_assert_macro_left4 = session.sparkContext().conf().get("key1");
            String $org_scalatest_assert_macro_right4 = "value1";
            String string5 = $org_scalatest_assert_macro_left4;
            String string6 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            SparkConf $org_scalatest_assert_macro_left5 = session.sparkContext().conf();
            String $org_scalatest_assert_macro_right5 = "key2";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            String $org_scalatest_assert_macro_left6 = session.sparkContext().conf().get("spark.app.name");
            String $org_scalatest_assert_macro_right6 = "test";
            String string7 = $org_scalatest_assert_macro_left6;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("SPARK-15887: hive-site.xml should be loaded", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            String $org_scalatest_assert_macro_left = session.sessionState().newHadoopConf().get("hive.in.test");
            String $org_scalatest_assert_macro_right = "true";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            String $org_scalatest_assert_macro_left2 = session.sparkContext().hadoopConfiguration().get("hive.in.test");
            String $org_scalatest_assert_macro_right2 = "true";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("SPARK-15991: Set global Hadoop conf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            String mySpecialKey = "my.special.key.15991";
            String mySpecialValue = "msv";
            try {
                session.sparkContext().hadoopConfiguration().set(mySpecialKey, mySpecialValue);
                String $org_scalatest_assert_macro_left = session.sessionState().newHadoopConf().get(mySpecialKey);
                String $org_scalatest_assert_macro_right = mySpecialValue;
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            }
            finally {
                session.sparkContext().hadoopConfiguration().unset(mySpecialKey);
            }
            return assertion;
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("SPARK-31234: RESET command will not change static sql configs and spark context conf values in SessionState", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31234").config("spark.app.name", "test-app-SPARK-31234").getOrCreate();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(session.sessionState().conf().getConfString("spark.app.name"));
            String $org_scalatest_assert_macro_right = "test-app-SPARK-31234";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(session.sessionState().conf().getConf(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right2 = "globaltempdb-spark-31234";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            session.sql("RESET");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(session.sessionState().conf().getConfString("spark.app.name"));
            String $org_scalatest_assert_macro_right3 = "test-app-SPARK-31234";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(session.sessionState().conf().getConf(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right4 = "globaltempdb-spark-31234";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        this.test("SPARK-31354: SparkContext only register one SparkSession ApplicationEnd listener", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("test-app-SPARK-31354-1");
            SparkContext context = new SparkContext(conf);
            SparkSession$.MODULE$.builder().sparkContext(context).master("local").getOrCreate();
            int postFirstCreation = context.listenerBus().listeners().size();
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession$.MODULE$.clearDefaultSession();
            SparkSession$.MODULE$.builder().sparkContext(context).master("local").getOrCreate();
            int postSecondCreation = context.listenerBus().listeners().size();
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession$.MODULE$.clearDefaultSession();
            int $org_scalatest_assert_macro_left = postFirstCreation;
            int $org_scalatest_assert_macro_right = postSecondCreation;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("SPARK-31532: should not propagate static sql configs to the existing active/default SparkSession", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31532").config("spark.app.name", "test-app-SPARK-31532").getOrCreate();
            SparkSession session1 = SparkSession$.MODULE$.builder().config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31532-1").getOrCreate();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right = "globaltempdb-spark-31532";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(session1.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right2 = "globaltempdb-spark-31532";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession session2 = SparkSession$.MODULE$.builder().config(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), "SPARK-31532-db").config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31532-2").getOrCreate();
            String $org_scalatest_assert_macro_left3 = (String)session.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH());
            String $org_scalatest_assert_macro_right3 = "SPARK-31532-db";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH()));
            String $org_scalatest_assert_macro_right4 = (String)session2.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(session2.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right5 = "globaltempdb-spark-31532";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("SPARK-31532: propagate static sql configs if no existing SparkSession", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("test-app-SPARK-31532-2").set(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globaltempdb-spark-31532").set(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), "SPARK-31532-db");
            SparkContext$.MODULE$.getOrCreate(conf);
            SparkSession session = SparkSession$.MODULE$.builder().config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31532-2").config(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), "SPARK-31532-db-2").getOrCreate();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(session.conf().get("spark.app.name"));
            String $org_scalatest_assert_macro_right = "test-app-SPARK-31532-2";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right2 = "globaltempdb-spark-31532-2";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH()));
            String $org_scalatest_assert_macro_right3 = "SPARK-31532-db-2";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        this.test("SPARK-32062: reset listenerRegistered in SparkSession", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName(new StringBuilder(17).append("test-SPARK-32062-").append(i).toString());
            SparkContext context = new SparkContext(conf);
            int beforeListenerSize = context.listenerBus().listeners().size();
            SparkSession$.MODULE$.builder().sparkContext(context).getOrCreate();
            int afterListenerSize = context.listenerBus().listeners().size();
            int $org_scalatest_assert_macro_left = beforeListenerSize + 1;
            int $org_scalatest_assert_macro_right = afterListenerSize;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            context.stop();
        }), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        this.test("SPARK-32160: Disallow to create SparkSession in executors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String error;
            SparkSession session = SparkSession$.MODULE$.builder().master("local-cluster[3, 1, 1024]").getOrCreate();
            String $org_scalatest_assert_macro_left = error = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> session.range(1L).foreach((Function1 & Serializable & scala.Serializable)v -> {
                SparkSessionBuilderSuite.$anonfun$new$22(v);
                return BoxedUnit.UNIT;
            }), ClassTag$.MODULE$.apply(SparkException.class), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266))).getMessage();
            String $org_scalatest_assert_macro_right = "SparkSession should only be created and accessed on the driver.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        this.test("SPARK-32160: Allow to create SparkSession in executors if the config is set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local-cluster[3, 1, 1024]").getOrCreate();
            session.range(1L).foreach((Function1 & Serializable & scala.Serializable)v -> {
                SparkSessionBuilderSuite.$anonfun$new$24(v);
                return BoxedUnit.UNIT;
            });
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        this.test("SPARK-32991: Use conf in shared state as the original configuration for RESET", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String wh = "spark.sql.warehouse.dir";
            String td = "spark.sql.globalTempDatabase";
            String custom = "spark.sql.custom";
            SparkConf conf = new SparkConf().setMaster("local").setAppName("SPARK-32991").set(wh, "./data1").set(td, "bob");
            SparkContext sc = new SparkContext(conf);
            SparkSession spark = SparkSession$.MODULE$.builder().config(wh, "./data2").config(td, "alice").config(custom, "kyao").getOrCreate();
            String sharedWH = spark.sharedState().conf().get(wh);
            String sharedTD = spark.sharedState().conf().get(td);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(sharedWH);
            String $org_scalatest_assert_macro_right = "./data2";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The warehouse dir in shared state should be determined by the 1st created spark session", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(sharedTD);
            String $org_scalatest_assert_macro_right2 = "alice";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Static sql configs in shared state should be determined by the 1st created spark session", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
            Option $org_scalatest_assert_macro_left3 = spark.sharedState().conf().getOption(custom);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Dynamic sql configs is session specific", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(spark.conf().get(wh));
            String $org_scalatest_assert_macro_right3 = sharedWH;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"The warehouse dir in session conf and shared state conf should be consistent", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(spark.conf().get(td));
            String $org_scalatest_assert_macro_right4 = sharedTD;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"Static sql configs in session conf and shared state conf should be consistent", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(spark.conf().get(custom));
            String $org_scalatest_assert_macro_right5 = "kyao";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"Dynamic sql configs is session specific", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            spark.sql("RESET");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(spark.conf().get(wh));
            String $org_scalatest_assert_macro_right6 = sharedWH;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"The warehouse dir in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(spark.conf().get(td));
            String $org_scalatest_assert_macro_right7 = sharedTD;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"Static sql configs in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(spark.conf().get(custom));
            String $org_scalatest_assert_macro_right8 = "kyao";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"Dynamic sql configs in session initial map should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
            SparkSession spark2 = SparkSession$.MODULE$.builder().config(wh, "./data3").config(custom, "kyaoo").getOrCreate();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(spark2.conf().get(wh));
            String $org_scalatest_assert_macro_right9 = sharedWH;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(spark2.conf().get(td));
            String $org_scalatest_assert_macro_right10 = sharedTD;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(spark2.conf().get(custom));
            String $org_scalatest_assert_macro_right11 = "kyaoo";
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        this.test("SPARK-32991: RESET should work properly with multi threads", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String wh = "spark.sql.warehouse.dir";
            String td = "spark.sql.globalTempDatabase";
            String custom = "spark.sql.custom";
            SparkSession spark = (SparkSession)ThreadUtils$.MODULE$.runInNewThread("new session 0", false, (Function0 & Serializable & scala.Serializable)() -> SparkSession$.MODULE$.builder().master("local").config(wh, "./data0").config(td, "bob").config(custom, "c0").getOrCreate());
            spark.sql(new StringBuilder(7).append("SET ").append(custom).append("=c1").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(spark.conf().get(custom));
            String $org_scalatest_assert_macro_right = "c1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            spark.sql("RESET");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(spark.conf().get(wh));
            String $org_scalatest_assert_macro_right2 = "./data0";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The warehouse dir in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(spark.conf().get(td));
            String $org_scalatest_assert_macro_right3 = "bob";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Static sql configs in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(spark.conf().get(custom));
            String $org_scalatest_assert_macro_right4 = "c0";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Dynamic sql configs in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            SparkSession spark1 = (SparkSession)ThreadUtils$.MODULE$.runInNewThread("new session 1", false, (Function0 & Serializable & scala.Serializable)() -> SparkSession$.MODULE$.builder().getOrCreate());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(spark);
            SparkSession $org_scalatest_assert_macro_right5 = spark1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            SparkSession$.MODULE$.clearDefaultSession();
            SparkSession spark2 = (SparkSession)ThreadUtils$.MODULE$.runInNewThread("new session 2", false, (Function0 & Serializable & scala.Serializable)() -> SparkSession$.MODULE$.builder().master("local").config(wh, "./data1").config(td, "alice").config(custom, "c2").getOrCreate());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(spark2);
            SparkSession $org_scalatest_assert_macro_right6 = spark;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!==", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$bang$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            spark2.sql(new StringBuilder(7).append("SET ").append(custom).append("=c1").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(spark2.conf().get(custom));
            String $org_scalatest_assert_macro_right7 = "c1";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            spark2.sql("RESET");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(spark2.conf().get(wh));
            String $org_scalatest_assert_macro_right8 = "./data1";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(spark2.conf().get(td));
            String $org_scalatest_assert_macro_right9 = "alice";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(spark2.conf().get(custom));
            String $org_scalatest_assert_macro_right10 = "c2";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        this.test("SPARK-33944: warning setting hive.metastore.warehouse.dir using session options", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String msg = "Not allowing to set hive.metastore.warehouse.dir in SparkSession's options";
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, msg, this.LogAppender().$lessinit$greater$default$2());
            this.withLogAppender((Appender)logAppender, this.withLogAppender$default$2(), this.withLogAppender$default$3(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SparkSession$.MODULE$.builder().master("local").config("hive.metastore.warehouse.dir", "any").getOrCreate().sharedState());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logAppender.loggingEvents().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkSessionBuilderSuite.$anonfun$new$32(msg, x$3))), "logAppender.loggingEvents.exists(((x$3: org.apache.log4j.spi.LoggingEvent) => x$3.getRenderedMessage().contains(msg)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
        this.test("SPARK-33944: no warning setting spark.sql.warehouse.dir using session options", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String msg = "Not allowing to set hive.metastore.warehouse.dir in SparkSession's options";
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, msg, this.LogAppender().$lessinit$greater$default$2());
            this.withLogAppender((Appender)logAppender, this.withLogAppender$default$2(), this.withLogAppender$default$3(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SparkSession$.MODULE$.builder().master("local").config("spark.sql.warehouse.dir", "any").getOrCreate().sharedState());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(logAppender.loggingEvents().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SparkSessionBuilderSuite.$anonfun$new$35(msg, x$4))), "logAppender.loggingEvents.exists(((x$4: org.apache.log4j.spi.LoggingEvent) => x$4.getRenderedMessage().contains(msg)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
    }
}

